/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.codec.jpeg;

import com.pixelmed.codec.jpeg.HuffmanTable;
import com.pixelmed.codec.jpeg.MarkerSegmentSOF;
import com.pixelmed.codec.jpeg.MarkerSegmentSOS;
import com.pixelmed.codec.jpeg.Markers;
import com.pixelmed.codec.jpeg.OutputArrayOrStream;
import com.pixelmed.codec.jpeg.Parse;
import com.pixelmed.codec.jpeg.QuantizationTable;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;

public class EntropyCodedSegment {
    private static final String identString = "@(#) $Header: /userland/cvs/codec/com/pixelmed/codec/jpeg/EntropyCodedSegment.java,v 1.24 2016/01/16 13:30:09 dclunie Exp $";
    private boolean copying;
    private boolean decompressing;
    private OutputArrayOrStream[] decompressedOutputPerComponent;
    private boolean isHuffman;
    private boolean isDCT;
    private boolean isLossless;
    private ByteArrayOutputStream copiedBytes;
    private final MarkerSegmentSOS sos;
    private final MarkerSegmentSOF sof;
    private final Map<String, HuffmanTable> htByClassAndIdentifer;
    private final Map<String, QuantizationTable> qtByIdentifer;
    private final int nComponents;
    private final int[] DCEntropyCodingTableSelector;
    private final int[] ACEntropyCodingTableSelector;
    private final int[] HorizontalSamplingFactor;
    private final int[] VerticalSamplingFactor;
    private final int maxHorizontalSamplingFactor;
    private final int maxVerticalSamplingFactor;
    private final int nMCUHorizontally;
    private final Vector<Shape> redactionShapes;
    private final int predictorForFirstSample;
    private final int[] predictorForComponent;
    private final int predictorSelectionValue;
    private int[] rowNumberAtBeginningOfRestartInterval;
    private final int[] rowLength;
    private final int[] currentRowNumber;
    private final int[] positionWithinRow;
    private final int[][] previousReconstructedRow;
    private final int[][] currentReconstructedRow;
    private byte[] bytesToDecompress;
    private int availableBytes;
    private int byteIndex;
    private int bitIndex;
    private int currentByte;
    private int currentBits;
    private int haveBits;
    private static final int[] extractBitFromByteMask = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    private int writeByte;
    private int writeBitIndex;
    private HuffmanTable usingTable = null;
    private int[] dcSignBitMask;
    private int[] maxAmplitude;

    private final void getEnoughBits(int n) throws Exception {
        while (this.haveBits < n) {
            if (this.bitIndex > 7) {
                if (this.byteIndex < this.availableBytes) {
                    this.currentByte = this.bytesToDecompress[this.byteIndex++];
                    this.bitIndex = 0;
                } else {
                    throw new Exception("No more bits (having decompressed " + this.byteIndex + " dec bytes)");
                }
            }
            int n2 = (this.currentByte & extractBitFromByteMask[this.bitIndex++]) == 0 ? 0 : 1;
            this.currentBits = (this.currentBits << 1) + n2;
            ++this.haveBits;
        }
    }

    private final void initializeWriteBits() {
        this.copiedBytes = new ByteArrayOutputStream();
        this.writeByte = 0;
        this.writeBitIndex = 0;
    }

    private final void flushWriteBits() {
        if (this.writeBitIndex > 0) {
            while (this.writeBitIndex < 8) {
                this.writeByte |= extractBitFromByteMask[this.writeBitIndex];
                ++this.writeBitIndex;
            }
            this.copiedBytes.write(this.writeByte);
            if ((this.writeByte & 0xFF) == 255) {
                this.copiedBytes.write(0);
            }
            this.writeByte = 0;
            this.writeBitIndex = 0;
        }
    }

    private final void writeBits(int n, int n2) {
        if (n2 > 0) {
            int n3 = n2 - 1;
            while (n3 >= 0) {
                int n4 = 1 << n3;
                int n5 = n & n4;
                if (n5 != 0) {
                    this.writeByte |= extractBitFromByteMask[this.writeBitIndex];
                }
                ++this.writeBitIndex;
                if (this.writeBitIndex > 7) {
                    this.copiedBytes.write(this.writeByte);
                    if ((this.writeByte & 0xFF) == 255) {
                        this.copiedBytes.write(0);
                    }
                    this.writeByte = 0;
                    this.writeBitIndex = 0;
                }
                --n3;
            }
        }
    }

    private final int decode() throws Exception {
        int[] nArray = this.usingTable.getMINCODE();
        int[] nArray2 = this.usingTable.getMAXCODE();
        int[] nArray3 = this.usingTable.getVALPTR();
        int[] nArray4 = this.usingTable.getHUFFVAL();
        int n = 1;
        this.getEnoughBits(n);
        int n2 = this.currentBits;
        while (n < nArray2.length && n2 > nArray2[n]) {
            this.getEnoughBits(++n);
            n2 = this.currentBits;
        }
        int n3 = 0;
        if (n < nArray2.length) {
            int n4 = nArray3[n];
            n4 = n4 + n2 - nArray[n];
            n3 = nArray4[n4];
        }
        if (this.copying) {
            this.writeBits(this.currentBits, this.haveBits);
        }
        this.currentBits = 0;
        this.haveBits = 0;
        return n3;
    }

    private final int getValueOfRequestedLength(int n) throws Exception {
        this.getEnoughBits(n);
        int n2 = this.currentBits;
        if (this.copying) {
            this.writeBits(this.currentBits, this.haveBits);
        }
        this.currentBits = 0;
        this.haveBits = 0;
        return n2;
    }

    private final int convertSignAndAmplitudeBitsToValue(int n, int n2) throws Exception {
        if (n2 > 0 && (n & this.dcSignBitMask[n2]) == 0) {
            n -= this.maxAmplitude[n2];
        }
        return n;
    }

    private final void writeEntropyCodedAllZeroACCoefficients() {
        this.writeBits(this.usingTable.getEOBCode(), this.usingTable.getEOBCodeLength());
    }

    public EntropyCodedSegment(MarkerSegmentSOS markerSegmentSOS, MarkerSegmentSOF markerSegmentSOF, Map<String, HuffmanTable> map, Map<String, QuantizationTable> map2, int n, Vector<Shape> vector, boolean bl, boolean bl2, boolean bl3, Parse.DecompressedOutput decompressedOutput) throws Exception {
        int[] nArray = new int[16];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 4;
        nArray[4] = 8;
        nArray[5] = 16;
        nArray[6] = 32;
        nArray[7] = 64;
        nArray[8] = 128;
        nArray[9] = 256;
        nArray[10] = 512;
        nArray[11] = 1024;
        nArray[12] = 2048;
        nArray[13] = 4096;
        nArray[14] = 8192;
        nArray[15] = 16384;
        this.dcSignBitMask = nArray;
        int[] nArray2 = new int[16];
        nArray2[1] = 1;
        nArray2[2] = 3;
        nArray2[3] = 7;
        nArray2[4] = 15;
        nArray2[5] = 31;
        nArray2[6] = 63;
        nArray2[7] = 127;
        nArray2[8] = 255;
        nArray2[9] = 511;
        nArray2[10] = 1023;
        nArray2[11] = 2047;
        nArray2[12] = 4095;
        nArray2[13] = 8191;
        nArray2[14] = 16383;
        nArray2[15] = Short.MAX_VALUE;
        this.maxAmplitude = nArray2;
        this.sos = markerSegmentSOS;
        this.sof = markerSegmentSOF;
        this.htByClassAndIdentifer = map;
        this.qtByIdentifer = map2;
        this.nMCUHorizontally = n;
        this.redactionShapes = vector;
        this.copying = bl;
        this.decompressing = bl3;
        this.decompressedOutputPerComponent = decompressedOutput == null ? null : decompressedOutput.getDecompressedOutputPerComponent();
        this.isHuffman = Markers.isHuffman(markerSegmentSOF.getMarker());
        if (!this.isHuffman) {
            throw new Exception("Only Huffman processes supported (not " + Markers.getAbbreviation(markerSegmentSOF.getMarker()) + " " + Markers.getDescription(markerSegmentSOF.getMarker()) + ")");
        }
        this.isDCT = Markers.isDCT(markerSegmentSOF.getMarker());
        this.isLossless = Markers.isLossless(markerSegmentSOF.getMarker());
        this.nComponents = markerSegmentSOS.getNComponentsPerScan();
        this.DCEntropyCodingTableSelector = markerSegmentSOS.getDCEntropyCodingTableSelector();
        this.ACEntropyCodingTableSelector = markerSegmentSOS.getACEntropyCodingTableSelector();
        this.HorizontalSamplingFactor = markerSegmentSOF.getHorizontalSamplingFactor();
        this.VerticalSamplingFactor = markerSegmentSOF.getVerticalSamplingFactor();
        this.maxHorizontalSamplingFactor = EntropyCodedSegment.max(this.HorizontalSamplingFactor);
        this.maxVerticalSamplingFactor = EntropyCodedSegment.max(this.VerticalSamplingFactor);
        if (this.isLossless && bl3) {
            this.predictorForFirstSample = 1 << markerSegmentSOF.getSamplePrecision() - markerSegmentSOS.getSuccessiveApproximationBitPositionLowOrPointTransform() - 1;
            this.predictorForComponent = new int[this.nComponents];
            this.predictorSelectionValue = markerSegmentSOS.getStartOfSpectralOrPredictorSelection();
            this.rowLength = new int[this.nComponents];
            this.currentRowNumber = new int[this.nComponents];
            this.positionWithinRow = new int[this.nComponents];
            this.rowNumberAtBeginningOfRestartInterval = new int[this.nComponents];
            this.previousReconstructedRow = new int[this.nComponents][];
            this.currentReconstructedRow = new int[this.nComponents][];
            int n2 = 0;
            while (n2 < this.nComponents) {
                this.rowLength[n2] = (markerSegmentSOF.getNSamplesPerLine() - 1) / markerSegmentSOF.getHorizontalSamplingFactor()[n2] + 1;
                this.currentRowNumber[n2] = 0;
                this.positionWithinRow[n2] = 0;
                this.rowNumberAtBeginningOfRestartInterval[n2] = 0;
                this.previousReconstructedRow[n2] = new int[this.rowLength[n2]];
                this.currentReconstructedRow[n2] = new int[this.rowLength[n2]];
                ++n2;
            }
        } else {
            this.predictorForFirstSample = 0;
            this.predictorForComponent = null;
            this.predictorSelectionValue = 0;
            this.rowLength = null;
            this.currentRowNumber = null;
            this.positionWithinRow = null;
            this.rowNumberAtBeginningOfRestartInterval = null;
            this.previousReconstructedRow = null;
            this.currentReconstructedRow = null;
        }
        if (bl2) {
            this.dumpHuffmanTables();
        }
    }

    private final int getOneLosslessValue(int n, int n2, int n3, int n4) throws Exception {
        int n5;
        int n6 = 0;
        if (this.decompressing) {
            if (this.currentRowNumber[n] == this.rowNumberAtBeginningOfRestartInterval[n]) {
                n6 = this.positionWithinRow[n] == 0 ? this.predictorForFirstSample : this.currentReconstructedRow[n][this.positionWithinRow[n] - 1];
            } else if (this.positionWithinRow[n] == 0) {
                n6 = this.previousReconstructedRow[n][0];
            } else {
                switch (this.predictorSelectionValue) {
                    case 1: {
                        n6 = this.currentReconstructedRow[n][this.positionWithinRow[n] - 1];
                        break;
                    }
                    case 2: {
                        n6 = this.previousReconstructedRow[n][this.positionWithinRow[n]];
                        break;
                    }
                    case 3: {
                        n6 = this.previousReconstructedRow[n][this.positionWithinRow[n] - 1];
                        break;
                    }
                    case 4: {
                        n6 = this.currentReconstructedRow[n][this.positionWithinRow[n] - 1] + this.previousReconstructedRow[n][this.positionWithinRow[n]] - this.previousReconstructedRow[n][this.positionWithinRow[n] - 1];
                        break;
                    }
                    case 5: {
                        n6 = this.currentReconstructedRow[n][this.positionWithinRow[n] - 1] + (this.previousReconstructedRow[n][this.positionWithinRow[n]] - this.previousReconstructedRow[n][this.positionWithinRow[n] - 1] >> 1);
                        break;
                    }
                    case 6: {
                        n6 = this.previousReconstructedRow[n][this.positionWithinRow[n]] + (this.currentReconstructedRow[n][this.positionWithinRow[n] - 1] - this.previousReconstructedRow[n][this.positionWithinRow[n] - 1] >> 1);
                        break;
                    }
                    case 7: {
                        n6 = this.currentReconstructedRow[n][this.positionWithinRow[n] - 1] + this.previousReconstructedRow[n][this.positionWithinRow[n]] >> 1;
                        break;
                    }
                    default: {
                        throw new Exception("Unrecognized predictor selection value " + this.predictorSelectionValue);
                    }
                }
            }
        }
        this.usingTable = this.htByClassAndIdentifer.get("0+" + Integer.toString(n2));
        int n7 = this.decode();
        int n8 = 0;
        if (n7 == 0) {
            n8 = 0;
        } else if (n7 == 16) {
            n8 = 32768;
        } else {
            n5 = this.getValueOfRequestedLength(n7);
            n8 = this.convertSignAndAmplitudeBitsToValue(n5, n7);
        }
        n5 = 0;
        if (this.decompressing) {
            this.currentReconstructedRow[n][this.positionWithinRow[n]] = n5 = n8 + n6 & 0xFFFF;
            int n9 = n;
            this.positionWithinRow[n9] = this.positionWithinRow[n9] + 1;
            if (this.positionWithinRow[n] >= this.rowLength[n]) {
                this.positionWithinRow[n] = 0;
                int n10 = n;
                this.currentRowNumber[n10] = this.currentRowNumber[n10] + 1;
                int[] nArray = this.previousReconstructedRow[n];
                this.previousReconstructedRow[n] = this.currentReconstructedRow[n];
                this.currentReconstructedRow[n] = nArray;
            }
        }
        return n5;
    }

    private final void getOneDCTDataUnit(int n, int n2, boolean bl) throws Exception {
        int n3;
        this.usingTable = this.htByClassAndIdentifer.get("0+" + Integer.toString(n));
        int n4 = this.decode();
        if (n4 != 0 && n4 != 16) {
            n3 = this.getValueOfRequestedLength(n4);
            this.convertSignAndAmplitudeBitsToValue(n3, n4);
        }
        this.usingTable = this.htByClassAndIdentifer.get("1+" + Integer.toString(n2));
        n4 = this.copying ? 1 : 0;
        if (bl && this.copying) {
            this.copying = false;
            this.writeEntropyCodedAllZeroACCoefficients();
        }
        n3 = 1;
        while (n3 < 64) {
            int n5 = this.decode();
            if (n5 == 0) break;
            if (n5 == 240) {
                n3 += 16;
                continue;
            }
            int n6 = n5 >>> 4;
            int n7 = n5 & 0xF;
            int n8 = this.getValueOfRequestedLength(n7);
            this.convertSignAndAmplitudeBitsToValue(n8, n7);
            n3 += n6;
            ++n3;
        }
        this.copying = n4;
    }

    private final boolean redactionDecision(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Vector<Shape> vector) {
        int n9 = 8 * n6;
        int n10 = 8 * n5;
        int n11 = n * n10;
        int n12 = n2 * n9;
        int n13 = 8 * n5 / n3;
        int n14 = 8 * n6 / n4;
        int n15 = n11 + n7 * n13;
        int n16 = n12 + n8 * n14;
        Rectangle rectangle = new Rectangle(n15, n16, n13, n14);
        boolean bl = false;
        if (vector != null) {
            for (Shape shape : vector) {
                if (!shape.intersects(rectangle)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private final void writeDecompressedPixel(int n, int n2) throws IOException {
        if (this.sof.getSamplePrecision() <= 8) {
            this.decompressedOutputPerComponent[n].writeByte(n2);
        } else {
            this.decompressedOutputPerComponent[n].writeShort(n2);
        }
    }

    private final void getOneMinimumCodedUnit(int n, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n2, int n3, int n4, int n5, Vector<Shape> vector) throws Exception, IOException {
        int n6 = 0;
        while (n6 < n) {
            int n7 = 0;
            while (n7 < nArray4[n6]) {
                int n8 = 0;
                while (n8 < nArray3[n6]) {
                    boolean bl = this.redactionDecision(n4, n5, nArray3[n6], nArray4[n6], n2, n3, n8, n7, vector);
                    if (this.isDCT) {
                        this.getOneDCTDataUnit(nArray[n6], nArray2[n6], bl);
                    } else if (this.isLossless) {
                        int n9 = this.getOneLosslessValue(n6, nArray[n6], n4, n5);
                        if (this.decompressing) {
                            this.writeDecompressedPixel(n6, n9);
                        }
                    } else {
                        throw new Exception("Only DCT or Lossless processes supported (not " + Markers.getAbbreviation(this.sof.getMarker()) + " " + Markers.getDescription(this.sof.getMarker()) + ")");
                    }
                    ++n8;
                }
                ++n7;
            }
            ++n6;
        }
    }

    private static final int max(int[] nArray) {
        int n = Integer.MIN_VALUE;
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            if (n4 > n) {
                n = n4;
            }
            ++n3;
        }
        return n;
    }

    public final byte[] finish(byte[] byArray, int n, int n2) throws Exception, IOException {
        int n3;
        this.bytesToDecompress = byArray;
        this.availableBytes = this.bytesToDecompress.length;
        this.byteIndex = 0;
        this.bitIndex = 8;
        this.haveBits = 0;
        if (this.copying) {
            this.initializeWriteBits();
        }
        if (this.rowNumberAtBeginningOfRestartInterval != null) {
            n3 = 0;
            while (n3 < this.nComponents) {
                this.rowNumberAtBeginningOfRestartInterval[n3] = this.currentRowNumber[n3];
                ++n3;
            }
        }
        n3 = 0;
        while (n3 < n) {
            int n4 = n2 / this.nMCUHorizontally;
            int n5 = n2 % this.nMCUHorizontally;
            this.getOneMinimumCodedUnit(this.nComponents, this.DCEntropyCodingTableSelector, this.ACEntropyCodingTableSelector, this.HorizontalSamplingFactor, this.VerticalSamplingFactor, this.maxHorizontalSamplingFactor, this.maxVerticalSamplingFactor, n5, n4, this.redactionShapes);
            ++n2;
            ++n3;
        }
        if (this.copying) {
            this.flushWriteBits();
        }
        return this.copying ? this.copiedBytes.toByteArray() : null;
    }

    private final void dumpHuffmanTables() {
        System.err.print("\n");
        for (HuffmanTable huffmanTable : this.htByClassAndIdentifer.values()) {
            System.err.print(huffmanTable.toString());
        }
    }

    private final void dumpQuantizationTables() {
        System.err.print("\n");
        for (QuantizationTable quantizationTable : this.qtByIdentifer.values()) {
            System.err.print(quantizationTable.toString());
        }
    }
}

