/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.codec.jpeg;

public class HuffmanTable {
    private static final String identString = "@(#) $Header: /userland/cvs/codec/com/pixelmed/codec/jpeg/HuffmanTable.java,v 1.4 2014/03/23 11:41:54 dclunie Exp $";
    private int TableClass;
    private int HuffmanTableIdentifier;
    private int[] nHuffmanCodesOfLengthI;
    private int[][] ValueOfHuffmanCodeIJ;
    private int[] BITS = new int[17];
    private int[] HUFFVAL;
    private int[] HUFFSIZE;
    private int[] HUFFCODE;
    private int[] MINCODE = new int[17];
    private int[] MAXCODE = new int[17];
    private int[] VALPTR = new int[17];
    private int EOBCode;
    private int EOBCodeLength;

    public HuffmanTable(int n, int n2, int[] nArray, int[][] nArray2) {
        this.TableClass = n;
        this.HuffmanTableIdentifier = n2;
        this.nHuffmanCodesOfLengthI = nArray;
        this.ValueOfHuffmanCodeIJ = nArray2;
        this.expand();
    }

    private int countNumberOfCodes() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.nHuffmanCodesOfLengthI.length) {
            n += this.nHuffmanCodesOfLengthI[n2];
            ++n2;
        }
        return n;
    }

    public int[] getMINCODE() {
        return this.MINCODE;
    }

    public int[] getMAXCODE() {
        return this.MAXCODE;
    }

    public int[] getVALPTR() {
        return this.VALPTR;
    }

    public int[] getHUFFVAL() {
        return this.HUFFVAL;
    }

    public int getEOBCode() {
        return this.EOBCode;
    }

    public int getEOBCodeLength() {
        return this.EOBCodeLength;
    }

    private void expand() {
        int n;
        int n2 = 1;
        while (n2 <= 16) {
            this.BITS[n2] = this.nHuffmanCodesOfLengthI[n2 - 1];
            ++n2;
        }
        n2 = this.countNumberOfCodes();
        this.HUFFVAL = new int[n2 + 1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.nHuffmanCodesOfLengthI.length) {
            n = this.nHuffmanCodesOfLengthI[n4];
            if (n > 0) {
                int n5 = 0;
                while (n5 < n) {
                    this.HUFFVAL[n3] = this.ValueOfHuffmanCodeIJ[n4][n5];
                    ++n3;
                    ++n5;
                }
            }
            ++n4;
        }
        this.HUFFSIZE = new int[n2 + 1];
        n3 = 0;
        n4 = 1;
        n = 1;
        while (true) {
            if (n > this.BITS[n4]) {
                n = 1;
                if (++n4 <= 16) continue;
                break;
            }
            this.HUFFSIZE[n3] = n4;
            ++n3;
            ++n;
        }
        this.HUFFSIZE[n3] = 0;
        this.HUFFCODE = new int[n2 + 1];
        n3 = 0;
        n4 = 0;
        n = this.HUFFSIZE[0];
        while (true) {
            this.HUFFCODE[n3] = n4++;
            if (n == this.HUFFSIZE[++n3]) continue;
            if (this.HUFFSIZE[n3] == 0) break;
            do {
                n4 <<= 1;
            } while (++n != this.HUFFSIZE[n3]);
        }
        n3 = 0;
        n4 = 0;
        while (++n3 <= 16) {
            if (this.BITS[n3] == 0) {
                this.MAXCODE[n3] = -1;
                continue;
            }
            this.VALPTR[n3] = n4;
            this.MINCODE[n3] = this.HUFFCODE[n4];
            n4 = n4 + this.BITS[n3] - 1;
            this.MAXCODE[n3] = this.HUFFCODE[n4];
            ++n4;
        }
        n3 = 1;
        while (n3 <= 16) {
            n4 = this.VALPTR[n3];
            while (n4 < this.VALPTR[n3] + this.BITS[n3]) {
                if (this.HUFFVAL[n4] == 0) {
                    this.EOBCode = this.HUFFCODE[n4];
                    this.EOBCodeLength = n3;
                }
                ++n4;
            }
            ++n3;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Huffman Table:\n");
        stringBuffer.append("\t TableClass = " + this.TableClass + "\n");
        stringBuffer.append("\t HuffmanTableIdentifier = " + this.HuffmanTableIdentifier + "\n");
        int n = 0;
        while (n < 16) {
            stringBuffer.append("\t\t nHuffmanCodesOfLength " + n + " = " + this.nHuffmanCodesOfLengthI[n] + "\n");
            int n2 = 0;
            while (n2 < this.nHuffmanCodesOfLengthI[n]) {
                stringBuffer.append("\t\t\t ValueOfHuffmanCode " + n2 + " = " + this.ValueOfHuffmanCodeIJ[n][n2] + "\n");
                ++n2;
            }
            ++n;
        }
        stringBuffer.append("\t Expanded:\n");
        n = 1;
        while (n <= 16) {
            stringBuffer.append("\t\t[" + n + "] MINCODE=" + Integer.toBinaryString(this.MINCODE[n]) + " MAXCODE=" + Integer.toBinaryString(this.MAXCODE[n]) + " VALPTR=" + this.VALPTR[n] + "\n");
            ++n;
        }
        n = 0;
        while (n < this.HUFFVAL.length) {
            stringBuffer.append("\t\t[" + n + "] HUFFVAL=0x" + Integer.toHexString(this.HUFFVAL[n]) + "\n");
            ++n;
        }
        stringBuffer.append("\t\tEOBCode=" + Integer.toBinaryString(this.EOBCode) + " 0x" + Integer.toHexString(this.EOBCode) + " (length " + this.EOBCodeLength + " dec)\n");
        return stringBuffer.toString();
    }
}

