/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.codec.jpeg;

import com.pixelmed.codec.jpeg.HuffmanTable;
import com.pixelmed.codec.jpeg.Utilities;
import java.util.Map;

public class MarkerSegmentDHT {
    private static final String identString = "@(#) $Header: /userland/cvs/codec/com/pixelmed/codec/jpeg/MarkerSegmentDHT.java,v 1.2 2014/03/21 21:46:20 dclunie Exp $";
    private int nTables = 0;
    private int[] TableClass = new int[4];
    private int[] HuffmanTableIdentifier = new int[4];
    private int[][] nHuffmanCodesOfLengthI = new int[4][];
    private int[][][] ValueOfHuffmanCodeIJ = new int[4][][];

    public MarkerSegmentDHT(byte[] byArray, int n) throws Exception {
        int n2 = 0;
        while (n > 0) {
            if (this.nTables >= 4) {
                throw new Exception("Only 4 tables are permitted");
            }
            this.TableClass[this.nTables] = Utilities.extract8(byArray, n2) >> 4;
            this.HuffmanTableIdentifier[this.nTables] = Utilities.extract8(byArray, n2) & 0xF;
            ++n2;
            --n;
            this.nHuffmanCodesOfLengthI[this.nTables] = new int[16];
            int n3 = 0;
            while (n3 < 16) {
                this.nHuffmanCodesOfLengthI[this.nTables][n3] = Utilities.extract8(byArray, n2);
                ++n2;
                --n;
                ++n3;
            }
            this.ValueOfHuffmanCodeIJ[this.nTables] = new int[16][];
            n3 = 0;
            while (n3 < 16) {
                this.ValueOfHuffmanCodeIJ[this.nTables][n3] = new int[this.nHuffmanCodesOfLengthI[this.nTables][n3]];
                int n4 = 0;
                while (n4 < this.nHuffmanCodesOfLengthI[this.nTables][n3]) {
                    this.ValueOfHuffmanCodeIJ[this.nTables][n3][n4] = Utilities.extract8(byArray, n2);
                    ++n2;
                    --n;
                    ++n4;
                }
                ++n3;
            }
            ++this.nTables;
        }
    }

    public void addToMapByClassAndIdentifier(Map<String, HuffmanTable> map) {
        int n = 0;
        while (n < this.nTables) {
            int n2 = this.TableClass[n];
            int n3 = this.HuffmanTableIdentifier[n];
            String string = String.valueOf(Integer.toString(n2)) + "+" + Integer.toString(n3);
            map.put(string, new HuffmanTable(n2, n3, this.nHuffmanCodesOfLengthI[n], this.ValueOfHuffmanCodeIJ[n]));
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\tDHT:\n");
        int n = 0;
        while (n < this.nTables) {
            stringBuffer.append("\t\t TableClass = " + this.TableClass[n] + "\n");
            stringBuffer.append("\t\t HuffmanTableIdentifier = " + this.HuffmanTableIdentifier[n] + "\n");
            int n2 = 0;
            while (n2 < 16) {
                stringBuffer.append("\t\t\t nHuffmanCodesOfLength " + n2 + " = " + this.nHuffmanCodesOfLengthI[n][n2] + "\n");
                int n3 = 0;
                while (n3 < this.nHuffmanCodesOfLengthI[n][n2]) {
                    stringBuffer.append("\t\t\t\t ValueOfHuffmanCode " + n3 + " = " + this.ValueOfHuffmanCodeIJ[n][n2][n3] + "\n");
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

