/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.codec.jpeg;

import com.pixelmed.codec.jpeg.QuantizationTable;
import com.pixelmed.codec.jpeg.Utilities;
import java.util.Map;

public class MarkerSegmentDQT {
    private static final String identString = "@(#) $Header: /userland/cvs/codec/com/pixelmed/codec/jpeg/MarkerSegmentDQT.java,v 1.2 2014/03/21 21:46:20 dclunie Exp $";
    private int nTables = 0;
    private int[] QuantizationTableElementPrecision = new int[4];
    private int[] QuantizationTableIdentifier = new int[4];
    private int[][] QuantizationTableElement = new int[4][];

    public MarkerSegmentDQT(byte[] byArray, int n) throws Exception {
        int n2 = 0;
        while (n > 0) {
            if (this.nTables >= 4) {
                throw new Exception("Only 4 tables are permitted");
            }
            this.QuantizationTableElementPrecision[this.nTables] = Utilities.extract8(byArray, n2) >> 4;
            this.QuantizationTableIdentifier[this.nTables] = Utilities.extract8(byArray, n2) & 0xF;
            this.QuantizationTableElement[this.nTables] = new int[64];
            ++n2;
            --n;
            int n3 = 0;
            while (n3 < 64) {
                if (this.QuantizationTableElementPrecision[this.nTables] > 0) {
                    this.QuantizationTableElement[this.nTables][n3] = Utilities.extract16be(byArray, n2);
                    n2 += 2;
                    n -= 2;
                } else {
                    this.QuantizationTableElement[this.nTables][n3] = Utilities.extract8(byArray, n2);
                    ++n2;
                    --n;
                }
                ++n3;
            }
            ++this.nTables;
        }
    }

    public void addToMapByIdentifier(Map<String, QuantizationTable> map) {
        int n = 0;
        while (n < this.nTables) {
            int n2 = this.QuantizationTableIdentifier[n];
            String string = Integer.toString(n2);
            map.put(string, new QuantizationTable(n2, this.QuantizationTableElementPrecision[n], this.QuantizationTableElement[n]));
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\tDQT:\n");
        int n = 0;
        while (n < this.nTables) {
            stringBuffer.append("\t\t QuantizationTableElementPrecision = " + this.QuantizationTableElementPrecision[n] + "\n");
            stringBuffer.append("\t\t QuantizationTableIdentifier = " + this.QuantizationTableIdentifier[n] + "\n");
            int n2 = 0;
            while (n2 < 64) {
                stringBuffer.append("\t\t\t QuantizationTableElement " + n2 + " = " + this.QuantizationTableElement[n][n2] + "\n");
                ++n2;
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

