/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.codec.jpeg;

import com.pixelmed.codec.jpeg.Markers;
import com.pixelmed.codec.jpeg.Utilities;

public class MarkerSegmentSOF {
    private static final String identString = "@(#) $Header: /userland/cvs/codec/com/pixelmed/codec/jpeg/MarkerSegmentSOF.java,v 1.4 2015/10/17 21:20:52 dclunie Exp $";
    private int marker;
    private int SamplePrecision;
    private int nLines;
    private int nSamplesPerLine;
    private int nComponentsInFrame;
    private int[] ComponentIdentifier;
    private int[] HorizontalSamplingFactor;
    private int[] VerticalSamplingFactor;
    private int[] QuantizationTableDestinationSelector;

    public int getMarker() {
        return this.marker;
    }

    public int getSamplePrecision() {
        return this.SamplePrecision;
    }

    public int getNLines() {
        return this.nLines;
    }

    public int getNSamplesPerLine() {
        return this.nSamplesPerLine;
    }

    public int getNComponentsInFrame() {
        return this.nComponentsInFrame;
    }

    public int[] getHorizontalSamplingFactor() {
        return this.HorizontalSamplingFactor;
    }

    public int[] getVerticalSamplingFactor() {
        return this.VerticalSamplingFactor;
    }

    public MarkerSegmentSOF(int n, byte[] byArray, int n2) throws Exception {
        this.marker = n;
        this.SamplePrecision = Utilities.extract8(byArray, 0);
        this.nLines = Utilities.extract16be(byArray, 1);
        this.nSamplesPerLine = Utilities.extract16be(byArray, 3);
        this.nComponentsInFrame = Utilities.extract8(byArray, 5);
        int n3 = 6 + this.nComponentsInFrame * 3;
        if (n2 != n3) {
            throw new Exception("Incorrect length of SOF Parameters Marker Segment, expected " + n3 + " (based on nComponentsInFrame " + this.nComponentsInFrame + ") but was " + n2);
        }
        this.ComponentIdentifier = new int[this.nComponentsInFrame];
        this.HorizontalSamplingFactor = new int[this.nComponentsInFrame];
        this.VerticalSamplingFactor = new int[this.nComponentsInFrame];
        this.QuantizationTableDestinationSelector = new int[this.nComponentsInFrame];
        int n4 = 0;
        while (n4 < this.nComponentsInFrame) {
            this.ComponentIdentifier[n4] = Utilities.extract8(byArray, 6 + n4 * 3);
            this.HorizontalSamplingFactor[n4] = Utilities.extract8(byArray, 6 + n4 * 3 + 1) >> 4;
            this.VerticalSamplingFactor[n4] = Utilities.extract8(byArray, 6 + n4 * 3 + 1) & 0xF;
            this.QuantizationTableDestinationSelector[n4] = Utilities.extract8(byArray, 6 + n4 * 3 + 2);
            ++n4;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\t" + Markers.getAbbreviation(this.marker) + ":\n");
        stringBuffer.append("\t\t SamplePrecision = " + this.SamplePrecision + "\n");
        stringBuffer.append("\t\t nLines = " + this.nLines + "\n");
        stringBuffer.append("\t\t nSamplesPerLine = " + this.nSamplesPerLine + "\n");
        stringBuffer.append("\t\t nComponentsInFrame = " + this.nComponentsInFrame + "\n");
        int n = 0;
        while (n < this.nComponentsInFrame) {
            stringBuffer.append("\t\t component " + n + "\n");
            stringBuffer.append("\t\t\t ComponentIdentifier = " + this.ComponentIdentifier[n] + "\n");
            stringBuffer.append("\t\t\t HorizontalSamplingFactor = " + this.HorizontalSamplingFactor[n] + "\n");
            stringBuffer.append("\t\t\t VerticalSamplingFactor = " + this.VerticalSamplingFactor[n] + "\n");
            stringBuffer.append("\t\t\t QuantizationTableDestinationSelector = " + this.QuantizationTableDestinationSelector[n] + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

