/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.codec.jpeg;

import java.util.HashMap;
import java.util.Map;

public class Markers {
    private static final String identString = "@(#) $Header: /userland/cvs/codec/com/pixelmed/codec/jpeg/Markers.java,v 1.4 2016/01/16 15:07:52 dclunie Exp $";
    public static final int APP0 = 65504;
    public static final int APP1 = 65505;
    public static final int APP2 = 65506;
    public static final int APP3 = 65507;
    public static final int APP4 = 65508;
    public static final int APP5 = 65509;
    public static final int APP6 = 65510;
    public static final int APP7 = 65511;
    public static final int APP8 = 65512;
    public static final int APP9 = 65513;
    public static final int APPA = 65514;
    public static final int APPB = 65515;
    public static final int APPC = 65516;
    public static final int APPD = 65517;
    public static final int APPE = 65518;
    public static final int APPF = 65519;
    public static final int COM = 65534;
    public static final int DAC = 65484;
    public static final int DHP = 65502;
    public static final int DHT = 65476;
    public static final int DNL = 65500;
    public static final int DQT = 65499;
    public static final int DRI = 65501;
    public static final int EOI = 65497;
    public static final int EXP = 65503;
    public static final int JPG = 65480;
    public static final int RST0 = 65488;
    public static final int RST1 = 65489;
    public static final int RST2 = 65490;
    public static final int RST3 = 65491;
    public static final int RST4 = 65492;
    public static final int RST5 = 65493;
    public static final int RST6 = 65494;
    public static final int RST7 = 65495;
    public static final int SOF0 = 65472;
    public static final int SOF1 = 65473;
    public static final int SOF2 = 65474;
    public static final int SOF3 = 65475;
    public static final int SOF5 = 65477;
    public static final int SOF6 = 65478;
    public static final int SOF7 = 65479;
    public static final int SOF9 = 65481;
    public static final int SOFA = 65482;
    public static final int SOFB = 65483;
    public static final int SOFD = 65485;
    public static final int SOFE = 65486;
    public static final int SOFF = 65487;
    public static final int SOI = 65496;
    public static final int SOS = 65498;
    public static final int TEM = 65281;
    public static final int SOF55 = 65527;
    public static final int LSE = 65528;
    public static final int LSE_ID_L1 = 1;
    public static final int LSE_ID_L2 = 2;
    public static final int LSE_ID_L3 = 3;
    public static final int LSE_ID_L4 = 4;
    public static final int SOC = 65359;
    public static final int SOT = 65424;
    public static final int SOD = 65427;
    public static final int SIZ = 65361;
    public static final int COD = 65362;
    public static final int COC = 65363;
    public static final int RGN = 65374;
    public static final int QCD = 65372;
    public static final int QCC = 65373;
    public static final int POC = 65375;
    public static final int TLM = 65365;
    public static final int PLM = 65367;
    public static final int PLT = 65368;
    public static final int PPM = 65376;
    public static final int PPT = 65377;
    public static final int SOP = 65425;
    public static final int EPH = 65426;
    public static final int CRG = 65379;
    public static final int COM2K = 65380;
    public static final int FF30 = 65328;
    public static final int FF31 = 65329;
    public static final int FF32 = 65330;
    public static final int FF33 = 65331;
    public static final int FF34 = 65332;
    public static final int FF35 = 65333;
    public static final int FF36 = 65334;
    public static final int FF37 = 65335;
    public static final int FF38 = 65336;
    public static final int FF39 = 65337;
    public static final int FF3A = 65338;
    public static final int FF3B = 65339;
    public static final int FF3C = 65340;
    public static final int FF3D = 65341;
    public static final int FF3E = 65342;
    public static final int FF3F = 65343;
    private static final MarkerDictionaryEntry[] markerDictionaryTable = new MarkerDictionaryEntry[]{new MarkerDictionaryEntry(65504, "APP0", "Reserved for Application Use"), new MarkerDictionaryEntry(65505, "APP1", "Reserved for Application Use"), new MarkerDictionaryEntry(65506, "APP2", "Reserved for Application Use"), new MarkerDictionaryEntry(65507, "APP3", "Reserved for Application Use"), new MarkerDictionaryEntry(65508, "APP4", "Reserved for Application Use"), new MarkerDictionaryEntry(65509, "APP5", "Reserved for Application Use"), new MarkerDictionaryEntry(65510, "APP6", "Reserved for Application Use"), new MarkerDictionaryEntry(65511, "APP7", "Reserved for Application Use"), new MarkerDictionaryEntry(65512, "APP8", "Reserved for Application Use"), new MarkerDictionaryEntry(65513, "APP9", "Reserved for Application Use"), new MarkerDictionaryEntry(65514, "APPA", "Reserved for Application Use"), new MarkerDictionaryEntry(65515, "APPB", "Reserved for Application Use"), new MarkerDictionaryEntry(65516, "APPC", "Reserved for Application Use"), new MarkerDictionaryEntry(65517, "APPD", "Reserved for Application Use"), new MarkerDictionaryEntry(65518, "APPE", "Reserved for Application Use"), new MarkerDictionaryEntry(65519, "APPF", "Reserved for Application Use"), new MarkerDictionaryEntry(65534, "COM", "Comment"), new MarkerDictionaryEntry(65484, "DAC", "Define Arithmetic Conditioning Table(s)"), new MarkerDictionaryEntry(65502, "DHP", "Define Hierarchical Progression"), new MarkerDictionaryEntry(65476, "DHT", "Define Huffman Table(s)"), new MarkerDictionaryEntry(65500, "DNL", "Define Number of Lines"), new MarkerDictionaryEntry(65499, "DQT", "Define Quantization Table(s)"), new MarkerDictionaryEntry(65501, "DRI", "Define Restart Interval"), new MarkerDictionaryEntry(65497, "EOI", "End of Image (JPEG 2000 EOC End of codestream)"), new MarkerDictionaryEntry(65503, "EXP", "Expand Reference Image(s)"), new MarkerDictionaryEntry(65480, "JPG", "Reserved for JPEG extensions"), new MarkerDictionaryEntry(65488, "RST0", "Restart with modulo 8 counter 0"), new MarkerDictionaryEntry(65489, "RST1", "Restart with modulo 8 counter 1"), new MarkerDictionaryEntry(65490, "RST2", "Restart with modulo 8 counter 2"), new MarkerDictionaryEntry(65491, "RST3", "Restart with modulo 8 counter 3"), new MarkerDictionaryEntry(65492, "RST4", "Restart with modulo 8 counter 4"), new MarkerDictionaryEntry(65493, "RST5", "Restart with modulo 8 counter 5"), new MarkerDictionaryEntry(65494, "RST6", "Restart with modulo 8 counter 6"), new MarkerDictionaryEntry(65495, "RST7", "Restart with modulo 8 counter 7"), new MarkerDictionaryEntry(65472, "SOF0", "Huffman Baseline DCT"), new MarkerDictionaryEntry(65473, "SOF1", "Huffman Extended Sequential DCT"), new MarkerDictionaryEntry(65474, "SOF2", "Huffman Progressive DCT"), new MarkerDictionaryEntry(65475, "SOF3", "Huffman Lossless Sequential"), new MarkerDictionaryEntry(65477, "SOF5", "Huffman Differential Sequential DCT"), new MarkerDictionaryEntry(65478, "SOF6", "Huffman Differential Progressive DCT"), new MarkerDictionaryEntry(65479, "SOF7", "Huffman Differential Lossless"), new MarkerDictionaryEntry(65481, "SOF9", "Arithmetic Extended Sequential DCT"), new MarkerDictionaryEntry(65482, "SOFA", "Arithmetic Progressive DCT"), new MarkerDictionaryEntry(65483, "SOFB", "Arithmetic Lossless Sequential"), new MarkerDictionaryEntry(65485, "SOFD", "Arithmetic Differential Sequential DCT"), new MarkerDictionaryEntry(65486, "SOFE", "Arithmetic Differential Progressive DCT"), new MarkerDictionaryEntry(65487, "SOFF", "Arithmetic Differential Lossless"), new MarkerDictionaryEntry(65527, "SOF55", "LS"), new MarkerDictionaryEntry(65496, "SOI", "Start of Image"), new MarkerDictionaryEntry(65498, "SOS", "Start of Scan"), new MarkerDictionaryEntry(65281, "TEM", "Temporary use with Arithmetic Encoding"), new MarkerDictionaryEntry(65359, "SOC", "Start of codestream"), new MarkerDictionaryEntry(65424, "SOT", "Start of tile-part"), new MarkerDictionaryEntry(65427, "SOD", "Start of data"), new MarkerDictionaryEntry(65361, "SIZ", "Image and tile size"), new MarkerDictionaryEntry(65362, "COD", "Coding style default"), new MarkerDictionaryEntry(65363, "COC", "Coding style component"), new MarkerDictionaryEntry(65374, "RGN", "Rgeion-of-interest"), new MarkerDictionaryEntry(65372, "QCD", "Quantization default"), new MarkerDictionaryEntry(65373, "QCC", "Quantization component"), new MarkerDictionaryEntry(65375, "POC", "Progression order change"), new MarkerDictionaryEntry(65365, "TLM", "Tile-part lengths"), new MarkerDictionaryEntry(65367, "PLM", "Packet length, main header"), new MarkerDictionaryEntry(65368, "PLT", "Packet length, tile-part header"), new MarkerDictionaryEntry(65376, "PPM", "Packet packer headers, main header"), new MarkerDictionaryEntry(65377, "PPT", "Packet packer headers, tile-part header"), new MarkerDictionaryEntry(65425, "SOP", "Start of packet"), new MarkerDictionaryEntry(65426, "EPH", "End of packet header"), new MarkerDictionaryEntry(65379, "CRG", "Component registration"), new MarkerDictionaryEntry(65380, "COM", "Comment (JPEG 2000)"), new MarkerDictionaryEntry(65328, "FF30", "Reserved"), new MarkerDictionaryEntry(65329, "FF31", "Reserved"), new MarkerDictionaryEntry(65330, "FF32", "Reserved"), new MarkerDictionaryEntry(65331, "FF33", "Reserved"), new MarkerDictionaryEntry(65332, "FF34", "Reserved"), new MarkerDictionaryEntry(65333, "FF35", "Reserved"), new MarkerDictionaryEntry(65334, "FF36", "Reserved"), new MarkerDictionaryEntry(65335, "FF37", "Reserved"), new MarkerDictionaryEntry(65336, "FF38", "Reserved"), new MarkerDictionaryEntry(65337, "FF39", "Reserved"), new MarkerDictionaryEntry(65338, "FF3A", "Reserved"), new MarkerDictionaryEntry(65339, "FF3B", "Reserved"), new MarkerDictionaryEntry(65340, "FF3C", "Reserved"), new MarkerDictionaryEntry(65341, "FF3D", "Reserved"), new MarkerDictionaryEntry(65342, "FF3E", "Reserved"), new MarkerDictionaryEntry(65343, "FF3F", "Reserved")};
    private static final Map<Integer, MarkerDictionaryEntry> mapOfMarkerToDictionaryEntry = new HashMap<Integer, MarkerDictionaryEntry>();

    static {
        MarkerDictionaryEntry[] markerDictionaryEntryArray = markerDictionaryTable;
        int n = markerDictionaryTable.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerDictionaryEntry markerDictionaryEntry = markerDictionaryEntryArray[n2];
            mapOfMarkerToDictionaryEntry.put(new Integer(markerDictionaryEntry.markercode), markerDictionaryEntry);
            ++n2;
        }
    }

    public static final int isFixedLengthJPEGSegment(int n) {
        int n2;
        switch (n) {
            case 65503: {
                n2 = 3;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public static final boolean isNoLengthJPEGSegment(int n) {
        boolean bl;
        switch (n) {
            case 65281: 
            case 65328: 
            case 65329: 
            case 65330: 
            case 65331: 
            case 65332: 
            case 65333: 
            case 65334: 
            case 65335: 
            case 65336: 
            case 65337: 
            case 65338: 
            case 65339: 
            case 65340: 
            case 65341: 
            case 65342: 
            case 65343: 
            case 65359: 
            case 65426: 
            case 65427: 
            case 65488: 
            case 65489: 
            case 65490: 
            case 65491: 
            case 65492: 
            case 65493: 
            case 65494: 
            case 65495: 
            case 65496: 
            case 65497: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isVariableLengthJPEGSegment(int n) {
        return !Markers.isNoLengthJPEGSegment(n) && Markers.isFixedLengthJPEGSegment(n) == 0;
    }

    public static final boolean isSOF(int n) {
        boolean bl;
        switch (n) {
            case 65472: 
            case 65473: 
            case 65474: 
            case 65475: 
            case 65477: 
            case 65478: 
            case 65479: 
            case 65481: 
            case 65482: 
            case 65483: 
            case 65485: 
            case 65486: 
            case 65487: 
            case 65527: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isHuffman(int n) {
        boolean bl;
        switch (n) {
            case 65472: 
            case 65473: 
            case 65474: 
            case 65475: 
            case 65477: 
            case 65478: 
            case 65479: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isDCT(int n) {
        boolean bl;
        switch (n) {
            case 65472: 
            case 65473: 
            case 65474: 
            case 65477: 
            case 65478: 
            case 65481: 
            case 65482: 
            case 65485: 
            case 65486: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isLossless(int n) {
        boolean bl;
        switch (n) {
            case 65475: 
            case 65479: 
            case 65483: 
            case 65487: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final String getAbbreviation(int n) {
        MarkerDictionaryEntry markerDictionaryEntry = mapOfMarkerToDictionaryEntry.get(new Integer(n));
        return markerDictionaryEntry == null ? "" : markerDictionaryEntry.abbreviation;
    }

    public static final String getDescription(int n) {
        MarkerDictionaryEntry markerDictionaryEntry = mapOfMarkerToDictionaryEntry.get(new Integer(n));
        return markerDictionaryEntry == null ? "" : markerDictionaryEntry.description;
    }

    private static class MarkerDictionaryEntry {
        int markercode;
        String abbreviation;
        String description;

        MarkerDictionaryEntry(int n, String string, String string2) {
            this.markercode = n;
            this.abbreviation = string;
            this.description = string2;
        }
    }
}

