/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.imageio;

import com.pixelmed.codec.jpeg.MarkerSegmentSOF;
import com.pixelmed.codec.jpeg.OutputArrayOrStream;
import com.pixelmed.codec.jpeg.Parse;
import com.pixelmed.imageio.JPEGLosslessMetadata;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class JPEGLosslessImageReader
extends ImageReader {
    private static final String identString = "@(#) $Header: /userland/cvs/codec/com/pixelmed/imageio/JPEGLosslessImageReader.java,v 1.8 2015/10/19 15:34:42 dclunie Exp $";
    ImageInputStream stream = null;
    int width;
    int height;
    int bitDepth;
    Parse.DecompressedOutput decompressedOutput = null;
    boolean gotEverything = false;
    JPEGLosslessMetadata metadata = null;

    public JPEGLosslessImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    public void reset() {
        System.err.println("reset()");
        super.reset();
        this.stream = null;
        this.gotEverything = false;
        this.decompressedOutput = null;
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        if (object == null) {
            this.stream = null;
            return;
        }
        if (!(object instanceof ImageInputStream)) {
            throw new IllegalArgumentException("bad input");
        }
        this.stream = (ImageInputStream)object;
        this.gotEverything = false;
        this.decompressedOutput = null;
    }

    @Override
    public int getNumImages(boolean bl) throws IIOException {
        return 1;
    }

    private void checkIndex(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException("bad index");
        }
    }

    @Override
    public int getWidth(int n) throws IIOException {
        this.checkIndex(n);
        this.readEverything();
        return this.width;
    }

    @Override
    public int getHeight(int n) throws IIOException {
        this.checkIndex(n);
        this.readEverything();
        return this.height;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IIOException {
        this.checkIndex(n);
        this.readEverything();
        ImageTypeSpecifier imageTypeSpecifier = null;
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        imageTypeSpecifier = ImageTypeSpecifier.createGrayscale(this.bitDepth, this.bitDepth <= 8 ? 0 : 1, false);
        arrayList.add(imageTypeSpecifier);
        return arrayList.iterator();
    }

    public void readEverything() throws IIOException {
        if (this.gotEverything) {
            return;
        }
        this.gotEverything = true;
        if (this.stream == null) {
            throw new IllegalStateException("No input stream");
        }
        this.decompressedOutput = new Parse.DecompressedOutput();
        try {
            MarkerSegmentSOF markerSegmentSOF;
            Parse.MarkerSegmentsFoundDuringParse markerSegmentsFoundDuringParse = Parse.parse(new WrapImageInputStreamAsInputStream(this.stream), null, null, this.decompressedOutput);
            MarkerSegmentSOF markerSegmentSOF2 = markerSegmentSOF = markerSegmentsFoundDuringParse != null ? markerSegmentsFoundDuringParse.getSOF() : null;
            if (markerSegmentSOF != null) {
                if (markerSegmentSOF.getNComponentsInFrame() != 1 && markerSegmentSOF.getNComponentsInFrame() != 3) {
                    throw new IIOException("Error reading JPEG stream - only single component (grayscale) or three component supported)");
                }
            } else {
                throw new IIOException("Error reading JPEG stream - no SOS or SOF marker segment parsed");
            }
            this.width = markerSegmentSOF.getNSamplesPerLine();
            this.height = markerSegmentSOF.getNLines();
            this.bitDepth = markerSegmentSOF.getSamplePrecision();
        }
        catch (Exception exception) {
            throw new IIOException("Error reading JPEG stream", exception);
        }
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.checkIndex(n);
        this.readEverything();
        BufferedImage bufferedImage = null;
        OutputArrayOrStream[] outputArrayOrStreamArray = this.decompressedOutput.getDecompressedOutputPerComponent();
        ComponentColorModel componentColorModel = null;
        ComponentSampleModel componentSampleModel = null;
        DataBuffer dataBuffer = null;
        if (outputArrayOrStreamArray.length == 1) {
            if (this.bitDepth <= 8) {
                componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
                componentSampleModel = new ComponentSampleModel(0, this.width, this.height, 1, this.width, new int[1]);
                dataBuffer = new DataBufferByte(outputArrayOrStreamArray[0].getByteArray(), this.width, 0);
            } else {
                componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{16}, false, false, 1, 1);
                componentSampleModel = new ComponentSampleModel(1, this.width, this.height, 1, this.width, new int[1]);
                dataBuffer = new DataBufferUShort(outputArrayOrStreamArray[0].getShortArray(), this.width, 0);
            }
        } else if (outputArrayOrStreamArray.length == 3) {
            if (this.bitDepth <= 8) {
                componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
                int[] nArray = new int[3];
                nArray[1] = 1;
                nArray[2] = 2;
                componentSampleModel = new ComponentSampleModel(0, this.width, this.height, 1, this.width, nArray, new int[3]);
                dataBuffer = new DataBufferByte(new byte[][]{outputArrayOrStreamArray[0].getByteArray(), outputArrayOrStreamArray[1].getByteArray(), outputArrayOrStreamArray[2].getByteArray()}, this.width * this.height);
            } else {
                componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{16, 16, 16}, false, false, 1, 1);
                int[] nArray = new int[3];
                nArray[1] = 1;
                nArray[2] = 2;
                componentSampleModel = new ComponentSampleModel(1, this.width, this.height, 1, this.width, nArray, new int[3]);
                dataBuffer = new DataBufferUShort(new short[][]{outputArrayOrStreamArray[0].getShortArray(), outputArrayOrStreamArray[1].getShortArray(), outputArrayOrStreamArray[2].getShortArray()}, this.width * this.height);
            }
        }
        if (dataBuffer != null) {
            WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBuffer, new Point(0, 0));
            bufferedImage = new BufferedImage(componentColorModel, writableRaster, true, null);
        }
        return bufferedImage;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IIOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IIOException {
        if (n != 0) {
            throw new IndexOutOfBoundsException("imageIndex != 0!");
        }
        this.readMetadata();
        return this.metadata;
    }

    public void readMetadata() throws IIOException {
        if (this.metadata != null) {
            return;
        }
        this.readEverything();
        this.metadata = new JPEGLosslessMetadata();
    }

    private final class WrapImageInputStreamAsInputStream
    extends InputStream {
        private final ImageInputStream iis;

        private WrapImageInputStreamAsInputStream() {
            this.iis = null;
        }

        public WrapImageInputStreamAsInputStream(ImageInputStream imageInputStream) {
            this.iis = imageInputStream;
        }

        @Override
        public final int available() {
            return 0;
        }

        @Override
        public final void close() throws IOException {
            this.iis.close();
        }

        @Override
        public final void mark(int n) {
            this.iis.mark();
        }

        @Override
        public final boolean markSupported() {
            return true;
        }

        @Override
        public final int read() throws IOException {
            return this.iis.read();
        }

        @Override
        public final int read(byte[] byArray) throws IOException {
            return this.iis.read(byArray);
        }

        @Override
        public final int read(byte[] byArray, int n, int n2) throws IOException {
            return this.iis.read(byArray, n, n2);
        }

        @Override
        public final void reset() throws IOException {
            this.iis.reset();
        }

        @Override
        public final long skip(long l) throws IOException {
            return this.iis.skipBytes(l);
        }
    }
}

