/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.setaside;

import com.agfa.pacs.listtext.setaside.ISetAsideHandler;
import com.agfa.pacs.listtext.setaside.SetAsideHandlerFactory;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class SetAsideHandlerFactoryEclipseImpl
extends SetAsideHandlerFactory {
    private Collection<ISetAsideHandler> handlers = new ArrayList<ISetAsideHandler>();

    public SetAsideHandlerFactoryEclipseImpl() {
        TreeSet<IConfigurationElement> treeSet = new TreeSet<IConfigurationElement>(new ConfigurationElementByPriorityComparator());
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.agfa.pacs.listtext.integration.SetAsideHandler");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension iExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            if (iConfigurationElementArray == null || iConfigurationElementArray.length == 0) {
                throw new IllegalStateException("No Set Aside handler implementation found");
            }
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray;
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n4];
                treeSet.add(iConfigurationElement);
                ++n4;
            }
            ++n2;
        }
        try {
            for (IConfigurationElement iConfigurationElement : treeSet) {
                ISetAsideHandler iSetAsideHandler = (ISetAsideHandler)iConfigurationElement.createExecutableExtension("class");
                this.handlers.add(iSetAsideHandler);
            }
        }
        catch (CoreException coreException) {
            ALogger.getLogger(SetAsideHandlerFactoryEclipseImpl.class).error("SetAsideHandler-instantiation failed!", (Throwable)coreException);
        }
    }

    @Override
    protected ISetAsideHandler[] getHandlersInt() {
        return this.handlers.toArray(new ISetAsideHandler[this.handlers.size()]);
    }

    private static class ConfigurationElementByPriorityComparator
    implements Comparator<IConfigurationElement> {
        private ConfigurationElementByPriorityComparator() {
        }

        @Override
        public int compare(IConfigurationElement iConfigurationElement, IConfigurationElement iConfigurationElement2) {
            Integer n = iConfigurationElement == null ? null : ConfigurationElementByPriorityComparator.getConfigurationElementPriority(iConfigurationElement);
            Integer n2 = iConfigurationElement2 == null ? null : ConfigurationElementByPriorityComparator.getConfigurationElementPriority(iConfigurationElement2);
            return CompareUtils.compareAdvanced((Comparable)n, (Comparable)n2);
        }

        private static Integer getConfigurationElementPriority(IConfigurationElement iConfigurationElement) {
            try {
                return Integer.valueOf(iConfigurationElement.getAttribute("priority"));
            }
            catch (Exception exception) {
                return Integer.MAX_VALUE;
            }
        }
    }
}

