/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.setaside;

import com.agfa.pacs.base.util.AbstractFileServiceData;
import com.agfa.pacs.listtext.setaside.ISetAsideData;
import com.agfa.pacs.listtext.setaside.ISetAsideHandler;
import com.agfa.pacs.listtext.setaside.SetAsideHandlerFactory;
import com.agfa.pacs.tools.FileUtil;
import com.agfa.pacs.tools.StreamUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;

public class SetAsideState
extends AbstractFileServiceData {
    private static final String DF_PATTERN = "yyyy-MM-dd-HH-mm";
    private static final String ZIP_FILE_PREFIX = "set-aside-1.0-";
    private static final String ZIP_FILE_SUFFIX = ".zip";
    private String userId;
    private Date creationDate;
    private final Map<Class<? extends ISetAsideData>, ISetAsideData> customData;

    private SetAsideState(String string) {
        this.userId = string;
        this.creationDate = new Date();
        this.customData = new HashMap<Class<? extends ISetAsideData>, ISetAsideData>();
        ISetAsideHandler[] iSetAsideHandlerArray = SetAsideHandlerFactory.getInstance().getHandlers();
        int n = iSetAsideHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISetAsideHandler iSetAsideHandler = iSetAsideHandlerArray[n2];
            ISetAsideData iSetAsideData = iSetAsideHandler.createEmptyDataContainer();
            if (iSetAsideData != null) {
                this.customData.put(iSetAsideData.getClass(), iSetAsideData);
            }
            ++n2;
        }
    }

    public static SetAsideState createEmptyInstance(String string) {
        return new SetAsideState(string);
    }

    public String getUserId() {
        return this.userId;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public <T extends ISetAsideData> T getCustomData(Class<T> clazz) {
        return (T)this.customData.get(clazz);
    }

    protected String getFileName() {
        return this.toZipFileName(this.userId, this.creationDate);
    }

    protected void writeData(OutputStream outputStream) throws IOException {
        Map<ZipEntry, byte[]> map = this.toZipEntries(this.userId, this.creationDate);
        byte[] byArray = FileUtil.zip(map);
        outputStream.write(byArray);
    }

    public void read(InputStream inputStream) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        String string = dataInputStream.readUTF();
        this.creationDate = this.getCreationDate(string);
        byte[] byArray = StreamUtil.readStreamSimple((InputStream)dataInputStream);
        Map map = FileUtil.unzip((byte[])byArray);
        this.init(map);
    }

    public static String escapeXMLCharacters(String string) {
        if (string != null) {
            String string2 = string;
            string2 = string2.replaceAll("&", "&amp;");
            string2 = string2.replaceAll("<", "&lt;");
            string2 = string2.replaceAll(">", "&gt;");
            string2 = string2.replaceAll("\"", "&quot;");
            string2 = string2.replaceAll("'", "&apos;");
            return string2;
        }
        return string;
    }

    private String toZipFileName(String string, Date date) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ZIP_FILE_PREFIX);
        stringBuilder.append(new SimpleDateFormat(DF_PATTERN).format(date));
        stringBuilder.append(ZIP_FILE_SUFFIX);
        return stringBuilder.toString();
    }

    private Date getCreationDate(String string) throws Exception {
        int n = ZIP_FILE_PREFIX.length();
        int n2 = string.length() - ZIP_FILE_SUFFIX.length();
        String string2 = string.substring(n, n2);
        return new SimpleDateFormat(DF_PATTERN).parse(string2);
    }

    private Map<ZipEntry, byte[]> toZipEntries(String string, Date date) throws IOException {
        HashMap<ZipEntry, byte[]> hashMap = new HashMap<ZipEntry, byte[]>();
        String string2 = new SimpleDateFormat(DF_PATTERN).format(date);
        for (ISetAsideData iSetAsideData : this.customData.values()) {
            hashMap.putAll(iSetAsideData.toZipEntries(string, string2));
        }
        return hashMap;
    }

    private void init(Map<ZipEntry, byte[]> map) throws Exception {
        for (ISetAsideData iSetAsideData : this.customData.values()) {
            iSetAsideData.init(map);
        }
    }
}

