/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.thirdparty.dcm4che3;

import com.agfa.pacs.thirdparty.dcm4che3.IDynamicElementDictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.IntHashMap;

public class AgfaDynamicTag
extends ElementDictionary
implements IDynamicElementDictionary {
    public static final ElementDictionary INSTANCE = new AgfaDynamicTag();
    public static final String CREATOR = "AGFA-AG_DYNAMIC";
    private static final IntHashMap<VR> vrMap = new IntHashMap();
    private static final IntHashMap<String> keywordMap = new IntHashMap();
    private static final Map<String, Integer> tagMap = new HashMap<String, Integer>();
    private static final ReadWriteLock registrationLock = new ReentrantReadWriteLock();

    public AgfaDynamicTag() {
        super(CREATOR, AgfaDynamicTag.class);
    }

    @Override
    public VR vrOf(int n) {
        VR vR;
        registrationLock.readLock().lock();
        try {
            vR = vrMap.get(n);
        }
        finally {
            registrationLock.readLock().unlock();
        }
        if (vR == null) {
            return VR.UN;
        }
        return vR;
    }

    @Override
    public String keywordOf(int n) {
        registrationLock.readLock().lock();
        try {
            String string = keywordMap.get(n);
            return string;
        }
        finally {
            registrationLock.readLock().unlock();
        }
    }

    @Override
    public int tagForKeyword(String string) {
        registrationLock.readLock().lock();
        try {
            Integer n = tagMap.get(string);
            int n2 = n == null ? -1 : n;
            return n2;
        }
        finally {
            registrationLock.readLock().unlock();
        }
    }

    @Override
    public void registerTag(String string, int n, VR vR) {
        registrationLock.writeLock().lock();
        try {
            vrMap.put(n, vR);
            keywordMap.put(n, string);
            tagMap.put(string, n);
        }
        finally {
            registrationLock.writeLock().unlock();
        }
    }
}

