/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.conf.core.api.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dcm4che3.conf.core.api.ConfigurableClass;
import org.dcm4che3.conf.core.api.ConfigurableProperty;
import org.dcm4che3.conf.core.api.ConfigurationException;
import org.dcm4che3.conf.core.api.LDAP;

@LDAP
public class AnnotatedConfigurableProperty {
    private Map<Type, Annotation> annotations = new HashMap<Type, Annotation>();
    private Type type;
    private String name;

    public AnnotatedConfigurableProperty() {
    }

    public AnnotatedConfigurableProperty(Type type) {
        this.setType(type);
    }

    public AnnotatedConfigurableProperty clone() {
        AnnotatedConfigurableProperty annotatedConfigurableProperty = new AnnotatedConfigurableProperty();
        annotatedConfigurableProperty.setAnnotations(this.getAnnotations());
        annotatedConfigurableProperty.setType(this.getType());
        annotatedConfigurableProperty.setName(this.getName());
        return annotatedConfigurableProperty;
    }

    public boolean isArrayOfConfObjects() {
        return this.getRawClass().isArray() && this.getRawClass().getComponentType().getAnnotation(ConfigurableClass.class) != null;
    }

    public Map<Type, Annotation> getAnnotations() {
        return this.annotations;
    }

    public boolean isCollectionOfConfObjects() {
        return Collection.class.isAssignableFrom(this.getRawClass()) && this.getPseudoPropertyForGenericsParamater(0).getRawClass().getAnnotation(ConfigurableClass.class) != null;
    }

    public Type getTypeForGenericsParameter(int n) {
        Type[] typeArray = ((ParameterizedType)this.getType()).getActualTypeArguments();
        return typeArray[n];
    }

    public AnnotatedConfigurableProperty getPseudoPropertyForGenericsParamater(int n) {
        Type type = this.getTypeForGenericsParameter(n);
        AnnotatedConfigurableProperty annotatedConfigurableProperty = this.clone();
        annotatedConfigurableProperty.setType(type);
        return annotatedConfigurableProperty;
    }

    public AnnotatedConfigurableProperty getPseudoPropertyForConfigClassCollectionElement() {
        Class<?> clazz;
        if (this.isMapOfConfObjects()) {
            clazz = this.getTypeForGenericsParameter(1);
        } else if (this.isCollectionOfConfObjects()) {
            clazz = this.getTypeForGenericsParameter(0);
        } else if (this.isArrayOfConfObjects()) {
            clazz = this.getRawClass().getComponentType();
        } else {
            return null;
        }
        AnnotatedConfigurableProperty annotatedConfigurableProperty = this.clone();
        annotatedConfigurableProperty.setType(clazz);
        return annotatedConfigurableProperty;
    }

    public AnnotatedConfigurableProperty getPseudoPropertyForCollectionElement() {
        Class<?> clazz;
        if (Map.class.isAssignableFrom(this.getRawClass())) {
            clazz = this.getTypeForGenericsParameter(1);
        } else if (Collection.class.isAssignableFrom(this.getRawClass())) {
            clazz = this.getTypeForGenericsParameter(0);
        } else if (this.getRawClass().isArray()) {
            clazz = this.getRawClass().getComponentType();
        } else {
            return null;
        }
        AnnotatedConfigurableProperty annotatedConfigurableProperty = this.clone();
        annotatedConfigurableProperty.setType(clazz);
        return annotatedConfigurableProperty;
    }

    public Class getRawClass() {
        Class clazz = this.type instanceof ParameterizedType ? (Class)((ParameterizedType)this.type).getRawType() : (Class)this.type;
        return clazz;
    }

    public void setAnnotations(Map<Type, Annotation> map) {
        this.annotations = map;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getAnnotatedName() throws ConfigurationException {
        String string = this.getAnnotation(ConfigurableProperty.class).name();
        if (!string.equals("")) {
            return string;
        }
        string = this.name;
        if (string != null) {
            return string;
        }
        throw new ConfigurationException("Property name not specified");
    }

    public <T> T getAnnotation(Class<T> clazz) {
        Annotation annotation = this.annotations.get(clazz);
        if (annotation == null && clazz.equals(LDAP.class)) {
            return (T)AnnotatedConfigurableProperty.class.getAnnotation(LDAP.class);
        }
        return (T)annotation;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isConfObject() {
        return this.getRawClass().getAnnotation(ConfigurableClass.class) != null;
    }

    public boolean isMapOfConfObjects() {
        return Map.class.isAssignableFrom(this.getRawClass()) && !this.getAnnotation(ConfigurableProperty.class).collectionOfReferences() && this.getPseudoPropertyForGenericsParamater(1).isConfObject();
    }

    public List<ConfigurableProperty.Tag> getTags() {
        if (this.getAnnotation(ConfigurableProperty.class) == null) {
            return new ArrayList<ConfigurableProperty.Tag>();
        }
        return new ArrayList<ConfigurableProperty.Tag>(Arrays.asList(this.getAnnotation(ConfigurableProperty.class).tags()));
    }
}

