/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.conf.core.api.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dcm4che3.conf.core.api.ConfigurableClass;
import org.dcm4che3.conf.core.api.ConfigurableProperty;
import org.dcm4che3.conf.core.api.internal.AnnotatedConfigurableProperty;

public class ConfigIterators {
    private static final Map<Class, List<AnnotatedConfigurableProperty>> configurableFieldsCache = Collections.synchronizedMap(new HashMap());
    private static final Map<Class, List<AnnotatedSetter>> configurableSettersCache = Collections.synchronizedMap(new HashMap());

    public static Class<?> getExtensionClassBySimpleName(String string, List<Class<?>> list) throws ClassNotFoundException {
        List<Class<?>> list2 = list;
        for (Class<?> clazz : list2) {
            if (!clazz.getSimpleName().equals(string)) continue;
            return clazz;
        }
        throw new ClassNotFoundException();
    }

    public static List<AnnotatedConfigurableProperty> getAllConfigurableFieldsAndSetterParameters(Class clazz) {
        List<AnnotatedConfigurableProperty> list = ConfigIterators.getAllConfigurableFields(clazz);
        for (AnnotatedSetter annotatedSetter : ConfigIterators.getAllConfigurableSetters(clazz)) {
            list.addAll(annotatedSetter.getParameters());
        }
        return list;
    }

    public static List<AnnotatedSetter> getAllConfigurableSetters(Class clazz) {
        List<AnnotatedSetter> list = configurableSettersCache.get(clazz);
        if (list != null) {
            return list;
        }
        ConfigIterators.processAndCacheAnnotationsForClass(clazz);
        return configurableSettersCache.get(clazz);
    }

    public static List<AnnotatedConfigurableProperty> getAllConfigurableFields(Class clazz) {
        List<AnnotatedConfigurableProperty> list = configurableFieldsCache.get(clazz);
        if (list != null) {
            return list;
        }
        ConfigIterators.processAndCacheAnnotationsForClass(clazz);
        return configurableFieldsCache.get(clazz);
    }

    private static void processAndCacheAnnotationsForClass(Class clazz) {
        ConfigIterators.processAnnotatedSetters(clazz);
        ConfigIterators.processAnnotatedProperties(clazz);
        if (clazz.getAnnotation(ConfigurableClass.class) == null) {
            throw new IllegalArgumentException("Class '" + clazz.getName() + "' is not a configurable class. Make sure the a dependency to org.dcm4che.conf.core-api exists.");
        }
    }

    private static List<AnnotatedSetter> processAnnotatedSetters(Class clazz) {
        ArrayList<AnnotatedSetter> arrayList = new ArrayList<AnnotatedSetter>();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            AnnotatedSetter annotatedSetter = new AnnotatedSetter();
            annotatedSetter.setParameters(new ArrayList<AnnotatedConfigurableProperty>());
            Annotation[][] annotationArray = method.getParameterAnnotations();
            Type[] typeArray = method.getGenericParameterTypes();
            boolean bl = true;
            int n3 = 0;
            while (n3 < annotationArray.length) {
                bl = false;
                AnnotatedConfigurableProperty annotatedConfigurableProperty = new AnnotatedConfigurableProperty();
                annotatedConfigurableProperty.setAnnotations(ConfigIterators.annotationsArrayToMap(annotationArray[n3]));
                annotatedConfigurableProperty.setType(typeArray[n3]);
                annotatedSetter.getParameters().add(annotatedConfigurableProperty);
                if (annotatedConfigurableProperty.getAnnotation(ConfigurableProperty.class) == null) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                arrayList.add(annotatedSetter);
                annotatedSetter.setAnnotations(ConfigIterators.annotationsArrayToMap(method.getAnnotations()));
                annotatedSetter.setMethod(method);
            }
            ++n2;
        }
        configurableSettersCache.put(clazz, arrayList);
        return arrayList;
    }

    private static List<AnnotatedConfigurableProperty> processAnnotatedProperties(Class clazz) {
        ArrayList<AnnotatedConfigurableProperty> arrayList = new ArrayList<AnnotatedConfigurableProperty>();
        for (Field field : ConfigIterators.getFieldsUpTo(clazz, null)) {
            if (field.getAnnotation(ConfigurableProperty.class) == null) continue;
            AnnotatedConfigurableProperty annotatedConfigurableProperty = new AnnotatedConfigurableProperty();
            annotatedConfigurableProperty.setAnnotations(ConfigIterators.annotationsArrayToMap(field.getAnnotations()));
            annotatedConfigurableProperty.setType(field.getGenericType());
            annotatedConfigurableProperty.setName(field.getName());
            arrayList.add(annotatedConfigurableProperty);
        }
        configurableFieldsCache.put(clazz, arrayList);
        return arrayList;
    }

    public static Map<Type, Annotation> annotationsArrayToMap(Annotation[] annotationArray) {
        HashMap<Type, Annotation> hashMap = new HashMap<Type, Annotation>();
        Annotation[] annotationArray2 = annotationArray;
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray2[n2];
            hashMap.put(annotation.annotationType(), annotation);
            ++n2;
        }
        return hashMap;
    }

    public static Iterable<Field> getFieldsUpTo(Class<?> clazz, Class<?> clazz2) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        arrayList.addAll(Arrays.asList(clazz.getDeclaredFields()));
        Class<?> clazz3 = clazz.getSuperclass();
        if (!(clazz3 == null || clazz2 != null && clazz3.equals(clazz2))) {
            List list = (List)ConfigIterators.getFieldsUpTo(clazz3, clazz2);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public static class AnnotatedSetter {
        private Map<Type, Annotation> annotations;
        private List<AnnotatedConfigurableProperty> parameters;
        private Method method;

        public Map<Type, Annotation> getAnnotations() {
            return this.annotations;
        }

        public void setAnnotations(Map<Type, Annotation> map) {
            this.annotations = map;
        }

        public <T> T getAnnotation(Class<T> clazz) {
            return (T)this.annotations.get(clazz);
        }

        public List<AnnotatedConfigurableProperty> getParameters() {
            return this.parameters;
        }

        public void setParameters(List<AnnotatedConfigurableProperty> list) {
            this.parameters = list;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }
    }
}

