/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.util.Date;
import java.util.TimeZone;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.data.DatePrecisions;
import org.dcm4che3.data.SpecificCharacterSet;
import org.dcm4che3.data.StringValueType;
import org.dcm4che3.data.Value;
import org.dcm4che3.data.ValueType;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;

enum BinaryValueType implements ValueType
{
    BYTE(1, 1){

        @Override
        public byte[] toggleEndian(byte[] byArray, boolean bl) {
            return byArray;
        }

        @Override
        protected int toInt(byte[] byArray, int n, boolean bl) {
            return byArray[n];
        }

        @Override
        protected byte[] toBytes(int n, byte[] byArray, int n2, boolean bl) {
            byArray[n2] = (byte)n;
            return byArray;
        }
    }
    ,
    SHORT(2, 2){

        @Override
        public boolean isIntValue() {
            return true;
        }

        @Override
        public byte[] toggleEndian(byte[] byArray, boolean bl) {
            return ByteUtils.swapShorts(bl ? (byte[])byArray.clone() : byArray, 0, byArray.length);
        }

        @Override
        protected int toInt(byte[] byArray, int n, boolean bl) {
            return ByteUtils.bytesToShort(byArray, n, bl);
        }

        @Override
        protected byte[] toBytes(int n, byte[] byArray, int n2, boolean bl) {
            return ByteUtils.shortToBytes(n, byArray, n2, bl);
        }
    }
    ,
    USHORT(2, 2){

        @Override
        public boolean isIntValue() {
            return true;
        }

        @Override
        public byte[] toggleEndian(byte[] byArray, boolean bl) {
            return ByteUtils.swapShorts(bl ? (byte[])byArray.clone() : byArray, 0, byArray.length);
        }

        @Override
        protected int toInt(byte[] byArray, int n, boolean bl) {
            return ByteUtils.bytesToUShort(byArray, n, bl);
        }

        @Override
        protected byte[] toBytes(int n, byte[] byArray, int n2, boolean bl) {
            return ByteUtils.shortToBytes(n, byArray, n2, bl);
        }
    }
    ,
    INT(4, 4){

        @Override
        public boolean isIntValue() {
            return true;
        }

        @Override
        public byte[] toggleEndian(byte[] byArray, boolean bl) {
            return ByteUtils.swapInts(bl ? (byte[])byArray.clone() : byArray, 0, byArray.length);
        }

        @Override
        protected int toInt(byte[] byArray, int n, boolean bl) {
            return ByteUtils.bytesToInt(byArray, n, bl);
        }

        @Override
        protected byte[] toBytes(int n, byte[] byArray, int n2, boolean bl) {
            return ByteUtils.intToBytes(n, byArray, n2, bl);
        }
    }
    ,
    TAG(4, 2){

        @Override
        public byte[] toggleEndian(byte[] byArray, boolean bl) {
            return ByteUtils.swapShorts(bl ? (byte[])byArray.clone() : byArray, 0, byArray.length);
        }

        @Override
        protected String toString(byte[] byArray, int n, boolean bl) {
            return TagUtils.toHexString(this.toInt(byArray, n, bl));
        }

        @Override
        protected int toInt(byte[] byArray, int n, boolean bl) {
            return ByteUtils.bytesToTag(byArray, n, bl);
        }

        @Override
        protected byte[] toBytes(String string, byte[] byArray, int n, boolean bl) {
            return this.toBytes(Integer.parseInt(string, 16), byArray, n, bl);
        }

        @Override
        protected byte[] toBytes(int n, byte[] byArray, int n2, boolean bl) {
            return ByteUtils.tagToBytes(n, byArray, n2, bl);
        }
    }
    ,
    FLOAT(4, 4){

        @Override
        public byte[] toggleEndian(byte[] byArray, boolean bl) {
            return ByteUtils.swapInts(bl ? (byte[])byArray.clone() : byArray, 0, byArray.length);
        }

        @Override
        protected String toString(byte[] byArray, int n, boolean bl) {
            return StringUtils.formatDS(ByteUtils.bytesToFloat(byArray, n, bl));
        }

        @Override
        protected float toFloat(byte[] byArray, int n, boolean bl) {
            return ByteUtils.bytesToFloat(byArray, n, bl);
        }

        @Override
        protected double toDouble(byte[] byArray, int n, boolean bl) {
            return ByteUtils.bytesToFloat(byArray, n, bl);
        }

        @Override
        protected byte[] toBytes(String string, byte[] byArray, int n, boolean bl) {
            return this.toBytes(Float.parseFloat(string), byArray, n, bl);
        }

        @Override
        protected byte[] toBytes(float f, byte[] byArray, int n, boolean bl) {
            return ByteUtils.floatToBytes(f, byArray, n, bl);
        }

        @Override
        protected byte[] toBytes(double d, byte[] byArray, int n, boolean bl) {
            return ByteUtils.floatToBytes((float)d, byArray, n, bl);
        }
    }
    ,
    DOUBLE(8, 8){

        @Override
        public byte[] toggleEndian(byte[] byArray, boolean bl) {
            return ByteUtils.swapLongs(bl ? (byte[])byArray.clone() : byArray, 0, byArray.length);
        }

        @Override
        protected String toString(byte[] byArray, int n, boolean bl) {
            return StringUtils.formatDS(ByteUtils.bytesToDouble(byArray, n, bl));
        }

        @Override
        protected float toFloat(byte[] byArray, int n, boolean bl) {
            return (float)ByteUtils.bytesToDouble(byArray, n, bl);
        }

        @Override
        protected double toDouble(byte[] byArray, int n, boolean bl) {
            return ByteUtils.bytesToDouble(byArray, n, bl);
        }

        @Override
        protected byte[] toBytes(String string, byte[] byArray, int n, boolean bl) {
            return this.toBytes(Double.parseDouble(string), byArray, n, bl);
        }

        @Override
        protected byte[] toBytes(float f, byte[] byArray, int n, boolean bl) {
            return ByteUtils.doubleToBytes(f, byArray, n, bl);
        }

        @Override
        protected byte[] toBytes(double d, byte[] byArray, int n, boolean bl) {
            return ByteUtils.doubleToBytes(d, byArray, n, bl);
        }
    };

    final int numBytes;
    final int numEndianBytes;

    private BinaryValueType(int n2, int n3) {
        this.numBytes = n2;
        this.numEndianBytes = n3;
    }

    @Override
    public boolean isIntValue() {
        return false;
    }

    @Override
    public boolean isStringValue() {
        return false;
    }

    @Override
    public boolean useSpecificCharacterSet() {
        return false;
    }

    @Override
    public boolean isTemporalType() {
        return false;
    }

    @Override
    public int numEndianBytes() {
        return this.numEndianBytes;
    }

    protected String toString(byte[] byArray, int n, boolean bl) {
        return Integer.toString(this.toInt(byArray, n, bl));
    }

    protected int toInt(byte[] byArray, int n, boolean bl) {
        throw new UnsupportedOperationException();
    }

    protected float toFloat(byte[] byArray, int n, boolean bl) {
        throw new UnsupportedOperationException();
    }

    protected double toDouble(byte[] byArray, int n, boolean bl) {
        throw new UnsupportedOperationException();
    }

    protected byte[] toBytes(String string, byte[] byArray, int n, boolean bl) {
        return this.toBytes(StringUtils.parseIS(string), byArray, n, bl);
    }

    protected byte[] toBytes(int n, byte[] byArray, int n2, boolean bl) {
        throw new UnsupportedOperationException();
    }

    protected byte[] toBytes(float f, byte[] byArray, int n, boolean bl) {
        throw new UnsupportedOperationException();
    }

    protected byte[] toBytes(double d, byte[] byArray, int n, boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] toBytes(Object object, SpecificCharacterSet specificCharacterSet) {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString(Object object, boolean bl, int n, String string) {
        if (!(object instanceof byte[])) {
            throw new UnsupportedOperationException();
        }
        int n2 = n * this.numBytes;
        byte[] byArray = (byte[])object;
        int n3 = byArray.length;
        return n2 + this.numBytes <= n3 ? this.toString(byArray, n2, bl) : string;
    }

    private void checkLength(int n) {
        if (n % this.numBytes != 0) {
            throw new IllegalArgumentException("length of value: " + n + ", number of bytes expected: " + this.numBytes + ", name of value type: " + this.name());
        }
    }

    @Override
    public Object toStrings(Object object, boolean bl, SpecificCharacterSet specificCharacterSet) {
        if (!(object instanceof byte[])) {
            throw new UnsupportedOperationException();
        }
        byte[] byArray = (byte[])object;
        int n = byArray.length;
        this.checkLength(n);
        if (n == this.numBytes) {
            return this.toString(byArray, 0, bl);
        }
        String[] stringArray = new String[n / this.numBytes];
        int n2 = 0;
        int n3 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = this.toString(byArray, n3, bl);
            ++n2;
            n3 += this.numBytes;
        }
        return stringArray;
    }

    @Override
    public int toInt(Object object, boolean bl, int n, int n2) {
        if (!(object instanceof byte[])) {
            throw new UnsupportedOperationException();
        }
        int n3 = n * this.numBytes;
        byte[] byArray = (byte[])object;
        int n4 = byArray.length;
        return n3 + this.numBytes <= n4 ? this.toInt(byArray, n3, bl) : n2;
    }

    @Override
    public int[] toInts(Object object, boolean bl) {
        if (!(object instanceof byte[])) {
            throw new UnsupportedOperationException();
        }
        byte[] byArray = (byte[])object;
        int n = byArray.length;
        this.checkLength(n);
        int[] nArray = new int[n / this.numBytes];
        int n2 = 0;
        int n3 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = this.toInt(byArray, n3, bl);
            ++n2;
            n3 += this.numBytes;
        }
        return nArray;
    }

    @Override
    public float toFloat(Object object, boolean bl, int n, float f) {
        if (!(object instanceof byte[])) {
            throw new UnsupportedOperationException();
        }
        int n2 = n * this.numBytes;
        byte[] byArray = (byte[])object;
        int n3 = byArray.length;
        return n2 + this.numBytes <= n3 ? this.toFloat(byArray, n2, bl) : f;
    }

    @Override
    public float[] toFloats(Object object, boolean bl) {
        if (!(object instanceof byte[])) {
            throw new UnsupportedOperationException();
        }
        byte[] byArray = (byte[])object;
        int n = byArray.length;
        this.checkLength(n);
        float[] fArray = new float[n / this.numBytes];
        int n2 = 0;
        int n3 = 0;
        while (n2 < fArray.length) {
            fArray[n2] = this.toFloat(byArray, n3, bl);
            ++n2;
            n3 += this.numBytes;
        }
        return fArray;
    }

    @Override
    public double toDouble(Object object, boolean bl, int n, double d) {
        if (!(object instanceof byte[])) {
            throw new UnsupportedOperationException();
        }
        int n2 = n * this.numBytes;
        byte[] byArray = (byte[])object;
        int n3 = byArray.length;
        return n2 + this.numBytes <= n3 ? this.toDouble(byArray, n2, bl) : d;
    }

    @Override
    public double[] toDoubles(Object object, boolean bl) {
        if (!(object instanceof byte[])) {
            throw new UnsupportedOperationException();
        }
        byte[] byArray = (byte[])object;
        int n = byArray.length;
        this.checkLength(n);
        double[] dArray = new double[n / this.numBytes];
        int n2 = 0;
        int n3 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = this.toDouble(byArray, n3, bl);
            ++n2;
            n3 += this.numBytes;
        }
        return dArray;
    }

    @Override
    public Date toDate(Object object, TimeZone timeZone, int n, boolean bl, Date date, DatePrecision datePrecision) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date[] toDate(Object object, TimeZone timeZone, boolean bl, DatePrecisions datePrecisions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object toValue(byte[] byArray) {
        return byArray != null && byArray.length > 0 ? (Object)byArray : Value.NULL;
    }

    @Override
    public Object toValue(String string, boolean bl) {
        if (string == null || string.isEmpty()) {
            return Value.NULL;
        }
        return this.toBytes(string, new byte[this.numBytes], 0, bl);
    }

    @Override
    public Object toValue(String[] stringArray, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            return Value.NULL;
        }
        if (stringArray.length == 1) {
            return this.toValue(stringArray[0], bl);
        }
        byte[] byArray = new byte[stringArray.length * this.numBytes];
        int n = 0;
        int n2 = 0;
        while (n < stringArray.length) {
            this.toBytes(stringArray[n], byArray, n2, bl);
            ++n;
            n2 += this.numBytes;
        }
        return byArray;
    }

    @Override
    public Object toValue(int[] nArray, boolean bl) {
        if (nArray == null || nArray.length == 0) {
            return Value.NULL;
        }
        byte[] byArray = new byte[nArray.length * this.numBytes];
        int n = 0;
        int n2 = 0;
        while (n < nArray.length) {
            this.toBytes(nArray[n], byArray, n2, bl);
            ++n;
            n2 += this.numBytes;
        }
        return byArray;
    }

    @Override
    public Object toValue(float[] fArray, boolean bl) {
        if (fArray == null || fArray.length == 0) {
            return Value.NULL;
        }
        byte[] byArray = new byte[fArray.length * this.numBytes];
        int n = 0;
        int n2 = 0;
        while (n < fArray.length) {
            this.toBytes(fArray[n], byArray, n2, bl);
            ++n;
            n2 += this.numBytes;
        }
        return byArray;
    }

    @Override
    public Object toValue(double[] dArray, boolean bl) {
        if (dArray == null || dArray.length == 0) {
            return Value.NULL;
        }
        byte[] byArray = new byte[dArray.length * this.numBytes];
        int n = 0;
        int n2 = 0;
        while (n < dArray.length) {
            this.toBytes(dArray[n], byArray, n2, bl);
            ++n;
            n2 += this.numBytes;
        }
        return byArray;
    }

    @Override
    public Object toValue(Date[] dateArray, TimeZone timeZone, DatePrecision datePrecision) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean prompt(Object object, boolean bl, SpecificCharacterSet specificCharacterSet, int n, StringBuilder stringBuilder) {
        if (object instanceof byte[]) {
            return this.prompt((byte[])object, bl, n, stringBuilder);
        }
        return StringValueType.prompt(object.toString(), n, stringBuilder);
    }

    private boolean prompt(byte[] byArray, boolean bl, int n, StringBuilder stringBuilder) {
        int n2 = stringBuilder.length() + n;
        int n3 = byArray.length / this.numBytes;
        int n4 = 0;
        while (n3-- > 0) {
            stringBuilder.append(this.toString(byArray, n4, bl));
            if (stringBuilder.length() > n2) {
                stringBuilder.setLength(n2 + 1);
                return false;
            }
            if (n3 > 0) {
                stringBuilder.append('\\');
            }
            n4 += this.numBytes;
        }
        return true;
    }

    @Override
    public int vmOf(Object object) {
        if (object instanceof byte[]) {
            return ((byte[])object).length / this.numBytes;
        }
        throw new UnsupportedOperationException();
    }

    /* synthetic */ BinaryValueType(String string, int n, int n2, int n3, BinaryValueType binaryValueType) {
        this(n2, n3);
    }
}

