/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.Value;
import org.dcm4che3.io.DicomEncodingOptions;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.StreamUtils;
import org.dcm4che3.util.StringUtils;

public class BulkData
implements Value {
    public static final int MAGIC_LEN = 64507;
    public final String uri;
    public final String uuid;
    public final boolean bigEndian;
    private int uriPathEnd;
    private long offset;
    private int length = -1;
    private long[] offsets;
    private int[] lengths;

    public BulkData(String string, String string2, boolean bl) {
        if (string2 != null) {
            if (string != null) {
                throw new IllegalArgumentException("uuid and uri are mutually exclusive");
            }
            this.parseURI(string2);
        } else if (string == null) {
            throw new IllegalArgumentException("uuid or uri must be not null");
        }
        this.uuid = string;
        this.uri = string2;
        this.bigEndian = bl;
    }

    public BulkData(String string, long l, int n, boolean bl) {
        this.uuid = null;
        this.uriPathEnd = string.length();
        this.uri = String.valueOf(string) + "?offset=" + l + "&length=" + n;
        this.offset = l;
        this.length = n;
        this.bigEndian = bl;
    }

    public BulkData(String string, long[] lArray, int[] nArray, boolean bl) {
        if (lArray.length == 0) {
            throw new IllegalArgumentException("offsets.length == 0");
        }
        if (lArray.length != nArray.length) {
            throw new IllegalArgumentException("offsets.length[" + lArray.length + "] != lengths.length[" + nArray.length + "]");
        }
        this.uuid = null;
        this.uriPathEnd = string.length();
        this.uri = this.appendQuery(string, lArray, nArray);
        this.offsets = (long[])lArray.clone();
        this.lengths = (int[])nArray.clone();
        this.bigEndian = bl;
    }

    public static BulkData fromFragments(Fragments fragments) {
        int n = fragments.size();
        String string = null;
        long[] lArray = new long[n];
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            Object e = fragments.get(n2);
            if (e != Value.NULL) {
                BulkData bulkData = (BulkData)e;
                String string2 = bulkData.uriWithoutQuery();
                if (string == null) {
                    string = string2;
                } else if (!string.equals(string2)) {
                    throw new IllegalArgumentException("BulkData URIs references different Resources");
                }
                if (bulkData.length() == -1) {
                    throw new IllegalArgumentException("BulkData Reference with unspecified length");
                }
                lArray[n2] = bulkData.offset();
                nArray[n2] = bulkData.length();
            }
            ++n2;
        }
        return new BulkData(string, lArray, nArray, false);
    }

    public boolean hasFragments() {
        return this.offsets != null && this.lengths != null;
    }

    public Fragments toFragments(String string, int n, VR vR) {
        if (this.offsets == null || this.lengths == null) {
            throw new UnsupportedOperationException();
        }
        if (this.offsets.length != this.lengths.length) {
            throw new IllegalStateException("offsets.length[" + this.offsets.length + "] != lengths.length[" + this.lengths.length + "]");
        }
        Fragments fragments = new Fragments(string, n, vR, this.bigEndian, this.lengths.length);
        String string2 = this.uriWithoutQuery();
        int n2 = 0;
        while (n2 < this.lengths.length) {
            fragments.add(this.lengths[n2] == 0 ? Value.NULL : new BulkData(string2, this.offsets[n2], this.lengths[n2], this.bigEndian));
            ++n2;
        }
        return fragments;
    }

    private void parseURI(String string) {
        int n = string.indexOf(63);
        if (n == -1) {
            this.uriPathEnd = string.length();
            return;
        }
        this.uriPathEnd = n;
        if (string.startsWith("offset=", n + 1)) {
            this.parseURIWithOffset(string, n + 8);
        } else if (string.startsWith("offsets=", n + 1)) {
            this.parseURIWithOffsets(string, n + 9);
        }
    }

    private void parseURIWithOffset(String string, int n) {
        int n2 = string.indexOf("&length=");
        if (n2 == -1) {
            return;
        }
        try {
            this.offset = Long.parseLong(string.substring(n, n2));
            this.length = Integer.parseInt(string.substring(n2 + 8));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void parseURIWithOffsets(String string, int n) {
        int n2 = string.indexOf("&lengths=");
        if (n2 == -1) {
            return;
        }
        try {
            this.offsets = BulkData.parseLongs(string.substring(n, n2));
            this.lengths = BulkData.parseInts(string.substring(n2 + 9));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private static long[] parseLongs(String string) {
        String[] stringArray = StringUtils.split(string, ',');
        long[] lArray = new long[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            lArray[n] = Long.parseLong(stringArray[n]);
            ++n;
        }
        return lArray;
    }

    private static int[] parseInts(String string) {
        String[] stringArray = StringUtils.split(string, ',');
        int[] nArray = new int[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            nArray[n] = Integer.parseInt(stringArray[n]);
            ++n;
        }
        return nArray;
    }

    private String appendQuery(String string, long[] lArray, int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append("?offsets=");
        long[] lArray2 = lArray;
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long l = lArray2[n2];
            stringBuilder.append(l).append(',');
            ++n2;
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        stringBuilder.append("&lengths=");
        int[] nArray2 = nArray;
        n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            stringBuilder.append(n4).append(',');
            ++n3;
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public long offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public long[] offsets() {
        return this.offsets;
    }

    public int[] lengths() {
        return this.lengths;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    public String toString() {
        return "BulkData[uuid=" + this.uuid + ", uri=" + this.uri + ", bigEndian=" + this.bigEndian + "]";
    }

    public File getFile() {
        try {
            return new File(new URI(this.uriWithoutQuery()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException("uri: " + this.uri);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException("uri: " + this.uri);
        }
    }

    public String uriWithoutQuery() {
        if (this.uri == null) {
            throw new IllegalStateException("uri: null");
        }
        return this.uri.substring(0, this.uriPathEnd);
    }

    public InputStream openStream() throws IOException {
        if (this.uri == null) {
            throw new IllegalStateException("uri: null");
        }
        if (!this.uri.startsWith("file:")) {
            return new URL(this.uri).openStream();
        }
        FileInputStream fileInputStream = new FileInputStream(this.getFile());
        StreamUtils.skipFully(fileInputStream, this.offset);
        return fileInputStream;
    }

    @Override
    public int calcLength(DicomEncodingOptions dicomEncodingOptions, boolean bl, VR vR) {
        if (this.length == -1) {
            throw new UnsupportedOperationException();
        }
        return this.length + 1 & 0xFFFFFFFE;
    }

    @Override
    public int getEncodedLength(DicomEncodingOptions dicomEncodingOptions, boolean bl, VR vR) {
        return this.length == -1 ? -1 : this.length + 1 & 0xFFFFFFFE;
    }

    @Override
    public byte[] toBytes(VR vR, boolean bl) throws IOException {
        if (this.length == -1) {
            throw new UnsupportedOperationException();
        }
        if (this.length == 0) {
            return ByteUtils.EMPTY_BYTES;
        }
        InputStream inputStream = this.openStream();
        try {
            byte[] byArray = new byte[this.length];
            StreamUtils.readFully(inputStream, byArray, 0, byArray.length);
            if (this.bigEndian != bl) {
                vR.toggleEndian(byArray, false);
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public void writeTo(DicomOutputStream dicomOutputStream, VR vR) throws IOException {
        InputStream inputStream = this.openStream();
        try {
            if (this.bigEndian != dicomOutputStream.isBigEndian()) {
                StreamUtils.copy(inputStream, (OutputStream)dicomOutputStream, this.length, vR.numEndianBytes());
            } else {
                StreamUtils.copy(inputStream, (OutputStream)dicomOutputStream, this.length);
            }
            if ((this.length & 1) != 0) {
                dicomOutputStream.write(vR.paddingByte());
            }
        }
        finally {
            inputStream.close();
        }
    }

    public void serializeTo(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(StringUtils.maskNull(this.uuid, ""));
        objectOutputStream.writeUTF(StringUtils.maskNull(this.uri, ""));
        objectOutputStream.writeBoolean(this.bigEndian);
    }

    public static Value deserializeFrom(ObjectInputStream objectInputStream) throws IOException {
        return new BulkData(StringUtils.maskEmpty(objectInputStream.readUTF(), null), StringUtils.maskEmpty(objectInputStream.readUTF(), null), objectInputStream.readBoolean());
    }
}

