/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.util.ServiceLoader;
import org.dcm4che3.data.StandardElementDictionary;
import org.dcm4che3.data.VR;

public abstract class ElementDictionary {
    private static final ServiceLoader<ElementDictionary> loader = ServiceLoader.load(ElementDictionary.class);
    private final String privateCreator;
    private final Class<?> tagClass;

    protected ElementDictionary(String string, Class<?> clazz) {
        this.privateCreator = string;
        this.tagClass = clazz;
    }

    public static ElementDictionary getStandardElementDictionary() {
        return StandardElementDictionary.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ElementDictionary getElementDictionary(String string) {
        if (string != null) {
            ServiceLoader<ElementDictionary> serviceLoader = loader;
            synchronized (serviceLoader) {
                for (ElementDictionary elementDictionary : loader) {
                    if (!string.equals(elementDictionary.getPrivateCreator())) continue;
                    return elementDictionary;
                }
            }
        }
        return ElementDictionary.getStandardElementDictionary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload() {
        ServiceLoader<ElementDictionary> serviceLoader = loader;
        synchronized (serviceLoader) {
            loader.reload();
        }
    }

    public static VR vrOf(int n, String string) {
        return ElementDictionary.getElementDictionary(string).vrOf(n);
    }

    public static String keywordOf(int n, String string) {
        return ElementDictionary.getElementDictionary(string).keywordOf(n);
    }

    public static int tagForKeyword(String string, String string2) {
        return ElementDictionary.getElementDictionary(string2).tagForKeyword(string);
    }

    public final String getPrivateCreator() {
        return this.privateCreator;
    }

    public Class<?> getTagClass() {
        return this.tagClass;
    }

    public abstract VR vrOf(int var1);

    public abstract String keywordOf(int var1);

    public int tmTagOf(int n) {
        return 0;
    }

    public int daTagOf(int n) {
        return 0;
    }

    public int tagForKeyword(String string) {
        if (this.tagClass != null) {
            try {
                return this.tagClass.getField(string).getInt(null);
            }
            catch (Exception exception) {}
        }
        return -1;
    }
}

