/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.StringUtils;

public class IDWithIssuer {
    public static final IDWithIssuer[] EMPTY = new IDWithIssuer[0];
    private final String id;
    private String identifierTypeCode;
    private Issuer issuer;

    public IDWithIssuer(String string, Issuer issuer) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("empty id");
        }
        this.id = string;
        this.setIssuer(issuer);
    }

    public IDWithIssuer(String string, String string2) {
        this.id = string;
        this.setIssuer(string2 != null ? new Issuer(string2, '&') : null);
    }

    public IDWithIssuer(String string) {
        String[] stringArray = StringUtils.split(string, '^');
        this.id = stringArray[0];
        this.setIdentifierTypeCode(stringArray.length > 4 ? stringArray[4] : null);
        this.setIssuer(stringArray.length > 3 ? new Issuer(stringArray[3], '&') : null);
    }

    public final String getID() {
        return this.id;
    }

    public final String getIdentifierTypeCode() {
        return this.identifierTypeCode;
    }

    public final void setIdentifierTypeCode(String string) {
        this.identifierTypeCode = string;
    }

    public final Issuer getIssuer() {
        return this.issuer;
    }

    public final void setIssuer(Issuer issuer) {
        this.issuer = issuer;
    }

    public String toString() {
        if (this.issuer == null && this.identifierTypeCode == null) {
            return this.id;
        }
        StringBuilder stringBuilder = new StringBuilder(this.id);
        stringBuilder.append("^^^");
        if (this.issuer != null) {
            stringBuilder.append(this.issuer.toString('&'));
        }
        if (this.identifierTypeCode != null) {
            stringBuilder.append('^').append(this.identifierTypeCode);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = this.id.hashCode();
        if (this.identifierTypeCode != null) {
            n += this.identifierTypeCode.hashCode() * 31;
        }
        if (this.issuer != null) {
            n += this.issuer.hashCode() * 31;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IDWithIssuer)) {
            return false;
        }
        IDWithIssuer iDWithIssuer = (IDWithIssuer)object;
        return this.id.equals(iDWithIssuer.id) && (this.identifierTypeCode == null ? iDWithIssuer.identifierTypeCode == null : this.identifierTypeCode.equals(this.identifierTypeCode)) && (this.issuer == null ? iDWithIssuer.issuer == null : this.issuer.equals(iDWithIssuer.issuer));
    }

    public boolean matches(IDWithIssuer iDWithIssuer) {
        return this.id.equals(iDWithIssuer.id) && (this.issuer == null ? iDWithIssuer.issuer == null : this.issuer.matches(iDWithIssuer.issuer));
    }

    public Attributes exportPatientIDWithIssuer(Attributes attributes) {
        if (attributes == null) {
            attributes = new Attributes(3);
        }
        attributes.setString(0x100020, VR.LO, this.id);
        if (this.issuer == null && this.identifierTypeCode == null) {
            return attributes;
        }
        if (this.issuer != null) {
            this.issuer.toIssuerOfPatientID(attributes);
        }
        if (this.identifierTypeCode != null) {
            Attributes attributes2 = attributes.getNestedDataset(1048612);
            if (attributes2 == null) {
                attributes2 = new Attributes(1);
                attributes.newSequence(1048612, 1).add(attributes2);
            }
            attributes2.setString(4194357, VR.CS, this.identifierTypeCode);
        }
        return attributes;
    }

    public static IDWithIssuer valueOf(Attributes attributes, int n, int n2) {
        String string = attributes.getString(n);
        if (string == null) {
            return null;
        }
        return new IDWithIssuer(string, Issuer.valueOf(attributes.getNestedDataset(n2)));
    }

    public static IDWithIssuer pidOf(Attributes attributes) {
        String string = attributes.getString(0x100020);
        if (string == null) {
            return null;
        }
        IDWithIssuer iDWithIssuer = new IDWithIssuer(string, Issuer.fromIssuerOfPatientID(attributes));
        iDWithIssuer.setIdentifierTypeCode(IDWithIssuer.identifierTypeCodeOf(attributes));
        return iDWithIssuer;
    }

    private static String identifierTypeCodeOf(Attributes attributes) {
        Attributes attributes2 = attributes.getNestedDataset(1048612);
        return attributes2 != null ? attributes2.getString(4194357) : null;
    }

    public static Set<IDWithIssuer> pidsOf(Attributes attributes) {
        IDWithIssuer iDWithIssuer = IDWithIssuer.pidOf(attributes);
        Sequence sequence = attributes.getSequence(0x101002);
        if (sequence == null) {
            if (iDWithIssuer == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(iDWithIssuer);
        }
        HashSet<IDWithIssuer> hashSet = new HashSet<IDWithIssuer>(1 + sequence.size() << 1);
        if (iDWithIssuer != null) {
            hashSet.add(iDWithIssuer);
        }
        for (Attributes attributes2 : sequence) {
            iDWithIssuer = IDWithIssuer.pidOf(attributes2);
            if (iDWithIssuer == null) continue;
            hashSet.add(iDWithIssuer);
        }
        return hashSet;
    }
}

