/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.Value;
import org.dcm4che3.io.DicomEncodingOptions;
import org.dcm4che3.io.DicomOutputStream;

public class Sequence
extends ArrayList<Attributes>
implements Value {
    private static final long serialVersionUID = 7062970085409148066L;
    private final Attributes parent;
    private final String privateCreator;
    private final int tag;
    private int length = -1;

    Sequence(Attributes attributes, String string, int n, int n2) {
        super(n2);
        this.parent = attributes;
        this.privateCreator = string;
        this.tag = n;
    }

    public final Attributes getParent() {
        return this.parent;
    }

    public void trimToSize(boolean bl) {
        super.trimToSize();
        if (bl) {
            for (Attributes attributes : this) {
                attributes.trimToSize(bl);
            }
        }
    }

    @Override
    public int indexOf(Object object) {
        ListIterator listIterator = this.listIterator();
        while (listIterator.hasNext()) {
            if (listIterator.next() != object) continue;
            return listIterator.previousIndex();
        }
        return -1;
    }

    @Override
    public boolean add(Attributes attributes) {
        return super.add(attributes.setParent(this.parent, this.privateCreator, this.tag));
    }

    @Override
    public void add(int n, Attributes attributes) {
        super.add(n, attributes.setParent(this.parent, this.privateCreator, this.tag));
    }

    @Override
    public boolean addAll(Collection<? extends Attributes> collection) {
        this.setParent(collection);
        return super.addAll(collection);
    }

    private void setParent(Collection<? extends Attributes> collection) {
        boolean bl = this.parent.bigEndian();
        for (Attributes attributes : collection) {
            if (attributes.bigEndian() != bl) {
                throw new IllegalArgumentException("Endian of Item must match Endian of parent Data Set");
            }
            if (attributes.isRoot()) continue;
            throw new IllegalArgumentException("Item already contained by Sequence");
        }
        for (Attributes attributes : collection) {
            attributes.setParent(this.parent, this.privateCreator, this.tag);
        }
    }

    @Override
    public boolean addAll(int n, Collection<? extends Attributes> collection) {
        this.setParent(collection);
        return super.addAll(n, collection);
    }

    @Override
    public void clear() {
        for (Attributes attributes : this) {
            attributes.setParent(null, null, 0);
        }
        super.clear();
    }

    @Override
    public Attributes remove(int n) {
        return ((Attributes)super.remove(n)).setParent(null, null, 0);
    }

    @Override
    public boolean remove(Object object) {
        if (object instanceof Attributes && super.remove(object)) {
            ((Attributes)object).setParent(null, null, 0);
            return true;
        }
        return false;
    }

    @Override
    public Attributes set(int n, Attributes attributes) {
        return super.set(n, attributes.setParent(this.parent, this.privateCreator, this.tag));
    }

    @Override
    public String toString() {
        return this.size() + " Items";
    }

    @Override
    public int calcLength(DicomEncodingOptions dicomEncodingOptions, boolean bl, VR vR) {
        int n = 0;
        for (Attributes attributes : this) {
            n += 8 + attributes.calcLength(dicomEncodingOptions, bl);
            if (!(attributes.isEmpty() ? dicomEncodingOptions.undefEmptyItemLength : dicomEncodingOptions.undefItemLength)) continue;
            n += 8;
        }
        if (this.isEmpty() ? dicomEncodingOptions.undefEmptySequenceLength : dicomEncodingOptions.undefSequenceLength) {
            n += 8;
        }
        this.length = n;
        return n;
    }

    @Override
    public int getEncodedLength(DicomEncodingOptions dicomEncodingOptions, boolean bl, VR vR) {
        if (this.isEmpty()) {
            return dicomEncodingOptions.undefEmptySequenceLength ? -1 : 0;
        }
        if (dicomEncodingOptions.undefSequenceLength) {
            return -1;
        }
        if (this.length == -1) {
            this.calcLength(dicomEncodingOptions, bl, vR);
        }
        return this.length;
    }

    @Override
    public void writeTo(DicomOutputStream dicomOutputStream, VR vR) throws IOException {
        for (Attributes attributes : this) {
            attributes.writeItemTo(dicomOutputStream);
        }
    }

    @Override
    public byte[] toBytes(VR vR, boolean bl) throws IOException {
        throw new UnsupportedOperationException();
    }
}

