/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.util.Date;
import java.util.TimeZone;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.data.DatePrecisions;
import org.dcm4che3.data.SpecificCharacterSet;
import org.dcm4che3.data.TemporalType;
import org.dcm4che3.data.Value;
import org.dcm4che3.data.ValueType;
import org.dcm4che3.util.StringUtils;

enum StringValueType implements ValueType
{
    ASCII(false, true, null, null),
    STRING(true, true, "\\", null),
    TEXT(true, false, "\n\f\r", null),
    UR(false, false, null, null),
    DA(false, true, null, TemporalType.DA),
    DT(false, true, null, TemporalType.DT),
    TM(false, true, null, TemporalType.TM),
    PN(true, true, "^=\\", null),
    DS(false, true, null, null){

        @Override
        public byte[] toBytes(Object object, SpecificCharacterSet specificCharacterSet) {
            if (object instanceof double[]) {
                object = this.toStrings((double[])object);
            }
            return super.toBytes(object, specificCharacterSet);
        }

        @Override
        public String toString(Object object, boolean bl, int n, String string) {
            if (object instanceof double[]) {
                double[] dArray = (double[])object;
                return n < dArray.length && !Double.isNaN(dArray[n]) ? StringUtils.formatDS(dArray[n]) : string;
            }
            return super.toString(object, bl, n, string);
        }

        @Override
        public Object toStrings(Object object, boolean bl, SpecificCharacterSet specificCharacterSet) {
            return object instanceof double[] ? this.toStrings((double[])object) : super.toStrings(object, bl, specificCharacterSet);
        }

        private Object toStrings(double[] dArray) {
            if (dArray.length == 1) {
                return StringUtils.formatDS(dArray[0]);
            }
            String[] stringArray = new String[dArray.length];
            int n = 0;
            while (n < dArray.length) {
                stringArray[n] = !Double.isNaN(dArray[n]) ? StringUtils.formatDS(dArray[n]) : "";
                ++n;
            }
            return stringArray;
        }

        @Override
        public float toFloat(Object object, boolean bl, int n, float f) {
            double[] dArray = (double[])object;
            return n < dArray.length && !Double.isNaN(dArray[n]) ? (float)dArray[n] : f;
        }

        @Override
        public float[] toFloats(Object object, boolean bl) {
            double[] dArray = (double[])object;
            float[] fArray = new float[dArray.length];
            int n = 0;
            while (n < fArray.length) {
                fArray[n] = (float)dArray[n];
                ++n;
            }
            return fArray;
        }

        @Override
        public double toDouble(Object object, boolean bl, int n, double d) {
            double[] dArray = (double[])object;
            return n < dArray.length && !Double.isNaN(dArray[n]) ? dArray[n] : d;
        }

        @Override
        public double[] toDoubles(Object object, boolean bl) {
            return (double[])object;
        }

        @Override
        public Object toValue(float[] fArray, boolean bl) {
            if (fArray == null || fArray.length == 0) {
                return Value.NULL;
            }
            if (fArray.length == 1) {
                return StringUtils.formatDS(fArray[0]);
            }
            String[] stringArray = new String[fArray.length];
            int n = 0;
            while (n < fArray.length) {
                stringArray[n] = StringUtils.formatDS(fArray[n]);
                ++n;
            }
            return stringArray;
        }

        @Override
        public Object toValue(double[] dArray, boolean bl) {
            if (dArray == null || dArray.length == 0) {
                return Value.NULL;
            }
            return dArray;
        }

        @Override
        public boolean prompt(Object object, boolean bl, SpecificCharacterSet specificCharacterSet, int n, StringBuilder stringBuilder) {
            if (object instanceof double[]) {
                object = this.toStrings((double[])object);
            }
            return super.prompt(object, bl, specificCharacterSet, n, stringBuilder);
        }
    }
    ,
    IS(false, true, null, null){

        @Override
        public boolean isIntValue() {
            return true;
        }

        @Override
        public byte[] toBytes(Object object, SpecificCharacterSet specificCharacterSet) {
            if (object instanceof int[]) {
                object = this.toStrings((int[])object);
            }
            return super.toBytes(object, specificCharacterSet);
        }

        @Override
        public String toString(Object object, boolean bl, int n, String string) {
            if (object instanceof int[]) {
                int[] nArray = (int[])object;
                return n < nArray.length && nArray[n] != Integer.MIN_VALUE ? Integer.toString(nArray[n]) : string;
            }
            return super.toString(object, bl, n, string);
        }

        @Override
        public Object toStrings(Object object, boolean bl, SpecificCharacterSet specificCharacterSet) {
            return object instanceof int[] ? this.toStrings((int[])object) : super.toStrings(object, bl, specificCharacterSet);
        }

        private Object toStrings(int[] nArray) {
            if (nArray.length == 1) {
                return Integer.toString(nArray[0]);
            }
            String[] stringArray = new String[nArray.length];
            int n = 0;
            while (n < nArray.length) {
                stringArray[n] = nArray[n] != Integer.MIN_VALUE ? Integer.toString(nArray[n]) : "";
                ++n;
            }
            return stringArray;
        }

        @Override
        public int toInt(Object object, boolean bl, int n, int n2) {
            int[] nArray = (int[])object;
            return n < nArray.length && nArray[n] != Integer.MIN_VALUE ? nArray[n] : n2;
        }

        @Override
        public int[] toInts(Object object, boolean bl) {
            return (int[])object;
        }

        @Override
        public Object toValue(int[] nArray, boolean bl) {
            if (nArray == null || nArray.length == 0) {
                return Value.NULL;
            }
            return nArray;
        }

        @Override
        public boolean prompt(Object object, boolean bl, SpecificCharacterSet specificCharacterSet, int n, StringBuilder stringBuilder) {
            if (object instanceof int[]) {
                object = this.toStrings((int[])object);
            }
            return super.prompt(object, bl, specificCharacterSet, n, stringBuilder);
        }
    };

    final boolean useSpecificCharacterSet;
    final boolean multipleValues;
    final String delimiters;
    final TemporalType temporalType;

    private StringValueType(boolean bl, boolean bl2, String string2, TemporalType temporalType) {
        this.useSpecificCharacterSet = bl;
        this.multipleValues = bl2;
        this.delimiters = string2;
        this.temporalType = temporalType;
    }

    @Override
    public boolean isStringValue() {
        return true;
    }

    @Override
    public boolean isIntValue() {
        return false;
    }

    @Override
    public boolean isTemporalType() {
        return this.temporalType != null;
    }

    @Override
    public int numEndianBytes() {
        return 1;
    }

    @Override
    public byte[] toggleEndian(byte[] byArray, boolean bl) {
        return byArray;
    }

    @Override
    public boolean useSpecificCharacterSet() {
        return this.useSpecificCharacterSet;
    }

    private SpecificCharacterSet cs(SpecificCharacterSet specificCharacterSet) {
        return this.useSpecificCharacterSet ? specificCharacterSet : SpecificCharacterSet.DEFAULT;
    }

    @Override
    public byte[] toBytes(Object object, SpecificCharacterSet specificCharacterSet) {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return this.cs(specificCharacterSet).encode((String)object, this.delimiters);
        }
        if (object instanceof String[]) {
            return this.cs(specificCharacterSet).encode(StringUtils.concat((String[])object, '\\'), this.delimiters);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString(Object object, boolean bl, int n, String string) {
        if (object instanceof String) {
            return (String)(n == 0 ? object : string);
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            return n < stringArray.length && !stringArray[n].isEmpty() ? stringArray[n] : string;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object toStrings(Object object, boolean bl, SpecificCharacterSet specificCharacterSet) {
        if (object instanceof byte[]) {
            String string = this.cs(specificCharacterSet).decode((byte[])object);
            return this.multipleValues ? StringUtils.splitAndTrim(string, '\\') : StringUtils.trimTrailing(string);
        }
        if (object instanceof String || object instanceof String[]) {
            return object;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int toInt(Object object, boolean bl, int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] toInts(Object object, boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float toFloat(Object object, boolean bl, int n, float f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float[] toFloats(Object object, boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double toDouble(Object object, boolean bl, int n, double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[] toDoubles(Object object, boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date toDate(Object object, TimeZone timeZone, int n, boolean bl, Date date, DatePrecision datePrecision) {
        if (this.temporalType == null) {
            throw new UnsupportedOperationException();
        }
        if (object instanceof String) {
            return n == 0 ? this.temporalType.parse(timeZone, (String)object, bl, datePrecision) : date;
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            return n < stringArray.length && stringArray[n] != null ? this.temporalType.parse(timeZone, stringArray[n], bl, datePrecision) : date;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Date[] toDate(Object object, TimeZone timeZone, boolean bl, DatePrecisions datePrecisions) {
        if (this.temporalType == null) {
            throw new UnsupportedOperationException();
        }
        if (object instanceof String) {
            datePrecisions.precisions = new DatePrecision[1];
            Date[] dateArray = new Date[1];
            datePrecisions.precisions[0] = new DatePrecision();
            dateArray[0] = this.temporalType.parse(timeZone, (String)object, bl, datePrecisions.precisions[0]);
            return dateArray;
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            Date[] dateArray = new Date[stringArray.length];
            datePrecisions.precisions = new DatePrecision[stringArray.length];
            int n = 0;
            while (n < dateArray.length) {
                if (stringArray[n] != null) {
                    datePrecisions.precisions[n] = new DatePrecision();
                    dateArray[n] = this.temporalType.parse(timeZone, stringArray[n], bl, datePrecisions.precisions[n]);
                }
                ++n;
            }
            return dateArray;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object toValue(byte[] byArray) {
        return byArray != null && byArray.length > 0 ? (Object)byArray : Value.NULL;
    }

    @Override
    public Object toValue(String string, boolean bl) {
        if (string == null || string.isEmpty()) {
            return Value.NULL;
        }
        return string;
    }

    @Override
    public Object toValue(String[] stringArray, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            return Value.NULL;
        }
        if (stringArray.length == 1) {
            return this.toValue(stringArray[0], bl);
        }
        return stringArray;
    }

    @Override
    public Object toValue(int[] nArray, boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object toValue(float[] fArray, boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object toValue(double[] dArray, boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object toValue(Date[] dateArray, TimeZone timeZone, DatePrecision datePrecision) {
        if (this.temporalType == null) {
            throw new UnsupportedOperationException();
        }
        if (dateArray == null || dateArray.length == 0) {
            return Value.NULL;
        }
        if (dateArray.length == 1) {
            return this.temporalType.format(timeZone, dateArray[0], datePrecision);
        }
        String[] stringArray = new String[dateArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = this.temporalType.format(timeZone, dateArray[n], datePrecision);
            ++n;
        }
        return stringArray;
    }

    @Override
    public boolean prompt(Object object, boolean bl, SpecificCharacterSet specificCharacterSet, int n, StringBuilder stringBuilder) {
        if (object instanceof byte[]) {
            return StringValueType.prompt(this.cs(specificCharacterSet).decode((byte[])object), n, stringBuilder);
        }
        if (object instanceof String) {
            return StringValueType.prompt((String)object, n, stringBuilder);
        }
        if (object instanceof String[]) {
            return StringValueType.prompt((String[])object, n, stringBuilder);
        }
        return StringValueType.prompt(object.toString(), n, stringBuilder);
    }

    static boolean prompt(String string, int n, StringBuilder stringBuilder) {
        int n2 = stringBuilder.length() + n;
        stringBuilder.append(string.trim());
        if (stringBuilder.length() > n2) {
            stringBuilder.setLength(n2 + 1);
            return false;
        }
        return true;
    }

    static boolean prompt(String[] stringArray, int n, StringBuilder stringBuilder) {
        int n2 = stringBuilder.length() + n;
        String[] stringArray2 = stringArray;
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String string = stringArray2[n4];
            if (string != null) {
                stringBuilder.append(string);
            }
            if (stringBuilder.length() > n2) {
                stringBuilder.setLength(n2 + 1);
                return false;
            }
            stringBuilder.append('\\');
            ++n4;
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return true;
    }

    @Override
    public int vmOf(Object object) {
        if (object instanceof String) {
            return 1;
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            return stringArray.length;
        }
        throw new UnsupportedOperationException();
    }

    /* synthetic */ StringValueType(String string, int n, boolean bl, boolean bl2, String string2, TemporalType temporalType, StringValueType stringValueType) {
        this(bl, bl2, string2, temporalType);
    }
}

