/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.util.Date;
import java.util.TimeZone;
import org.dcm4che3.data.BinaryValueType;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.data.DatePrecisions;
import org.dcm4che3.data.SequenceValueType;
import org.dcm4che3.data.SpecificCharacterSet;
import org.dcm4che3.data.StringValueType;
import org.dcm4che3.data.ValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum VR {
    AE(16709, 8, 32, StringValueType.ASCII, false),
    AS(16723, 8, 32, StringValueType.ASCII, false),
    AT(16724, 8, 0, BinaryValueType.TAG, false),
    CS(17235, 8, 32, StringValueType.ASCII, false),
    DA(17473, 8, 32, StringValueType.DA, false),
    DS(17491, 8, 32, StringValueType.DS, false),
    DT(17492, 8, 32, StringValueType.DT, false),
    FD(17988, 8, 0, BinaryValueType.DOUBLE, false),
    FL(17996, 8, 0, BinaryValueType.FLOAT, false),
    IS(18771, 8, 32, StringValueType.IS, false),
    LO(19535, 8, 32, StringValueType.STRING, false),
    LT(19540, 8, 32, StringValueType.TEXT, false),
    OB(20290, 12, 0, BinaryValueType.BYTE, true),
    OD(20292, 12, 0, BinaryValueType.DOUBLE, true),
    OF(20294, 12, 0, BinaryValueType.FLOAT, true),
    OW(20311, 12, 0, BinaryValueType.SHORT, true),
    PN(20558, 8, 32, StringValueType.PN, false),
    SH(21320, 8, 32, StringValueType.STRING, false),
    SL(21324, 8, 0, BinaryValueType.INT, false),
    SQ(21329, 12, 0, SequenceValueType.SQ, false),
    SS(21331, 8, 0, BinaryValueType.SHORT, false),
    ST(21332, 8, 32, StringValueType.TEXT, false),
    TM(21581, 8, 32, StringValueType.TM, false),
    UC(21827, 12, 32, StringValueType.STRING, false),
    UI(21833, 8, 0, StringValueType.ASCII, false),
    UL(21836, 8, 0, BinaryValueType.INT, false),
    UN(21838, 12, 0, BinaryValueType.BYTE, true),
    UR(21842, 12, 32, StringValueType.UR, false),
    US(21843, 8, 0, BinaryValueType.USHORT, false),
    UT(21844, 12, 32, StringValueType.TEXT, false);

    private static Logger LOG;
    protected final int code;
    protected final int headerLength;
    protected final int paddingByte;
    protected final ValueType valueType;
    protected final boolean inlineBinary;
    private static final VR[] VALUE_OF;

    static {
        LOG = LoggerFactory.getLogger(VR.class);
        VALUE_OF = new VR[VR.indexOf(VR.UT.code) + 1];
        VR[] vRArray = VR.values();
        int n = vRArray.length;
        int n2 = 0;
        while (n2 < n) {
            VR vR;
            VR.VALUE_OF[VR.indexOf((int)vR.code)] = vR = vRArray[n2];
            ++n2;
        }
    }

    private VR(int n2, int n3, int n4, ValueType valueType, boolean bl) {
        this.code = n2;
        this.headerLength = n3;
        this.paddingByte = n4;
        this.valueType = valueType;
        this.inlineBinary = bl;
    }

    private static int indexOf(int n) {
        int n2 = n - 16705;
        return (n2 & 0xFFFFE0E0) == 0 ? ((n2 & 0xFF00) >> 3) + (n2 & 0xFF) : -1;
    }

    public int code() {
        return this.code;
    }

    public int headerLength() {
        return this.headerLength;
    }

    public int paddingByte() {
        return this.paddingByte;
    }

    public boolean isTemporalType() {
        return this.valueType.isTemporalType();
    }

    public boolean isStringType() {
        return this.valueType.isStringValue();
    }

    public boolean useSpecificCharacterSet() {
        return this.valueType.useSpecificCharacterSet();
    }

    public boolean isIntType() {
        return this.valueType.isIntValue();
    }

    public boolean isInlineBinary() {
        return this.inlineBinary;
    }

    public int numEndianBytes() {
        return this.valueType.numEndianBytes();
    }

    public byte[] toggleEndian(byte[] byArray, boolean bl) {
        return this.valueType.toggleEndian(byArray, bl);
    }

    public byte[] toBytes(Object object, SpecificCharacterSet specificCharacterSet) {
        return this.valueType.toBytes(object, specificCharacterSet);
    }

    public Object toStrings(Object object, boolean bl, SpecificCharacterSet specificCharacterSet) {
        return this.valueType.toStrings(object, bl, specificCharacterSet);
    }

    public String toString(Object object, boolean bl, int n, String string) {
        return this.valueType.toString(object, bl, n, string);
    }

    public int toInt(Object object, boolean bl, int n, int n2) {
        return this.valueType.toInt(object, bl, n, n2);
    }

    public int[] toInts(Object object, boolean bl) {
        return this.valueType.toInts(object, bl);
    }

    public float toFloat(Object object, boolean bl, int n, float f) {
        return this.valueType.toFloat(object, bl, n, f);
    }

    public float[] toFloats(Object object, boolean bl) {
        return this.valueType.toFloats(object, bl);
    }

    public double toDouble(Object object, boolean bl, int n, double d) {
        return this.valueType.toDouble(object, bl, n, d);
    }

    public double[] toDoubles(Object object, boolean bl) {
        return this.valueType.toDoubles(object, bl);
    }

    public Date toDate(Object object, TimeZone timeZone, int n, boolean bl, Date date, DatePrecision datePrecision) {
        return this.valueType.toDate(object, timeZone, n, bl, date, datePrecision);
    }

    public Date[] toDates(Object object, TimeZone timeZone, boolean bl, DatePrecisions datePrecisions) {
        return this.valueType.toDate(object, timeZone, bl, datePrecisions);
    }

    Object toValue(byte[] byArray) {
        return this.valueType.toValue(byArray);
    }

    Object toValue(String string, boolean bl) {
        return this.valueType.toValue(string, bl);
    }

    Object toValue(String[] stringArray, boolean bl) {
        return this.valueType.toValue(stringArray, bl);
    }

    Object toValue(int[] nArray, boolean bl) {
        return this.valueType.toValue(nArray, bl);
    }

    Object toValue(float[] fArray, boolean bl) {
        return this.valueType.toValue(fArray, bl);
    }

    Object toValue(double[] dArray, boolean bl) {
        return this.valueType.toValue(dArray, bl);
    }

    public Object toValue(Date[] dateArray, TimeZone timeZone, DatePrecision datePrecision) {
        return this.valueType.toValue(dateArray, timeZone, datePrecision);
    }

    public boolean prompt(Object object, boolean bl, SpecificCharacterSet specificCharacterSet, int n, StringBuilder stringBuilder) {
        return this.valueType.prompt(object, bl, specificCharacterSet, n, stringBuilder);
    }

    public int vmOf(Object object) {
        return this.headerLength == 12 ? 1 : this.valueType.vmOf(object);
    }

    public static VR valueOf(String string) {
        return Enum.valueOf(VR.class, string);
    }

    public static class Holder {
        public VR vr;
    }
}

