/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.IOD;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;

public class ValidationResult {
    private ArrayList<IOD.DataElement> missingAttributes;
    private ArrayList<IOD.DataElement> missingAttributeValues;
    private ArrayList<IOD.DataElement> notAllowedAttributes;
    private ArrayList<InvalidAttributeValue> invalidAttributeValues;

    public boolean hasMissingAttributes() {
        return this.missingAttributes != null;
    }

    public boolean hasMissingAttributeValues() {
        return this.missingAttributeValues != null;
    }

    public boolean hasInvalidAttributeValues() {
        return this.invalidAttributeValues != null;
    }

    public boolean hasNotAllowedAttributes() {
        return this.notAllowedAttributes != null;
    }

    public boolean isValid() {
        return !this.hasMissingAttributes() && !this.hasMissingAttributeValues() && !this.hasInvalidAttributeValues() && !this.hasNotAllowedAttributes();
    }

    public void addMissingAttribute(IOD.DataElement dataElement) {
        if (this.missingAttributes == null) {
            this.missingAttributes = new ArrayList();
        }
        this.missingAttributes.add(dataElement);
    }

    public void addMissingAttributeValue(IOD.DataElement dataElement) {
        if (this.missingAttributeValues == null) {
            this.missingAttributeValues = new ArrayList();
        }
        this.missingAttributeValues.add(dataElement);
    }

    public void addInvalidAttributeValue(IOD.DataElement dataElement, Invalid invalid) {
        this.addInvalidAttributeValue(dataElement, invalid, null, null);
    }

    public void addInvalidAttributeValue(IOD.DataElement dataElement, Invalid invalid, ValidationResult[] validationResultArray, IOD[] iODArray) {
        if (this.invalidAttributeValues == null) {
            this.invalidAttributeValues = new ArrayList();
        }
        this.invalidAttributeValues.add(new InvalidAttributeValue(dataElement, invalid, validationResultArray, iODArray));
    }

    public void addNotAllowedAttribute(IOD.DataElement dataElement) {
        if (this.notAllowedAttributes == null) {
            this.notAllowedAttributes = new ArrayList();
        }
        this.notAllowedAttributes.add(dataElement);
    }

    public int[] tagsOfNotAllowedAttributes() {
        return this.tagsOf(this.notAllowedAttributes);
    }

    public int[] tagsOfMissingAttributeValues() {
        return this.tagsOf(this.missingAttributeValues);
    }

    public int[] tagsOfMissingAttributes() {
        return this.tagsOf(this.missingAttributes);
    }

    public int[] tagsOfInvalidAttributeValues() {
        ArrayList<InvalidAttributeValue> arrayList = this.invalidAttributeValues;
        if (arrayList == null) {
            return ByteUtils.EMPTY_INTS;
        }
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = arrayList.get((int)n).dataElement.tag;
            ++n;
        }
        return nArray;
    }

    public int[] getOffendingElements() {
        return this.cat(this.tagsOfMissingAttributes(), this.tagsOfMissingAttributeValues(), this.tagsOfInvalidAttributeValues(), this.tagsOfNotAllowedAttributes());
    }

    private int[] cat(int[] ... nArray) {
        int[] nArray2;
        int n = 0;
        int[][] nArray3 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            nArray2 = nArray3[n3];
            n += nArray2.length;
            ++n3;
        }
        nArray2 = new int[n];
        n3 = 0;
        int[][] nArray4 = nArray;
        int n4 = nArray.length;
        int n5 = 0;
        while (n5 < n4) {
            int[] nArray5 = nArray4[n5];
            System.arraycopy(nArray5, 0, nArray2, n3, nArray5.length);
            n3 += nArray5.length;
            ++n5;
        }
        return nArray2;
    }

    private int[] tagsOf(List<IOD.DataElement> list) {
        if (list == null) {
            return ByteUtils.EMPTY_INTS;
        }
        int[] nArray = new int[list.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = list.get((int)n).tag;
            ++n;
        }
        return nArray;
    }

    public String getErrorComment() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.notAllowedAttributes != null) {
            return ValidationResult.errorComment(stringBuilder, "Not allowed Attribute", this.tagsOfNotAllowedAttributes()).toString();
        }
        if (this.missingAttributes != null) {
            return ValidationResult.errorComment(stringBuilder, "Missing Attribute", this.tagsOfMissingAttributes()).toString();
        }
        if (this.missingAttributeValues != null) {
            return ValidationResult.errorComment(stringBuilder, "Missing Value of Attribute", this.tagsOfMissingAttributeValues()).toString();
        }
        if (this.invalidAttributeValues != null) {
            return ValidationResult.errorComment(stringBuilder, "Invalid Attribute", this.tagsOfInvalidAttributeValues()).toString();
        }
        return null;
    }

    private static StringBuilder errorComment(StringBuilder stringBuilder, String string, int[] nArray) {
        stringBuilder.append(string);
        String string2 = nArray.length > 1 ? "s: " : ": ";
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            stringBuilder.append(string2).append(TagUtils.toString(n3));
            string2 = ", ";
            ++n2;
        }
        return stringBuilder;
    }

    public String toString() {
        if (this.isValid()) {
            return "VALID";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.notAllowedAttributes != null) {
            ValidationResult.errorComment(stringBuilder, "Not allowed Attribute", this.tagsOfNotAllowedAttributes()).append(StringUtils.LINE_SEPARATOR);
        }
        if (this.missingAttributes != null) {
            ValidationResult.errorComment(stringBuilder, "Missing Attribute", this.tagsOfMissingAttributes()).append(StringUtils.LINE_SEPARATOR);
        }
        if (this.missingAttributeValues != null) {
            ValidationResult.errorComment(stringBuilder, "Missing Value of Attribute", this.tagsOfMissingAttributeValues()).append(StringUtils.LINE_SEPARATOR);
        }
        if (this.invalidAttributeValues != null) {
            ValidationResult.errorComment(stringBuilder, "Invalid Attribute", this.tagsOfInvalidAttributeValues()).append(StringUtils.LINE_SEPARATOR);
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public String asText(Attributes attributes) {
        if (this.isValid()) {
            return "VALID";
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.appendTextTo(0, attributes, stringBuilder);
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private void appendTextTo(int n, Attributes attributes, StringBuilder stringBuilder) {
        if (this.notAllowedAttributes != null) {
            this.appendTextTo(n, attributes, "Not allowed Attributes:", this.notAllowedAttributes, stringBuilder);
        }
        if (this.missingAttributes != null) {
            this.appendTextTo(n, attributes, "Missing Attributes:", this.missingAttributes, stringBuilder);
        }
        if (this.missingAttributeValues != null) {
            this.appendTextTo(n, attributes, "Missing Attribute Values:", this.missingAttributeValues, stringBuilder);
        }
        if (this.invalidAttributeValues != null) {
            this.appendInvalidAttributeValues(n, attributes, "Invalid Attribute Values:", stringBuilder);
        }
    }

    private void appendTextTo(int n, Attributes attributes, String string, List<IOD.DataElement> list, StringBuilder stringBuilder) {
        this.appendPrefixTo(n, stringBuilder);
        stringBuilder.append(string).append(StringUtils.LINE_SEPARATOR);
        for (IOD.DataElement dataElement : list) {
            this.appendAttribute(n, dataElement.tag, stringBuilder);
            this.appendIODRef(dataElement.getLineNumber(), stringBuilder);
            stringBuilder.append(StringUtils.LINE_SEPARATOR);
        }
    }

    private void appendIODRef(int n, StringBuilder stringBuilder) {
        if (n > 0) {
            stringBuilder.append(" // IOD line #").append(n);
        }
    }

    private void appendInvalidAttributeValues(int n, Attributes attributes, String string, StringBuilder stringBuilder) {
        this.appendPrefixTo(n, stringBuilder);
        stringBuilder.append(string);
        stringBuilder.append(StringUtils.LINE_SEPARATOR);
        for (InvalidAttributeValue invalidAttributeValue : this.invalidAttributeValues) {
            ArrayList arrayList;
            int n2;
            int n3 = invalidAttributeValue.dataElement.tag;
            this.appendAttribute(n, n3, stringBuilder);
            VR.Holder holder = new VR.Holder();
            Object object = attributes.getValue(n3, holder);
            stringBuilder.append(' ').append((Object)holder.vr);
            stringBuilder.append(" [");
            holder.vr.prompt(object, attributes.bigEndian(), attributes.getSpecificCharacterSet(holder.vr), 200, stringBuilder);
            stringBuilder.append(']');
            if (invalidAttributeValue.reason != Invalid.Item) {
                stringBuilder.append(" Invalid ").append((Object)invalidAttributeValue.reason);
                this.appendIODRef(invalidAttributeValue.dataElement.getLineNumber(), stringBuilder);
            }
            stringBuilder.append(StringUtils.LINE_SEPARATOR);
            if (invalidAttributeValue.missingItems != null) {
                IOD[] iODArray = invalidAttributeValue.missingItems;
                int n4 = invalidAttributeValue.missingItems.length;
                n2 = 0;
                while (n2 < n4) {
                    arrayList = iODArray[n2];
                    this.appendPrefixTo(n + 1, stringBuilder);
                    stringBuilder.append("Missing Item");
                    this.appendIODRef(((IOD)arrayList).getLineNumber(), stringBuilder);
                    stringBuilder.append(StringUtils.LINE_SEPARATOR);
                    ++n2;
                }
            }
            if (invalidAttributeValue.itemValidationResults == null) continue;
            arrayList = (Sequence)object;
            n2 = 0;
            while (n2 < invalidAttributeValue.itemValidationResults.length) {
                ValidationResult validationResult = invalidAttributeValue.itemValidationResults[n2];
                if (!validationResult.isValid()) {
                    this.appendPrefixTo(n + 1, stringBuilder);
                    stringBuilder.append("Invalid Item ").append(n2 + 1).append(':').append(StringUtils.LINE_SEPARATOR);
                    validationResult.appendTextTo(n + 1, (Attributes)arrayList.get(n2), stringBuilder);
                }
                ++n2;
            }
        }
    }

    private void appendAttribute(int n, int n2, StringBuilder stringBuilder) {
        this.appendPrefixTo(n, stringBuilder);
        stringBuilder.append(TagUtils.toString(n2)).append(' ').append(ElementDictionary.keywordOf(n2, null));
    }

    private void appendPrefixTo(int n, StringBuilder stringBuilder) {
        while (n-- > 0) {
            stringBuilder.append('>');
        }
    }

    public static enum Invalid {
        VR,
        VM,
        Value,
        Item,
        MultipleItems,
        Code;

    }

    public class InvalidAttributeValue {
        public final IOD.DataElement dataElement;
        public final Invalid reason;
        public final ValidationResult[] itemValidationResults;
        public final IOD[] missingItems;

        public InvalidAttributeValue(IOD.DataElement dataElement, Invalid invalid, ValidationResult[] validationResultArray, IOD[] iODArray) {
            this.dataElement = dataElement;
            this.reason = invalid;
            this.itemValidationResults = validationResultArray;
            this.missingItems = iODArray;
        }
    }
}

