/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.hl7;

public abstract class HL7Charset {
    public static String toCharsetName(String string) {
        if (string != null && !string.isEmpty()) {
            switch (string.charAt(string.length() - 1)) {
                case '0': {
                    if (!string.equals("GB 18030-2000")) break;
                    return "GB18030";
                }
                case '1': {
                    if (string.equals("8859/1")) {
                        return "ISO-8859-1";
                    }
                    if (!string.equals("KS X 1001")) break;
                    return "EUC-KR";
                }
                case '2': {
                    if (!string.equals("8859/2")) break;
                    return "ISO-8859-2";
                }
                case '3': {
                    if (!string.equals("8859/3")) break;
                    return "ISO-8859-3";
                }
                case '4': {
                    if (string.equals("8859/4")) {
                        return "ISO-8859-4";
                    }
                    if (!string.equals("ISO IR14")) break;
                    return "JIS_X0201";
                }
                case '5': {
                    if (!string.equals("8859/5")) break;
                    return "ISO-8859-5";
                }
                case '6': {
                    if (!string.equals("8859/6")) break;
                    return "ISO-8859-6";
                }
                case '7': {
                    if (string.equals("8859/7")) {
                        return "ISO-8859-7";
                    }
                    if (!string.equals("ISO IR87")) break;
                    return "x-JIS0208";
                }
                case '8': {
                    if (string.equals("8859/8")) {
                        return "ISO-8859-8";
                    }
                    if (!string.equals("UNICODE UTF-8")) break;
                    return "UTF-8";
                }
                case '9': {
                    if (string.equals("8859/9")) {
                        return "ISO-8859-9";
                    }
                    if (!string.equals("ISO IR159")) break;
                    return "JIS_X0212-1990";
                }
                case 'E': {
                    if (!string.equals("UNICODE")) break;
                    return "UTF-8";
                }
            }
        }
        return "US-ASCII";
    }

    public static String toDicomCharacterSetCode(String string) {
        if (string != null && !string.isEmpty()) {
            switch (string.charAt(string.length() - 1)) {
                case '0': {
                    if (!string.equals("GB 18030-2000")) break;
                    return "GB18030";
                }
                case '1': {
                    if (string.equals("8859/1")) {
                        return "ISO_IR 100";
                    }
                    if (!string.equals("KS X 1001")) break;
                    return "EUC-KR";
                }
                case '2': {
                    if (!string.equals("8859/2")) break;
                    return "ISO_IR 101";
                }
                case '3': {
                    if (!string.equals("8859/3")) break;
                    return "ISO_IR 109";
                }
                case '4': {
                    if (string.equals("8859/4")) {
                        return "ISO_IR 110";
                    }
                    if (!string.equals("ISO IR14")) break;
                    return "JIS_X0201";
                }
                case '5': {
                    if (!string.equals("8859/5")) break;
                    return "ISO_IR 144";
                }
                case '6': {
                    if (!string.equals("8859/6")) break;
                    return "ISO_IR 127";
                }
                case '7': {
                    if (string.equals("8859/7")) {
                        return "ISO_IR 126";
                    }
                    if (!string.equals("ISO IR87")) break;
                    return "ISO 2022 IR 87";
                }
                case '8': {
                    if (string.equals("8859/8")) {
                        return "ISO_IR 138";
                    }
                    if (!string.equals("UNICODE UTF-8")) break;
                    return "ISO_IR 192";
                }
                case '9': {
                    if (string.equals("8859/9")) {
                        return "ISO_IR 148";
                    }
                    if (!string.equals("ISO IR159")) break;
                    return "ISO 2022 IR 159";
                }
                case 'E': {
                    if (!string.equals("UNICODE")) break;
                    return "ISO_IR 192";
                }
            }
        }
        return null;
    }
}

