/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.hl7;

import java.io.IOException;
import java.io.Writer;
import org.dcm4che3.hl7.Delimiter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HL7ContentHandler
extends DefaultHandler {
    private final Writer writer;
    private char[] delimiters = "|^~\\&".toCharArray();
    private final char[] escape;
    private boolean ignoreCharacters;

    public HL7ContentHandler(Writer writer) {
        char[] cArray = new char[3];
        cArray[0] = 92;
        cArray[2] = 92;
        this.escape = cArray;
        this.ignoreCharacters = true;
        this.writer = writer;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            switch (string3.charAt(0)) {
                case 'f': {
                    if (!string3.equals("field")) break;
                    this.writer.write(this.delimiters[0]);
                    this.ignoreCharacters = false;
                    return;
                }
                case 'c': {
                    if (!string3.equals("component")) break;
                    this.writer.write(this.delimiters[1]);
                    this.ignoreCharacters = false;
                    return;
                }
                case 'r': {
                    if (!string3.equals("repeat")) break;
                    this.writer.write(this.delimiters[2]);
                    this.ignoreCharacters = false;
                    return;
                }
                case 'e': {
                    if (!string3.equals("escape")) break;
                    this.writer.write(this.delimiters[3]);
                    this.ignoreCharacters = false;
                    return;
                }
                case 's': {
                    if (!string3.equals("subcomponent")) break;
                    this.writer.write(this.delimiters[4]);
                    this.ignoreCharacters = false;
                    return;
                }
                case 'M': {
                    if (!string3.equals("MSH")) break;
                    this.startHeaderSegment(string3, attributes);
                    return;
                }
                case 'B': {
                    if (!string3.equals("BHS")) break;
                    this.startHeaderSegment(string3, attributes);
                    return;
                }
                case 'F': {
                    if (!string3.equals("FHS")) break;
                    this.startHeaderSegment(string3, attributes);
                    return;
                }
                case 'h': {
                    if (!string3.equals("hl7")) break;
                    return;
                }
            }
            this.writer.write(string3);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startHeaderSegment(String string, Attributes attributes) throws IOException {
        Delimiter[] delimiterArray = Delimiter.values();
        int n = 0;
        while (n < delimiterArray.length) {
            String string2 = attributes.getValue(delimiterArray[n].attribute());
            if (string2 != null) {
                this.delimiters[n] = string2.charAt(0);
            }
            ++n;
        }
        this.escape[0] = this.escape[2] = this.delimiters[3];
        this.writer.write(string);
        this.writer.write(this.delimiters);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.ignoreCharacters = true;
        try {
            switch (string3.charAt(0)) {
                case 'f': {
                    if (!string3.equals("field")) break;
                    return;
                }
                case 'c': {
                    if (!string3.equals("component")) break;
                    return;
                }
                case 'r': {
                    if (!string3.equals("repeat")) break;
                    return;
                }
                case 'e': {
                    if (!string3.equals("escape")) break;
                    this.writer.write(this.delimiters[3]);
                    this.ignoreCharacters = false;
                    return;
                }
                case 's': {
                    if (!string3.equals("subcomponent")) break;
                    return;
                }
                case 'h': {
                    if (!string3.equals("hl7")) break;
                    this.writer.flush();
                    return;
                }
            }
            this.writer.write(13);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.ignoreCharacters) {
            return;
        }
        try {
            int n3 = n;
            int n4 = n + n2;
            char[] cArray2 = this.delimiters;
            int n5 = n;
            while (n5 < n4) {
                char c = cArray[n5];
                int n6 = 0;
                while (n6 < cArray2.length) {
                    if (c == cArray2[n6]) {
                        this.writer.write(cArray, n3, n5 - n3);
                        n3 = n5 + 1;
                        this.escape(n6);
                        break;
                    }
                    ++n6;
                }
                ++n5;
            }
            this.writer.write(cArray, n3, n4 - n3);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void escape(int n) throws IOException {
        this.escape[1] = "FSRET".charAt(n);
        this.writer.write(this.escape);
    }
}

