/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.hl7;

import java.io.UnsupportedEncodingException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Iterator;
import org.dcm4che3.hl7.HL7Charset;
import org.dcm4che3.hl7.HL7Segment;

public class HL7Message
extends ArrayList<HL7Segment> {
    private static final long serialVersionUID = 5000743858306540891L;

    public HL7Message() {
    }

    public HL7Message(int n) {
        super(n);
    }

    public HL7Segment getSegment(String string) {
        for (HL7Segment hL7Segment : this) {
            if (!string.equals(hL7Segment.getField(0, null))) continue;
            return hL7Segment;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.toString('\r');
    }

    public String toString(char c) {
        Object object;
        int n = this.size();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            object = (HL7Segment)iterator.next();
            int n2 = ((HL7Segment)object).size();
            n += n2 - 1;
            int n3 = 0;
            while (n3 < n2) {
                String string = ((HL7Segment)object).getField(n3, null);
                if (string != null) {
                    n += string.length();
                }
                ++n3;
            }
        }
        object = new char[n];
        int n4 = 0;
        for (HL7Segment hL7Segment : this) {
            char c2 = hL7Segment.getFieldSeparator();
            int n5 = hL7Segment.size();
            int n6 = 0;
            while (n6 < n5) {
                String string = hL7Segment.getField(n6, null);
                if (string != null) {
                    int n7 = string.length();
                    string.getChars(0, n7, (char[])object, n4);
                    n4 += n7;
                }
                object[n4++] = c2;
                ++n6;
            }
            object[n4 - 1] = c;
        }
        return new String((char[])object);
    }

    public byte[] getBytes(String string) {
        try {
            return this.toString().getBytes(HL7Charset.toCharsetName(((HL7Segment)this.get(0)).getField(17, string)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static HL7Message parse(byte[] byArray, String string) {
        return HL7Message.parse(byArray, byArray.length, string);
    }

    public static HL7Message parse(byte[] byArray, int n, String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        HL7Message hL7Message = new HL7Message();
        HL7Segment hL7Segment = HL7Segment.parseMSH(byArray, n, parsePosition);
        char c = hL7Segment.getFieldSeparator();
        String string2 = hL7Segment.getEncodingCharacters();
        String string3 = HL7Charset.toCharsetName(hL7Segment.getField(17, string));
        hL7Message.add(hL7Segment);
        while ((hL7Segment = HL7Segment.parse(byArray, n, parsePosition, c, string2, string3)) != null) {
            hL7Message.add(hL7Segment);
        }
        hL7Message.trimToSize();
        return hL7Message;
    }

    public static HL7Message makeACK(HL7Segment hL7Segment, String string, String string2) {
        int n = hL7Segment.size();
        HL7Segment hL7Segment2 = HL7Segment.makeMSH(n, hL7Segment.getFieldSeparator(), hL7Segment.getEncodingCharacters());
        hL7Segment2.setField(2, hL7Segment.getField(4, null));
        hL7Segment2.setField(3, hL7Segment.getField(5, null));
        hL7Segment2.setField(4, hL7Segment.getField(2, null));
        hL7Segment2.setField(5, hL7Segment.getField(3, null));
        hL7Segment2.setField(8, "ACK");
        int n2 = 10;
        while (n2 < n) {
            hL7Segment2.setField(n2, hL7Segment.getField(n2, null));
            ++n2;
        }
        HL7Segment hL7Segment3 = new HL7Segment(4, hL7Segment.getFieldSeparator(), hL7Segment.getEncodingCharacters());
        hL7Segment3.setField(0, "MSA");
        hL7Segment3.setField(1, string);
        hL7Segment3.setField(2, hL7Segment.getField(9, null));
        hL7Segment3.setField(3, string2 != null && string2.length() > 80 ? string2.substring(0, 80) : string2);
        HL7Message hL7Message = new HL7Message(2);
        hL7Message.add(hL7Segment2);
        hL7Message.add(hL7Segment3);
        return hL7Message;
    }

    public static HL7Message makePixQuery(String string, String ... stringArray) {
        HL7Segment hL7Segment = HL7Segment.makeMSH();
        hL7Segment.setField(8, "QBP^Q23^QBP_Q21");
        HL7Segment hL7Segment2 = new HL7Segment(5);
        hL7Segment2.setField(0, "QPD");
        hL7Segment2.setField(1, "IHE PIX Query");
        hL7Segment2.setField(2, "QRY" + hL7Segment.getField(9, ""));
        hL7Segment2.setField(3, string);
        hL7Segment2.setField(4, HL7Segment.concat(stringArray, '~'));
        HL7Segment hL7Segment3 = new HL7Segment(8);
        hL7Segment3.setField(0, "RCP");
        hL7Segment3.setField(1, "I");
        HL7Message hL7Message = new HL7Message(3);
        hL7Message.add(hL7Segment);
        hL7Message.add(hL7Segment2);
        hL7Message.add(hL7Segment3);
        return hL7Message;
    }
}

