/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.hl7;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.EnumSet;
import java.util.StringTokenizer;
import org.dcm4che3.hl7.Delimiter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class HL7Parser {
    private static final String NAMESPACE = "http://aurora.regenstrief.org/xhl7";
    private String namespace = "";
    private final ContentHandler ch;
    private final AttributesImpl atts = new AttributesImpl();
    private final EnumSet<Delimiter> open = EnumSet.noneOf(Delimiter.class);
    private String delimiters;

    public HL7Parser(ContentHandler contentHandler) {
        this.ch = contentHandler;
    }

    public final boolean isIncludeNamespaceDeclaration() {
        return this.namespace == NAMESPACE;
    }

    public final void setIncludeNamespaceDeclaration(boolean bl) {
        this.namespace = bl ? NAMESPACE : "";
    }

    public void parse(Reader reader) throws IOException, SAXException {
        this.parse(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader));
    }

    public void parse(BufferedReader bufferedReader) throws IOException, SAXException {
        String string;
        this.startDocument();
        this.delimiters = "|^~\\&";
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray;
            if ((string = string.trim()).length() == 0) continue;
            if (string.length() < 3) {
                throw new IOException("Segment to short: " + string);
            }
            String string2 = string.substring(0, 3);
            int n = 0;
            if (this.isHeaderSegment(string)) {
                if (string.length() < 8) {
                    throw new IOException("Header Segment to short: " + string);
                }
                string2 = string.substring(0, 3);
                this.setDelimiters(string.substring(3, 8));
                stringArray = this.tokenize(string.substring(8));
            } else {
                stringArray = this.tokenize(string);
                string2 = stringArray[n++];
            }
            this.startElement(string2);
            while (n < stringArray.length) {
                String string3;
                Delimiter delimiter;
                if ((delimiter = this.delimiter(string3 = stringArray[n++])) != null) {
                    if (delimiter != Delimiter.escape) {
                        this.endElement(delimiter);
                        this.startElement(delimiter);
                        continue;
                    }
                    if (stringArray.length > n + 1 && stringArray[n + 1].equals(string3)) {
                        int n2;
                        if ((n2 = this.escapeIndex(string3 = stringArray[n++])) >= 0) {
                            this.ch.characters(this.delimiters.toCharArray(), n2, 1);
                        } else {
                            this.startElement(Delimiter.escape.name());
                            this.ch.characters(string3.toCharArray(), 0, string3.length());
                            this.endElement(Delimiter.escape.name());
                        }
                        ++n;
                        continue;
                    }
                }
                this.ch.characters(string3.toCharArray(), 0, string3.length());
            }
            this.endElement(Delimiter.field);
            this.endElement(string2);
        }
        this.endDocument();
    }

    private boolean isHeaderSegment(String string) {
        return string.startsWith("MSH") || string.startsWith("BHS") || string.startsWith("FHS");
    }

    private void startDocument() throws SAXException {
        this.ch.startDocument();
        this.addAttribute("xml-space", "preserved");
        this.startElement("hl7");
    }

    private void endDocument() throws SAXException {
        this.endElement("hl7");
        this.ch.endDocument();
    }

    private void setDelimiters(String string) {
        Delimiter[] delimiterArray = Delimiter.values();
        int n = 0;
        while (n < delimiterArray.length) {
            this.addAttribute(delimiterArray[n].attribute(), string.substring(n, n + 1));
            ++n;
        }
        this.delimiters = string;
    }

    private void addAttribute(String string, String string2) {
        this.atts.addAttribute(this.namespace, string, string, "NMTOKEN", string2);
    }

    private Delimiter delimiter(String string) {
        if (string.length() != 1) {
            return null;
        }
        int n = this.delimiters.indexOf(string.charAt(0));
        return n >= 0 ? Delimiter.values()[n] : null;
    }

    private int escapeIndex(String string) {
        return string.length() != 1 ? "FSRET".indexOf(string.charAt(0)) : -1;
    }

    private String[] tokenize(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.delimiters, true);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    private void startElement(Delimiter delimiter) throws SAXException {
        this.startElement(delimiter.name());
        this.open.add(delimiter);
    }

    private void startElement(String string) throws SAXException {
        this.ch.startElement(this.namespace, string, string, this.atts);
        this.atts.clear();
    }

    private void endElement(Delimiter delimiter) throws SAXException {
        Delimiter delimiter2 = Delimiter.escape;
        do {
            if (!this.open.remove((Object)(delimiter2 = delimiter2.parent()))) continue;
            this.endElement(delimiter2.name());
        } while (delimiter2 != delimiter);
    }

    private void endElement(String string) throws SAXException {
        this.ch.endElement(this.namespace, string, string);
    }
}

