/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.hl7;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class HL7Segment
implements Serializable {
    private static final long serialVersionUID = 2268883954083242976L;
    private static final AtomicInteger nextMessageControlID = new AtomicInteger(new Random().nextInt());
    private final char fieldSeparator;
    private final String encodingCharacters;
    private String[] fields;

    public HL7Segment(int n, char c, String string) {
        if (n <= 0) {
            throw new IllegalArgumentException("size: " + n);
        }
        this.fieldSeparator = c;
        this.encodingCharacters = string;
        this.fields = new String[n];
    }

    public HL7Segment(int n) {
        this(n, '|', "^~\\&");
    }

    public HL7Segment(String string, char c, String string2) {
        this.fieldSeparator = c;
        this.encodingCharacters = string2;
        this.fields = HL7Segment.split(string, c);
    }

    public final char getFieldSeparator() {
        return this.fieldSeparator;
    }

    public final char getComponentSeparator() {
        return this.encodingCharacters.charAt(0);
    }

    public final char getRepetitionSeparator() {
        return this.encodingCharacters.charAt(1);
    }

    public final char getEscapeCharacter() {
        return this.encodingCharacters.charAt(2);
    }

    public final char getSubcomponentSeparator() {
        return this.encodingCharacters.charAt(3);
    }

    public final String getEncodingCharacters() {
        return this.encodingCharacters;
    }

    public void setField(int n, String string) {
        if (n >= this.fields.length) {
            this.fields = Arrays.copyOf(this.fields, n + 1);
        }
        this.fields[n] = string;
    }

    public String getField(int n, String string) {
        String string2 = n < this.fields.length ? this.fields[n] : null;
        return string2 != null && !string2.isEmpty() ? string2 : string;
    }

    public int size() {
        return this.fields.length;
    }

    public String getSendingApplicationWithFacility() {
        return String.valueOf(this.getField(2, "")) + '^' + this.getField(3, "");
    }

    public void setSendingApplicationWithFacility(String string) {
        String[] stringArray = HL7Segment.split(string, '^');
        this.setField(2, stringArray[0]);
        if (stringArray.length > 1) {
            this.setField(3, stringArray[1]);
        }
    }

    public String getReceivingApplicationWithFacility() {
        return String.valueOf(this.getField(4, "")) + '^' + this.getField(5, "");
    }

    public void setReceivingApplicationWithFacility(String string) {
        String[] stringArray = HL7Segment.split(string, '^');
        this.setField(4, stringArray[0]);
        if (stringArray.length > 1) {
            this.setField(5, stringArray[1]);
        }
    }

    public String getMessageType() {
        String string = this.getField(8, "").replace(this.getComponentSeparator(), '^');
        int n = string.indexOf(94, string.indexOf(94) + 1);
        return n > 0 ? string.substring(0, n) : string;
    }

    public String toString() {
        return HL7Segment.concat(this.fields, this.fieldSeparator);
    }

    public static String concat(String[] stringArray, char c) {
        Object object;
        int n = stringArray.length;
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            String string = stringArray[0];
            return string != null ? string : "";
        }
        int n2 = n - 1;
        Object object2 = stringArray;
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object = object2[n4];
            if (object != null) {
                n2 += ((String)object).length();
            }
            ++n4;
        }
        object = new char[n2];
        n4 = 0;
        n3 = 0;
        while (n4 < n) {
            if (n4 != 0) {
                object[n3++] = c;
            }
            if ((object2 = stringArray[n4]) != null) {
                int n5 = ((String)object2).length();
                ((String)object2).getChars(0, n5, (char[])object, n3);
                n3 += n5;
            }
            ++n4;
        }
        return new String((char[])object);
    }

    public static String[] split(String string, char c) {
        int n = 1;
        int n2 = -1;
        while ((n2 = string.indexOf(c, n2 + 1)) >= 0) {
            ++n;
        }
        if (n == 1) {
            return new String[]{string};
        }
        String[] stringArray = new String[n];
        int n3 = string.length();
        while (--n >= 0) {
            n2 = string.lastIndexOf(c, n3 - 1);
            stringArray[n] = string.substring(n2 + 1, n3);
            n3 = n2;
        }
        return stringArray;
    }

    public static HL7Segment parseMSH(byte[] byArray, int n) {
        return HL7Segment.parseMSH(byArray, n, new ParsePosition(0));
    }

    public static HL7Segment parseMSH(byte[] byArray, int n, ParsePosition parsePosition) {
        String string = HL7Segment.parse(byArray, n, parsePosition, null);
        if (string.length() < 8) {
            throw new IllegalArgumentException("Invalid MSH Segment: " + string);
        }
        return new HL7Segment(string, string.charAt(3), string.substring(4, 8));
    }

    static HL7Segment parse(byte[] byArray, int n, ParsePosition parsePosition, char c, String string, String string2) {
        String string3 = HL7Segment.parse(byArray, n, parsePosition, string2);
        return string3 != null ? new HL7Segment(string3, c, string) : null;
    }

    private static String parse(byte[] byArray, int n, ParsePosition parsePosition, String string) {
        int n2;
        int n3 = n2 = parsePosition.getIndex();
        while (n3 < n && byArray[n3] != 13 && byArray[n3] != 10) {
            ++n3;
        }
        int n4 = n3 - n2;
        if (n4 == 0) {
            return null;
        }
        if (++n3 < n && (byArray[n3] == 13 || byArray[n3] == 10)) {
            ++n3;
        }
        parsePosition.setIndex(n3);
        try {
            return string != null ? new String(byArray, n2, n4, string) : new String(byArray, n2, n4);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("charsetName: " + string);
        }
    }

    public static String nextMessageControlID() {
        return Integer.toString(nextMessageControlID.getAndIncrement() & Integer.MAX_VALUE);
    }

    public static String timeStamp(Date date) {
        return new SimpleDateFormat("yyyyMMddHHmmss.SSS").format(date);
    }

    public static HL7Segment makeMSH() {
        return HL7Segment.makeMSH(21, '|', "^~\\&");
    }

    public static HL7Segment makeMSH(int n, char c, String string) {
        HL7Segment hL7Segment = new HL7Segment(n, c, string);
        hL7Segment.setField(0, "MSH");
        hL7Segment.setField(1, string);
        hL7Segment.setField(6, HL7Segment.timeStamp(new Date()));
        hL7Segment.setField(9, HL7Segment.nextMessageControlID());
        hL7Segment.setField(10, "P");
        hL7Segment.setField(11, "2.5");
        return hL7Segment;
    }
}

