/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.hl7;

import java.io.IOException;
import java.net.Socket;
import org.dcm4che3.hl7.MLLPInputStream;
import org.dcm4che3.hl7.MLLPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLLPConnection {
    private static Logger LOG = LoggerFactory.getLogger(MLLPConnection.class);
    private final Socket sock;
    private final MLLPInputStream mllpIn;
    private final MLLPOutputStream mllpOut;

    public MLLPConnection(Socket socket) throws IOException {
        this.sock = socket;
        this.mllpIn = new MLLPInputStream(socket.getInputStream());
        this.mllpOut = new MLLPOutputStream(socket.getOutputStream());
    }

    public final Socket getSocket() {
        return this.sock;
    }

    public void writeMessage(byte[] byArray) throws IOException {
        this.writeMessage(byArray, 0, byArray.length);
    }

    public void writeMessage(byte[] byArray, int n, int n2) throws IOException {
        this.log("{} << {}", byArray, n, n2);
        this.mllpOut.writeMessage(byArray, n, n2);
    }

    public byte[] readMessage() throws IOException {
        byte[] byArray = this.mllpIn.readMessage();
        if (byArray != null) {
            this.log("{} >> {}", byArray, 0, byArray.length);
        }
        return byArray;
    }

    private void log(String string, byte[] byArray, int n, int n2) {
        if (!LOG.isInfoEnabled()) {
            return;
        }
        int n3 = 0;
        while (n3 < n2 && byArray[n + n3] != 13) {
            ++n3;
        }
        LOG.info(string, (Object)this.sock, (Object)new String(byArray, n, n3));
        if (LOG.isDebugEnabled()) {
            LOG.debug(string, (Object)this.sock, (Object)new String(byArray, n, n2).replace('\r', '\n'));
        }
    }
}

