/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.hl7;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MLLPInputStream
extends BufferedInputStream {
    private static final int SOM = 11;
    private static final int EOM1 = 28;
    private static final int EOM2 = 13;
    private boolean eom = true;
    private ByteArrayOutputStream readBuffer = new ByteArrayOutputStream();

    public MLLPInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public MLLPInputStream(InputStream inputStream, int n) {
        super(inputStream, n);
    }

    public synchronized boolean hasMoreInput() throws IOException {
        if (!this.eom) {
            throw new IllegalStateException();
        }
        int n = super.read();
        if (n == -1) {
            return false;
        }
        if (n != 11) {
            throw new IOException("Missing Start Block character");
        }
        this.eom = false;
        return true;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.eom) {
            return -1;
        }
        int n = super.read();
        if (n == -1) {
            throw new EOFException();
        }
        if (n != 28) {
            return n;
        }
        this.eom();
        return -1;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (this.eom) {
            return -1;
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.read() == -1) {
            return -1;
        }
        int n3 = Math.min(this.count - this.pos, n2 - 1);
        int n4 = this.remaining(this.pos + n3);
        if (n4 == -1) {
            System.arraycopy(this.buf, this.pos - 1, byArray, n, n3 + 1);
            this.pos += n3;
            return n3 + 1;
        }
        System.arraycopy(this.buf, this.pos - 1, byArray, n, n4 + 1);
        this.pos += n4 + 1;
        this.eom();
        return n4 + 1;
    }

    public synchronized int copyTo(OutputStream outputStream) throws IOException {
        int n;
        if (this.eom) {
            throw new IllegalStateException();
        }
        int n2 = 0;
        int n3 = 0;
        while ((n = this.remaining(this.count)) == -1) {
            int n4 = this.count - this.pos;
            outputStream.write(this.buf, this.pos - n3, n4 + n3);
            n2 += n4 + n3;
            this.pos = this.count;
            if (this.read() == -1) {
                return n2;
            }
            n3 = 1;
        }
        outputStream.write(this.buf, this.pos - n3, n + n3);
        this.pos += n + 1;
        this.eom();
        return n2 += n + n3;
    }

    public synchronized byte[] readMessage() throws IOException {
        if (!this.hasMoreInput()) {
            return null;
        }
        this.readBuffer.reset();
        this.copyTo(this.readBuffer);
        return this.readBuffer.toByteArray();
    }

    private void eom() throws IOException {
        int n = super.read();
        if (n != 13) {
            throw new IOException("1CH followed by " + Integer.toHexString(n & 0xFF) + "H instead by 0DH");
        }
        this.eom = true;
    }

    private int remaining(int n) {
        int n2 = this.pos;
        while (n2 < n) {
            if (this.buf[n2] == 28) {
                return n2 - this.pos;
            }
            ++n2;
        }
        return -1;
    }
}

