/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.hl7;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MLLPOutputStream
extends FilterOutputStream {
    private static final int SOM = 11;
    private static final byte[] EOM = new byte[]{28, 13};
    private boolean somWritten;

    public MLLPOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public synchronized void write(int n) throws IOException {
        this.writeStartBlock();
        this.out.write(n);
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeStartBlock();
        this.out.write(byArray, n, n2);
    }

    public void writeMessage(byte[] byArray) throws IOException {
        this.writeMessage(byArray, 0, byArray.length);
    }

    public synchronized void writeMessage(byte[] byArray, int n, int n2) throws IOException {
        if (this.somWritten) {
            throw new IllegalStateException();
        }
        this.out.write(11);
        this.out.write(byArray, n, n2);
        this.out.write(EOM);
        this.out.flush();
    }

    private void writeStartBlock() throws IOException {
        if (!this.somWritten) {
            this.out.write(11);
            this.somWritten = true;
        }
    }

    public synchronized void finish() throws IOException {
        if (!this.somWritten) {
            throw new IllegalStateException();
        }
        this.out.write(EOM);
        this.out.flush();
        this.somWritten = false;
    }
}

