/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.image;

import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.image.ColorModelFactory;
import org.dcm4che3.image.ColorSubsampling;
import org.dcm4che3.image.SampledComponentSampleModel;
import org.dcm4che3.image.YBR;

public enum PhotometricInterpretation {
    MONOCHROME1{

        @Override
        public boolean isMonochrome() {
            return true;
        }

        @Override
        public boolean isInvers() {
            return true;
        }

        @Override
        public ColorModel createColorModel(int n, int n2, Attributes attributes) {
            return ColorModelFactory.createMonochromeColorModel(n, n2);
        }
    }
    ,
    MONOCHROME2{

        @Override
        public boolean isMonochrome() {
            return true;
        }

        @Override
        public ColorModel createColorModel(int n, int n2, Attributes attributes) {
            return ColorModelFactory.createMonochromeColorModel(n, n2);
        }
    }
    ,
    PALETTE_COLOR{

        public String toString() {
            return "PALETTE COLOR";
        }

        @Override
        public ColorModel createColorModel(int n, int n2, Attributes attributes) {
            return ColorModelFactory.createPaletteColorModel(n, n2, attributes);
        }
    }
    ,
    RGB{

        @Override
        public ColorModel createColorModel(int n, int n2, Attributes attributes) {
            return ColorModelFactory.createRGBColorModel(n, n2, attributes);
        }
    }
    ,
    YBR_FULL{

        @Override
        public ColorModel createColorModel(int n, int n2, Attributes attributes) {
            return ColorModelFactory.createYBRFullColorModel(n, n2, attributes);
        }
    }
    ,
    YBR_FULL_422{

        @Override
        public int frameLength(int n, int n2, int n3, int n4) {
            return ColorSubsampling.YBR_XXX_422.frameLength(n, n2);
        }

        @Override
        public ColorModel createColorModel(int n, int n2, Attributes attributes) {
            return ColorModelFactory.createYBRColorModel(n, n2, attributes, YBR.FULL, ColorSubsampling.YBR_XXX_422);
        }

        @Override
        public SampleModel createSampleModel(int n, int n2, int n3, int n4, boolean bl) {
            return new SampledComponentSampleModel(n2, n3, ColorSubsampling.YBR_XXX_422);
        }

        @Override
        public PhotometricInterpretation decompress() {
            return RGB;
        }

        @Override
        public boolean isSubSambled() {
            return true;
        }
    }
    ,
    YBR_PARTIAL_422{

        @Override
        public int frameLength(int n, int n2, int n3, int n4) {
            return ColorSubsampling.YBR_XXX_422.frameLength(n, n2);
        }

        @Override
        public ColorModel createColorModel(int n, int n2, Attributes attributes) {
            return ColorModelFactory.createYBRColorModel(n, n2, attributes, YBR.PARTIAL, ColorSubsampling.YBR_XXX_422);
        }

        @Override
        public SampleModel createSampleModel(int n, int n2, int n3, int n4, boolean bl) {
            return new SampledComponentSampleModel(n2, n3, ColorSubsampling.YBR_XXX_422);
        }

        @Override
        public PhotometricInterpretation decompress() {
            return RGB;
        }

        @Override
        public boolean isSubSambled() {
            return true;
        }
    }
    ,
    YBR_PARTIAL_420{

        @Override
        public int frameLength(int n, int n2, int n3, int n4) {
            return ColorSubsampling.YBR_XXX_420.frameLength(n, n2);
        }

        @Override
        public ColorModel createColorModel(int n, int n2, Attributes attributes) {
            return ColorModelFactory.createYBRColorModel(n, n2, attributes, YBR.PARTIAL, ColorSubsampling.YBR_XXX_420);
        }

        @Override
        public SampleModel createSampleModel(int n, int n2, int n3, int n4, boolean bl) {
            return new SampledComponentSampleModel(n2, n3, ColorSubsampling.YBR_XXX_420);
        }

        @Override
        public PhotometricInterpretation decompress() {
            return RGB;
        }

        @Override
        public boolean isSubSambled() {
            return true;
        }
    }
    ,
    YBR_ICT{

        @Override
        public ColorModel createColorModel(int n, int n2, Attributes attributes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PhotometricInterpretation decompress() {
            return RGB;
        }
    }
    ,
    YBR_RCT{

        @Override
        public ColorModel createColorModel(int n, int n2, Attributes attributes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PhotometricInterpretation decompress() {
            return RGB;
        }
    };


    private PhotometricInterpretation() {
    }

    public static PhotometricInterpretation fromString(String string) {
        return string.equals("PALETTE COLOR") ? PALETTE_COLOR : PhotometricInterpretation.valueOf(string);
    }

    public int frameLength(int n, int n2, int n3, int n4) {
        return n * n2 * n3 * (n4 >> 3);
    }

    public boolean isMonochrome() {
        return false;
    }

    public PhotometricInterpretation decompress() {
        return this;
    }

    public boolean isInvers() {
        return false;
    }

    public boolean isSubSambled() {
        return false;
    }

    public abstract ColorModel createColorModel(int var1, int var2, Attributes var3);

    public SampleModel createSampleModel(int n, int n2, int n3, int n4, boolean bl) {
        int[] nArray = new int[n4];
        int n5 = 1;
        while (n5 < n4) {
            nArray[n5] = n5;
            ++n5;
        }
        return bl ? new BandedSampleModel(n, n2, n3, n2, nArray, new int[n4]) : new PixelInterleavedSampleModel(n, n2, n3, n4, n2 * n4, nArray);
    }

    /* synthetic */ PhotometricInterpretation(String string, int n, PhotometricInterpretation photometricInterpretation) {
        this();
    }
}

