/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import org.dcm4che3.imageio.codec.ImageParams;
import org.dcm4che3.imageio.codec.TransferSyntaxType;

class BufferedImageUtils {
    BufferedImageUtils() {
    }

    public static BufferedImage createBufferedImage(ImageParams imageParams, TransferSyntaxType transferSyntaxType) {
        int n = imageParams.getBitsAllocated() > 8 ? (imageParams.isSigned() && (transferSyntaxType == null || transferSyntaxType.canEncodeSigned()) ? 2 : 1) : 0;
        int n2 = imageParams.getSamples();
        int n3 = transferSyntaxType == null ? imageParams.getBitsStored() : Math.min(imageParams.getBitsStored(), transferSyntaxType.getMaxBitsStored());
        ComponentColorModel componentColorModel = n2 == 1 ? new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{n3}, false, false, 1, n) : new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{n3, n3, n3}, false, false, 1, n);
        int n4 = imageParams.getRows();
        int n5 = imageParams.getColumns();
        ComponentSampleModel componentSampleModel = imageParams.isBanded() ? new BandedSampleModel(n, n5, n4, n2) : new PixelInterleavedSampleModel(n, n5, n4, n2, n5 * n2, BufferedImageUtils.bandOffsets(n2));
        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, null);
        return new BufferedImage(componentColorModel, writableRaster, false, null);
    }

    private static int[] bandOffsets(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        return nArray;
    }

    public static int sizeOf(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        return dataBuffer.getSize() * dataBuffer.getNumBanks() * (DataBuffer.getDataTypeSize(dataBuffer.getDataType()) >>> 3);
    }

    public static void writeTo(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        WritableRaster writableRaster = bufferedImage.getRaster();
        SampleModel sampleModel = writableRaster.getSampleModel();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        switch (dataBuffer.getDataType()) {
            case 0: {
                BufferedImageUtils.writeTo(sampleModel, ((DataBufferByte)dataBuffer).getBankData(), outputStream);
                break;
            }
            case 1: {
                BufferedImageUtils.writeTo(sampleModel, ((DataBufferUShort)dataBuffer).getData(), outputStream);
                break;
            }
            case 2: {
                BufferedImageUtils.writeTo(sampleModel, ((DataBufferShort)dataBuffer).getData(), outputStream);
                break;
            }
            case 3: {
                BufferedImageUtils.writeTo(sampleModel, ((DataBufferInt)dataBuffer).getData(), outputStream);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Datatype: " + dataBuffer.getDataType());
            }
        }
    }

    private static void writeTo(SampleModel sampleModel, byte[][] byArray, OutputStream outputStream) throws IOException {
        int n = sampleModel.getHeight();
        int n2 = sampleModel.getWidth();
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
        int n3 = n2 * componentSampleModel.getPixelStride();
        int n4 = componentSampleModel.getScanlineStride();
        if (componentSampleModel.getBandOffsets()[0] != 0) {
            BufferedImageUtils.bgr2rgb(byArray[0]);
        }
        byte[][] byArray2 = byArray;
        int n5 = byArray.length;
        int n6 = 0;
        while (n6 < n5) {
            byte[] byArray3 = byArray2[n6];
            int n7 = 0;
            int n8 = 0;
            while (n7 < n) {
                outputStream.write(byArray3, n8, n3);
                ++n7;
                n8 += n4;
            }
            ++n6;
        }
    }

    private static void bgr2rgb(byte[] byArray) {
        int n = 0;
        int n2 = 2;
        while (n2 < byArray.length) {
            byte by = byArray[n];
            byArray[n] = byArray[n2];
            byArray[n2] = by;
            n += 3;
            n2 += 3;
        }
    }

    private static void writeTo(SampleModel sampleModel, short[] sArray, OutputStream outputStream) throws IOException {
        int n = sampleModel.getHeight();
        int n2 = sampleModel.getWidth();
        int n3 = ((ComponentSampleModel)sampleModel).getScanlineStride();
        byte[] byArray = new byte[n2 * 2];
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            int n6 = n4 * n3;
            while (n5 < byArray.length) {
                short s = sArray[n6++];
                byArray[n5++] = (byte)s;
                byArray[n5++] = (byte)(s >> 8);
            }
            outputStream.write(byArray);
            ++n4;
        }
    }

    private static void writeTo(SampleModel sampleModel, int[] nArray, OutputStream outputStream) throws IOException {
        int n = sampleModel.getHeight();
        int n2 = sampleModel.getWidth();
        int n3 = ((SinglePixelPackedSampleModel)sampleModel).getScanlineStride();
        byte[] byArray = new byte[n2 * 3];
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            int n6 = n4 * n3;
            while (n5 < byArray.length) {
                int n7 = nArray[n6++];
                byArray[n5++] = (byte)(n7 >> 16);
                byArray[n5++] = (byte)(n7 >> 8);
                byArray[n5++] = (byte)n7;
            }
            outputStream.write(byArray);
            ++n4;
        }
    }

    public static void nullifyUnusedBits(int n, DataBuffer dataBuffer) {
        short[] sArray;
        if (n >= 16) {
            return;
        }
        switch (dataBuffer.getDataType()) {
            case 1: {
                sArray = ((DataBufferUShort)dataBuffer).getData();
                break;
            }
            case 2: {
                sArray = ((DataBufferShort)dataBuffer).getData();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Datatype: " + dataBuffer.getDataType());
            }
        }
        int n2 = (1 << n) - 1;
        int n3 = 0;
        while (n3 < sArray.length) {
            int n4 = n3++;
            sArray[n4] = (short)(sArray[n4] & n2);
        }
    }

    public static int maxDiff(WritableRaster writableRaster, WritableRaster writableRaster2) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
        ComponentSampleModel componentSampleModel2 = (ComponentSampleModel)writableRaster2.getSampleModel();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        DataBuffer dataBuffer2 = writableRaster2.getDataBuffer();
        switch (dataBuffer.getDataType()) {
            case 0: {
                return BufferedImageUtils.maxDiff(componentSampleModel, ((DataBufferByte)dataBuffer).getBankData(), componentSampleModel2, ((DataBufferByte)dataBuffer2).getBankData());
            }
            case 1: {
                return BufferedImageUtils.maxDiff(componentSampleModel, ((DataBufferUShort)dataBuffer).getData(), componentSampleModel2, ((DataBufferUShort)dataBuffer2).getData());
            }
            case 2: {
                return BufferedImageUtils.maxDiff(componentSampleModel, ((DataBufferShort)dataBuffer).getData(), componentSampleModel2, ((DataBufferShort)dataBuffer2).getData());
            }
        }
        throw new UnsupportedOperationException("Unsupported Datatype: " + dataBuffer.getDataType());
    }

    public static int maxDiff(WritableRaster writableRaster, WritableRaster writableRaster2, int n) {
        if (n <= 1) {
            return BufferedImageUtils.maxDiff(writableRaster, writableRaster2);
        }
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
        ComponentSampleModel componentSampleModel2 = (ComponentSampleModel)writableRaster2.getSampleModel();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        DataBuffer dataBuffer2 = writableRaster2.getDataBuffer();
        int n2 = componentSampleModel.getWidth();
        int n3 = componentSampleModel.getHeight();
        int n4 = (n3 / n - 1) * n;
        int n5 = (n2 / n - 1) * n;
        int[] nArray = new int[n * n];
        int n6 = 0;
        int n7 = 0;
        while (n7 < componentSampleModel.getNumBands()) {
            int n8 = 0;
            while (n8 < n4) {
                int n9 = 0;
                while (n9 < n5) {
                    int n10 = Math.abs(BufferedImageUtils.sum(componentSampleModel.getSamples(n9, n8, n, n, n7, nArray, dataBuffer)) - BufferedImageUtils.sum(componentSampleModel2.getSamples(n9, n8, n, n, n7, nArray, dataBuffer2)));
                    if (n6 < n10) {
                        n6 = n10;
                    }
                    n9 += n;
                }
                n8 += n;
            }
            ++n7;
        }
        return n6 / nArray.length;
    }

    private static int sum(int[] nArray) {
        int n = 0;
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            n += n4;
            ++n3;
        }
        return n;
    }

    private static int maxDiff(ComponentSampleModel componentSampleModel, short[] sArray, ComponentSampleModel componentSampleModel2, short[] sArray2) {
        int n = componentSampleModel.getWidth() * componentSampleModel.getPixelStride();
        int n2 = componentSampleModel.getHeight();
        int n3 = componentSampleModel.getScanlineStride();
        int n4 = componentSampleModel2.getScanlineStride();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = n;
            int n8 = n6 * n3;
            int n9 = n6 * n4;
            while (n7-- > 0) {
                int n10 = Math.abs(sArray[n8] - sArray2[n9]);
                if (n5 < n10) {
                    n5 = n10;
                }
                ++n8;
                ++n9;
            }
            ++n6;
        }
        return n5;
    }

    private static int maxDiff(ComponentSampleModel componentSampleModel, byte[][] byArray, ComponentSampleModel componentSampleModel2, byte[][] byArray2) {
        int n = componentSampleModel.getWidth();
        int n2 = componentSampleModel.getHeight();
        int n3 = componentSampleModel.getNumBands();
        int n4 = componentSampleModel.getScanlineStride();
        int n5 = componentSampleModel.getPixelStride();
        int[] nArray = componentSampleModel.getBankIndices();
        int[] nArray2 = componentSampleModel.getBandOffsets();
        int n6 = componentSampleModel2.getScanlineStride();
        int n7 = componentSampleModel2.getPixelStride();
        int[] nArray3 = componentSampleModel2.getBankIndices();
        int[] nArray4 = componentSampleModel2.getBandOffsets();
        int n8 = 0;
        int n9 = 0;
        while (n9 < n3) {
            byte[] byArray3 = byArray[nArray[n9]];
            byte[] byArray4 = byArray2[nArray3[n9]];
            int n10 = nArray2[n9];
            int n11 = nArray4[n9];
            int n12 = 0;
            while (n12 < n2) {
                int n13 = n;
                int n14 = n12 * n4 + n10;
                int n15 = n12 * n6 + n11;
                while (n13-- > 0) {
                    int n16 = Math.abs(byArray3[n14] - byArray4[n15]);
                    if (n8 < n16) {
                        n8 = n16;
                    }
                    n14 += n5;
                    n15 += n7;
                }
                ++n12;
            }
            ++n9;
        }
        return n8;
    }
}

