/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import java.io.Serializable;
import java.util.EnumSet;
import org.dcm4che3.conf.core.api.ConfigurableClass;
import org.dcm4che3.conf.core.api.ConfigurableProperty;
import org.dcm4che3.conf.core.api.LDAP;
import org.dcm4che3.image.PhotometricInterpretation;
import org.dcm4che3.util.Property;
import org.dcm4che3.util.StringUtils;

@LDAP(objectClasses={"dcmCompressionRule"})
@ConfigurableClass
public class CompressionRule
implements Comparable<CompressionRule>,
Serializable {
    private static final long serialVersionUID = 2010254518169306864L;
    @ConfigurableProperty(name="cn")
    private String commonName;
    @LDAP(noContainerNode=true)
    @ConfigurableProperty(name="condition")
    private Condition condition;
    @ConfigurableProperty(name="dicomTransferSyntax")
    private String tsuid;
    @ConfigurableProperty(name="dcmImageWriteParam")
    private Property[] imageWriteParams;

    public CompressionRule() {
    }

    public CompressionRule(String string, String[] stringArray, int[] nArray, int n, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String string2, String ... stringArray7) {
        this.commonName = string;
        this.condition = new Condition(stringArray, nArray, n, StringUtils.maskNull(stringArray2), StringUtils.maskNull(stringArray3), StringUtils.maskNull(stringArray4), StringUtils.maskNull(stringArray5), StringUtils.maskNull(stringArray6));
        this.tsuid = string2;
        this.imageWriteParams = Property.valueOf(stringArray7);
    }

    public void setCommonName(String string) {
        this.commonName = string;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
        this.condition.calcWeight();
    }

    public String getTsuid() {
        return this.tsuid;
    }

    public void setTsuid(String string) {
        this.tsuid = string;
    }

    public void setImageWriteParams(Property[] propertyArray) {
        this.imageWriteParams = propertyArray;
    }

    public final String getCommonName() {
        return this.commonName;
    }

    public PhotometricInterpretation[] getPhotometricInterpretations() {
        return this.condition.getPhotometricInterpretations();
    }

    public int[] getBitsStored() {
        return this.condition.getBitsStored();
    }

    public final int getPixelRepresentation() {
        return this.condition.pixelRepresentation;
    }

    public final String[] getAETitles() {
        return this.condition.aeTitles;
    }

    public final String[] getSOPClasses() {
        return this.condition.sopClasses;
    }

    public final String[] getBodyPartExamined() {
        return this.condition.bodyPartExamined;
    }

    public final String getTransferSyntax() {
        return this.tsuid;
    }

    public Property[] getImageWriteParams() {
        return this.imageWriteParams;
    }

    public boolean matchesCondition(PhotometricInterpretation photometricInterpretation, int n, int n2, String string, String string2, String string3, String[] stringArray, String string4) {
        return this.condition.matches(photometricInterpretation, n, n2, string, string2, string3, stringArray, string4);
    }

    @Override
    public int compareTo(CompressionRule compressionRule) {
        return this.condition.compareTo(compressionRule.condition);
    }

    @ConfigurableClass
    public static class Condition
    implements Comparable<Condition>,
    Serializable {
        private static final long serialVersionUID = -4069284624944470710L;
        @ConfigurableProperty(name="dcmPhotometricInterpretation")
        EnumSet<PhotometricInterpretation> pmis;
        @ConfigurableProperty(name="dcmBitsStored")
        int[] bitsStoredMaskArray;
        int bitsStoredMask;
        @ConfigurableProperty(name="dcmPixelRepresentation", defaultValue="-1")
        int pixelRepresentation = -1;
        @ConfigurableProperty(name="dcmDeviceName")
        String[] deviceNames;
        @ConfigurableProperty(name="dcmAETitle")
        String[] aeTitles;
        @ConfigurableProperty(name="dcmSOPClass")
        String[] sopClasses;
        @ConfigurableProperty(name="dcmImageType")
        String[] imageType;
        @ConfigurableProperty(name="dcmBodyPartExamined")
        String[] bodyPartExamined;
        int weight;

        public Condition() {
        }

        Condition(String[] stringArray, int[] nArray, int n, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6) {
            this.pmis = EnumSet.noneOf(PhotometricInterpretation.class);
            String[] stringArray7 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray7[n3];
                this.pmis.add(PhotometricInterpretation.fromString(string));
                ++n3;
            }
            this.bitsStoredMask = this.toBitsStoredMask(nArray);
            this.setDeviceNames(stringArray3);
            this.aeTitles = stringArray2;
            this.sopClasses = stringArray4;
            this.imageType = stringArray5;
            this.bodyPartExamined = stringArray6;
            this.calcWeight();
        }

        public void calcWeight() {
            this.weight = (this.aeTitles.length != 0 ? 16 : 0) + (this.deviceNames.length != 0 ? 8 : 0) + (this.sopClasses.length != 0 ? 4 : 0) + (this.bodyPartExamined.length != 0 ? 2 : 0) + (this.imageType.length != 0 ? 1 : 0);
        }

        public EnumSet<PhotometricInterpretation> getPmis() {
            return this.pmis;
        }

        public void setPmis(EnumSet<PhotometricInterpretation> enumSet) {
            this.pmis = enumSet;
        }

        public int getBitsStoredMask() {
            return this.bitsStoredMask;
        }

        public void setBitsStoredMask(int n) {
            this.bitsStoredMask = n;
        }

        public int getPixelRepresentation() {
            return this.pixelRepresentation;
        }

        public void setPixelRepresentation(int n) {
            this.pixelRepresentation = n;
        }

        public String[] getDeviceNames() {
            return this.deviceNames;
        }

        public void setDeviceNames(String[] stringArray) {
            this.deviceNames = stringArray;
        }

        public String[] getAeTitles() {
            return this.aeTitles;
        }

        public void setAeTitles(String[] stringArray) {
            this.aeTitles = stringArray;
        }

        public String[] getSopClasses() {
            return this.sopClasses;
        }

        public void setSopClasses(String[] stringArray) {
            this.sopClasses = stringArray;
        }

        public String[] getImageType() {
            return this.imageType;
        }

        public void setImageType(String[] stringArray) {
            this.imageType = stringArray;
        }

        public String[] getBodyPartExamined() {
            return this.bodyPartExamined;
        }

        public void setBodyPartExamined(String[] stringArray) {
            this.bodyPartExamined = stringArray;
        }

        private int toBitsStoredMask(int[] nArray) {
            int n = 0;
            int[] nArray2 = nArray;
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray2[n3];
                n |= 1 << n4;
                ++n3;
            }
            return n;
        }

        PhotometricInterpretation[] getPhotometricInterpretations() {
            return this.pmis.toArray(new PhotometricInterpretation[this.pmis.size()]);
        }

        int[] getBitsStored() {
            int n = 0;
            int n2 = 8;
            while (n2 <= 16) {
                if (this.matchBitStored(n2)) {
                    ++n;
                }
                ++n2;
            }
            int[] nArray = new int[n];
            int n3 = 8;
            int n4 = 0;
            while (n3 <= 16) {
                if (this.matchBitStored(n3)) {
                    nArray[n4++] = n3;
                }
                ++n3;
            }
            return nArray;
        }

        public int[] getBitsStoredMaskArray() {
            return this.getBitsStored();
        }

        public void setBitsStoredMaskArray(int[] nArray) {
            this.bitsStoredMask = this.toBitsStoredMask(nArray);
        }

        @Override
        public int compareTo(Condition condition) {
            return condition.weight - this.weight;
        }

        public boolean matches(PhotometricInterpretation photometricInterpretation, int n, int n2, String string, String string2, String string3, String[] stringArray, String string4) {
            return this.pmis.contains((Object)photometricInterpretation) && this.matchBitStored(n) && this.matchPixelRepresentation(n2) && Condition.isEmptyOrContains((Object[])this.deviceNames, string2) && Condition.isEmptyOrContains((Object[])this.aeTitles, string) && Condition.isEmptyOrContains((Object[])this.sopClasses, string3) && Condition.isEmptyOrContains((Object[])this.imageType, stringArray) && Condition.isEmptyOrContains((Object[])this.bodyPartExamined, string4);
        }

        private boolean matchPixelRepresentation(int n) {
            return this.pixelRepresentation == -1 || this.pixelRepresentation == n;
        }

        private boolean matchBitStored(int n) {
            return (1 << n & this.bitsStoredMask) != 0;
        }

        private static boolean isEmptyOrContains(Object[] objectArray, Object object) {
            if (object == null || objectArray.length == 0) {
                return true;
            }
            int n = 0;
            while (n < objectArray.length) {
                if (object.equals(objectArray[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private static boolean isEmptyOrContains(Object[] objectArray, Object[] objectArray2) {
            if (objectArray == null || objectArray.length == 0 || objectArray2 == null || objectArray2.length == 0) {
                return true;
            }
            int n = 0;
            while (n < objectArray2.length) {
                if (Condition.isEmptyOrContains(objectArray, objectArray2[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }
}

