/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dcm4che3.conf.core.api.ConfigurableClass;
import org.dcm4che3.conf.core.api.ConfigurableProperty;
import org.dcm4che3.conf.core.api.LDAP;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.image.PhotometricInterpretation;
import org.dcm4che3.imageio.codec.CompressionRule;

@ConfigurableClass
public class CompressionRules
implements Iterable<CompressionRule>,
Serializable {
    private static final long serialVersionUID = 5027417735779753342L;
    @LDAP(noContainerNode=true)
    @ConfigurableProperty
    private List<CompressionRule> list = new ArrayList<CompressionRule>();

    public void add(CompressionRule compressionRule) {
        if (this.findByCommonName(compressionRule.getCommonName()) != null) {
            throw new IllegalStateException("CompressionRule with cn: '" + compressionRule.getCommonName() + "' already exists");
        }
        int n = Collections.binarySearch(this.list, compressionRule);
        if (n < 0) {
            n = -(n + 1);
        }
        this.list.add(n, compressionRule);
    }

    public List<CompressionRule> getList() {
        return this.list;
    }

    public void setList(List<CompressionRule> list) {
        this.list.clear();
        for (CompressionRule compressionRule : list) {
            this.add(compressionRule);
        }
    }

    public void add(CompressionRules compressionRules) {
        for (CompressionRule compressionRule : compressionRules) {
            this.add(compressionRule);
        }
    }

    public boolean remove(CompressionRule compressionRule) {
        return this.list.remove(compressionRule);
    }

    public void clear() {
        this.list.clear();
    }

    public CompressionRule findByCommonName(String string) {
        for (CompressionRule compressionRule : this.list) {
            if (!string.equals(compressionRule.getCommonName())) continue;
            return compressionRule;
        }
        return null;
    }

    public CompressionRule findCompressionRule(String string, Attributes attributes) {
        return this.findCompressionRule(null, string, attributes);
    }

    public CompressionRule findCompressionRule(String string, String string2, Attributes attributes) {
        try {
            return this.findCompressionRule(string, string2, PhotometricInterpretation.fromString(attributes.getString(2621444)), attributes.getInt(2621697, 0), attributes.getInt(2621699, 0), attributes.getString(524310), attributes.getStrings(524296), attributes.getString(1572885));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public CompressionRule findCompressionRule(String string, PhotometricInterpretation photometricInterpretation, int n, int n2, String string2, String[] stringArray, String string3) {
        return this.findCompressionRule(null, string, photometricInterpretation, n, n2, string2, stringArray, string3);
    }

    public CompressionRule findCompressionRule(String string, String string2, PhotometricInterpretation photometricInterpretation, int n, int n2, String string3, String[] stringArray, String string4) {
        for (CompressionRule compressionRule : this.list) {
            if (!compressionRule.matchesCondition(photometricInterpretation, n, n2, string2, string, string3, stringArray, string4)) continue;
            return compressionRule;
        }
        return null;
    }

    @Override
    public Iterator<CompressionRule> iterator() {
        return this.list.iterator();
    }
}

