/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import javax.imageio.IIOImage;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.Value;
import org.dcm4che3.image.Overlays;
import org.dcm4che3.image.PhotometricInterpretation;
import org.dcm4che3.imageio.codec.BufferedImageUtils;
import org.dcm4che3.imageio.codec.CompressionVerificationException;
import org.dcm4che3.imageio.codec.Decompressor;
import org.dcm4che3.imageio.codec.ImageReaderFactory;
import org.dcm4che3.imageio.codec.ImageWriterFactory;
import org.dcm4che3.imageio.codec.TransferSyntaxType;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLS;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLSImageOutputStream;
import org.dcm4che3.io.DicomEncodingOptions;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Compressor
extends Decompressor
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Compressor.class);
    private BulkData pixeldata;
    private VR.Holder pixeldataVR = new VR.Holder();
    private ImageWriter compressor;
    private ImageReader verifier;
    private PatchJPEGLS compressPatchJPEGLS;
    private ImageWriteParam compressParam;
    private ImageInputStream iis;
    private IOException ex;
    private int[] embeddedOverlays;
    private int maxPixelValueError = -1;
    private int avgPixelValueBlockSize = 1;
    private BufferedImage bi2;
    private ImageReadParam verifyParam;

    public Compressor(Attributes attributes, String string) {
        super(attributes, string);
        Object object = attributes.getValue(2145386512, this.pixeldataVR);
        if (object == null) {
            return;
        }
        if (object instanceof BulkData) {
            this.pixeldata = (BulkData)object;
            PhotometricInterpretation photometricInterpretation = this.imageParams.getPhotometricInterpretation();
            if (photometricInterpretation.isSubSambled()) {
                throw new UnsupportedOperationException("Unsupported Photometric Interpretation: " + (Object)((Object)photometricInterpretation));
            }
            if (this.pixeldata.length() < this.imageParams.getLength()) {
                throw new IllegalArgumentException("Pixel data too short: " + this.pixeldata.length() + " instead " + this.imageParams.getLength() + " bytes");
            }
        }
        this.embeddedOverlays = Overlays.getEmbeddedOverlayGroupOffsets(attributes);
    }

    public boolean compress(String string, Property ... propertyArray) throws IOException {
        Object object;
        Object object2;
        if (string == null) {
            throw new NullPointerException("compressTsuid");
        }
        if (this.imageParams == null) {
            return false;
        }
        ImageWriterFactory.ImageWriterParam imageWriterParam = ImageWriterFactory.getImageWriterParam(string);
        if (imageWriterParam == null) {
            throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + string);
        }
        this.compressor = ImageWriterFactory.getImageWriter(imageWriterParam);
        LOG.debug("Compressor: {}", (Object)this.compressor.getClass().getName());
        this.compressPatchJPEGLS = imageWriterParam.patchJPEGLS;
        this.compressParam = this.compressor.getDefaultWriteParam();
        int n = 0;
        Property[] propertyArray2 = this.cat(imageWriterParam.getImageWriteParams(), propertyArray);
        int n2 = propertyArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            object2 = propertyArray2[n3];
            object = ((Property)object2).getName();
            if (((String)object).equals("maxPixelValueError")) {
                this.maxPixelValueError = ((Number)((Property)object2).getValue()).intValue();
            } else if (((String)object).equals("avgPixelValueBlockSize")) {
                this.avgPixelValueBlockSize = ((Number)((Property)object2).getValue()).intValue();
            } else {
                if (n++ == 0) {
                    this.compressParam.setCompressionMode(2);
                }
                ((Property)object2).setAt(this.compressParam);
            }
            ++n3;
        }
        if (this.maxPixelValueError >= 0) {
            object2 = ImageReaderFactory.getImageReaderParam(string);
            if (object2 == null) {
                throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + string);
            }
            this.verifier = ImageReaderFactory.getImageReader((ImageReaderFactory.ImageReaderParam)object2);
            this.verifyParam = this.verifier.getDefaultReadParam();
            LOG.debug("Verifier: {}", (Object)this.verifier.getClass().getName());
        }
        object2 = TransferSyntaxType.forUID(string);
        if (this.decompressor == null || this.tsType == TransferSyntaxType.RLE) {
            this.bi = BufferedImageUtils.createBufferedImage(this.imageParams, (TransferSyntaxType)((Object)object2));
        }
        this.imageParams.compress(this.dataset, (TransferSyntaxType)((Object)object2));
        n3 = this.imageParams.getFrames();
        Fragments fragments = this.dataset.newFragments(2145386512, VR.OB, n3 + 1);
        fragments.add(Value.NULL);
        int n4 = 0;
        while (n4 < n3) {
            object = new CompressedFrame(n4);
            if (this.embeddedOverlays.length != 0) {
                ((CompressedFrame)object).compress();
            }
            fragments.add(object);
            ++n4;
        }
        int[] nArray = this.embeddedOverlays;
        int n5 = this.embeddedOverlays.length;
        int n6 = 0;
        while (n6 < n5) {
            n4 = nArray[n6];
            this.dataset.setInt(0x60000100 | n4, VR.US, 1);
            this.dataset.setInt(0x60000102 | n4, VR.US, 0);
            ++n6;
        }
        return true;
    }

    private Property[] cat(Property[] propertyArray, Property[] propertyArray2) {
        if (propertyArray.length == 0) {
            return propertyArray2;
        }
        if (propertyArray2.length == 0) {
            return propertyArray;
        }
        Property[] propertyArray3 = new Property[propertyArray.length + propertyArray2.length];
        System.arraycopy(propertyArray, 0, propertyArray3, 0, propertyArray.length);
        System.arraycopy(propertyArray2, 0, propertyArray3, propertyArray.length, propertyArray2.length);
        return propertyArray3;
    }

    @Override
    public void close() {
        if (this.iis != null) {
            try {
                this.iis.close();
            }
            catch (IOException iOException) {}
        }
        this.dispose();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.compressor != null) {
            this.compressor.dispose();
        }
        if (this.verifier != null) {
            this.verifier.dispose();
        }
        this.compressor = null;
        this.verifier = null;
    }

    public BufferedImage readFrame(int n) throws IOException {
        if (this.iis == null) {
            this.iis = new FileImageInputStream(this.file);
        }
        if (this.decompressor != null) {
            return this.decompressFrame(this.iis, n);
        }
        this.iis.setByteOrder(this.pixeldata.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        this.iis.seek(this.pixeldata.offset() + (long)(this.imageParams.getFrameLength() * n));
        DataBuffer dataBuffer = this.bi.getRaster().getDataBuffer();
        switch (dataBuffer.getDataType()) {
            case 0: {
                byte[][] byArray;
                byte[][] byArray2 = byArray = ((DataBufferByte)dataBuffer).getBankData();
                int n2 = byArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    byte[] byArray3 = byArray2[n3];
                    this.iis.readFully(byArray3);
                    ++n3;
                }
                if (!this.pixeldata.bigEndian || this.pixeldataVR.vr != VR.OW) break;
                ByteUtils.swapShorts(byArray);
                break;
            }
            case 1: {
                this.readFully(((DataBufferUShort)dataBuffer).getData());
                break;
            }
            case 2: {
                this.readFully(((DataBufferShort)dataBuffer).getData());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Datatype: " + dataBuffer.getDataType());
            }
        }
        return this.bi;
    }

    private void verify(ImageInputStream imageInputStream, int n) throws IOException {
        if (this.verifier == null) {
            return;
        }
        imageInputStream.seek(0L);
        this.verifier.setInput(imageInputStream);
        this.verifyParam.setDestination(this.bi2);
        long l = System.currentTimeMillis();
        this.bi2 = this.verifier.read(0, this.verifyParam);
        int n2 = BufferedImageUtils.maxDiff(this.bi.getRaster(), this.bi2.getRaster(), this.avgPixelValueBlockSize);
        long l2 = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verified compressed frame #{} in {} ms - max pixel value error: {}", new Object[]{n + 1, l2 - l, n2});
        }
        if (n2 > this.maxPixelValueError) {
            throw new CompressionVerificationException(n2);
        }
    }

    private void extractEmbeddedOverlays(int n, BufferedImage bufferedImage) {
        int[] nArray = this.embeddedOverlays;
        int n2 = this.embeddedOverlays.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            int n5 = this.dataset.getInt(0x60000010 | n4, 0);
            int n6 = this.dataset.getInt(0x60000011 | n4, 0);
            int n7 = this.dataset.getInt(0x60000102 | n4, 0);
            int n8 = 1 << n7;
            int n9 = n5 * n6;
            byte[] byArray = this.dataset.getSafeBytes(0x60003000 | n4);
            if (byArray == null) {
                byArray = new byte[(n9 * this.imageParams.getFrames() + 7 >>> 3) + 1 & 0xFFFFFFFE];
                this.dataset.setBytes(0x60003000 | n4, VR.OB, byArray);
            }
            Overlays.extractFromPixeldata(bufferedImage.getRaster(), n8, byArray, n9 * n, n9);
            LOG.debug("Extracted embedded overlay #{} from bit #{} of frame #{}", new Object[]{(n4 >>> 17) + 1, n7, n + 1});
            ++n3;
        }
    }

    private void readFully(short[] sArray) throws IOException {
        this.iis.readFully(sArray, 0, sArray.length);
    }

    private static class CacheOutputStream
    extends FilterOutputStream {
        public CacheOutputStream() {
            super(null);
        }

        public void set(OutputStream outputStream) {
            this.out = outputStream;
        }
    }

    private class CompressedFrame
    implements Value {
        private int frameIndex;
        private int streamLength;
        private CacheOutputStream cacheout = new CacheOutputStream();
        private MemoryCacheImageOutputStream cache;

        public CompressedFrame(int n) throws IOException {
            this.frameIndex = n;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public byte[] toBytes(VR vR, boolean bl) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writeTo(byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        @Override
        public void writeTo(DicomOutputStream dicomOutputStream, VR vR) throws IOException {
            this.writeTo(dicomOutputStream);
        }

        @Override
        public int calcLength(DicomEncodingOptions dicomEncodingOptions, boolean bl, VR vR) {
            return this.getEncodedLength(dicomEncodingOptions, bl, vR);
        }

        @Override
        public int getEncodedLength(DicomEncodingOptions dicomEncodingOptions, boolean bl, VR vR) {
            try {
                this.compress();
            }
            catch (IOException iOException) {
                return -1;
            }
            return this.streamLength + 1 & 0xFFFFFFFE;
        }

        private void writeTo(OutputStream outputStream) throws IOException {
            this.compress();
            this.cacheout.set(outputStream);
            long l = System.currentTimeMillis();
            this.cache.close();
            if ((this.streamLength & 1) != 0) {
                outputStream.write(0);
            }
            long l2 = System.currentTimeMillis();
            LOG.debug("Flushed frame #{} from memory in {} ms", (Object)(this.frameIndex + 1), (Object)(l2 - l));
        }

        private void compress() throws IOException {
            if (this.cache != null) {
                return;
            }
            if (Compressor.this.ex != null) {
                throw Compressor.this.ex;
            }
            try {
                BufferedImage bufferedImage = Compressor.this.readFrame(this.frameIndex);
                Compressor.this.extractEmbeddedOverlays(this.frameIndex, bufferedImage);
                if (Compressor.this.imageParams.getBitsStored() < Compressor.this.imageParams.getBitsAllocated()) {
                    BufferedImageUtils.nullifyUnusedBits(Compressor.this.imageParams.getBitsStored(), bufferedImage.getRaster().getDataBuffer());
                }
                this.cache = new MemoryCacheImageOutputStream(this.cacheout){

                    @Override
                    public void flush() throws IOException {
                        LOG.debug("Ignore invoke of MemoryCacheImageOutputStream.flush()");
                    }
                };
                Compressor.this.compressor.setOutput(Compressor.this.compressPatchJPEGLS != null ? new PatchJPEGLSImageOutputStream(this.cache, Compressor.this.compressPatchJPEGLS) : this.cache);
                long l = System.currentTimeMillis();
                Compressor.this.compressor.write(null, new IIOImage(bufferedImage, null, null), Compressor.this.compressParam);
                long l2 = System.currentTimeMillis();
                this.streamLength = (int)this.cache.getStreamPosition();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Compressed frame #{} {}:1 in {} ms", new Object[]{this.frameIndex + 1, Float.valueOf((float)BufferedImageUtils.sizeOf(bufferedImage) / (float)this.streamLength), l2 - l});
                }
                Compressor.this.verify(this.cache, this.frameIndex);
            }
            catch (IOException iOException) {
                this.cache = null;
                Compressor.this.ex = iOException;
                throw iOException;
            }
        }
    }
}

