/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.Value;
import org.dcm4che3.imageio.codec.BufferedImageUtils;
import org.dcm4che3.imageio.codec.ImageParams;
import org.dcm4che3.imageio.codec.ImageReaderFactory;
import org.dcm4che3.imageio.codec.TransferSyntaxType;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLS;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLSImageInputStream;
import org.dcm4che3.imageio.stream.SegmentedImageInputStream;
import org.dcm4che3.io.DicomEncodingOptions;
import org.dcm4che3.io.DicomOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Decompressor {
    private static final Logger LOG = LoggerFactory.getLogger(Decompressor.class);
    protected final Attributes dataset;
    protected final String tsuid;
    protected final TransferSyntaxType tsType;
    protected Fragments pixeldataFragments;
    protected File file;
    protected ImageParams imageParams;
    protected BufferedImage bi;
    protected ImageReader decompressor;
    protected ImageReadParam readParam;
    protected PatchJPEGLS patchJPEGLS;

    public Decompressor(Attributes attributes, String string) {
        if (string == null) {
            throw new NullPointerException("tsuid");
        }
        this.dataset = attributes;
        this.tsuid = string;
        this.tsType = TransferSyntaxType.forUID(string);
        Object object = attributes.getValue(2145386512);
        if (object == null) {
            return;
        }
        if (this.tsType == null) {
            throw new IllegalArgumentException("Unknown Transfer Syntax: " + string);
        }
        this.imageParams = new ImageParams(attributes);
        int n = this.imageParams.getFrames();
        if (object instanceof Fragments) {
            if (!this.tsType.isPixeldataEncapsulated()) {
                throw new IllegalArgumentException("Encapusulated Pixel Datawith Transfer Syntax: " + string);
            }
            this.pixeldataFragments = (Fragments)object;
            int n2 = this.pixeldataFragments.size();
            if (n == 1 ? n2 < 2 : n2 != n + 1) {
                throw new IllegalArgumentException("Number of Pixel Data Fragments: " + n2 + " does not match " + n);
            }
            this.file = ((BulkData)this.pixeldataFragments.get(1)).getFile();
            ImageReaderFactory.ImageReaderParam imageReaderParam = ImageReaderFactory.getImageReaderParam(string);
            if (imageReaderParam == null) {
                throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + string);
            }
            this.decompressor = ImageReaderFactory.getImageReader(imageReaderParam);
            LOG.debug("Decompressor: {}", (Object)this.decompressor.getClass().getName());
            this.readParam = this.decompressor.getDefaultReadParam();
            this.patchJPEGLS = imageReaderParam.patchJPEGLS;
        } else {
            this.file = ((BulkData)object).getFile();
        }
    }

    public void dispose() {
        if (this.decompressor != null) {
            this.decompressor.dispose();
        }
        this.decompressor = null;
    }

    public boolean decompress() {
        if (this.decompressor == null) {
            return false;
        }
        this.imageParams.decompress(this.dataset, this.tsType);
        if (this.tsType == TransferSyntaxType.RLE) {
            this.bi = BufferedImageUtils.createBufferedImage(this.imageParams, this.tsType);
        }
        this.dataset.setValue(2145386512, VR.OW, new Value(){

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public byte[] toBytes(VR vR, boolean bl) throws IOException {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Decompressor.this.writeTo(byteArrayOutputStream);
                return byteArrayOutputStream.toByteArray();
            }

            @Override
            public void writeTo(DicomOutputStream dicomOutputStream, VR vR) throws IOException {
                Decompressor.this.writeTo(dicomOutputStream);
            }

            @Override
            public int calcLength(DicomEncodingOptions dicomEncodingOptions, boolean bl, VR vR) {
                return Decompressor.this.imageParams.getEncodedLength();
            }

            @Override
            public int getEncodedLength(DicomEncodingOptions dicomEncodingOptions, boolean bl, VR vR) {
                return Decompressor.this.imageParams.getEncodedLength();
            }
        });
        return true;
    }

    public static boolean decompress(Attributes attributes, String string) {
        return new Decompressor(attributes, string).decompress();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        FileImageInputStream fileImageInputStream = this.createImageInputStream();
        int n = this.imageParams.getFrames();
        try {
            int n2 = 0;
            while (n2 < n) {
                this.writeFrameTo(fileImageInputStream, n2, outputStream);
                ++n2;
            }
            if (this.imageParams.paddingNull()) {
                outputStream.write(0);
            }
        }
        catch (Throwable throwable) {
            try {
                fileImageInputStream.close();
            }
            catch (IOException iOException) {}
            this.decompressor.dispose();
            throw throwable;
        }
        try {
            fileImageInputStream.close();
        }
        catch (IOException iOException) {}
        this.decompressor.dispose();
    }

    public FileImageInputStream createImageInputStream() throws IOException {
        return new FileImageInputStream(this.file);
    }

    public void writeFrameTo(ImageInputStream imageInputStream, int n, OutputStream outputStream) throws IOException {
        BufferedImageUtils.writeTo(this.decompressFrame(imageInputStream, n), outputStream);
    }

    protected BufferedImage decompressFrame(ImageInputStream imageInputStream, int n) throws IOException {
        SegmentedImageInputStream segmentedImageInputStream = SegmentedImageInputStream.ofFrame(imageInputStream, this.pixeldataFragments, n, this.imageParams.getFrames());
        this.decompressor.setInput(this.patchJPEGLS != null ? new PatchJPEGLSImageInputStream(segmentedImageInputStream, this.patchJPEGLS) : segmentedImageInputStream);
        this.readParam.setDestination(this.bi);
        long l = System.currentTimeMillis();
        this.bi = this.decompressor.read(0, this.readParam);
        long l2 = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Decompressed frame #{} 1:{} in {} ms", new Object[]{n + 1, Float.valueOf((float)BufferedImageUtils.sizeOf(this.bi) / (float)segmentedImageInputStream.getStreamPosition()), l2 - l});
        }
        return this.bi;
    }
}

