/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.image.PhotometricInterpretation;
import org.dcm4che3.imageio.codec.TransferSyntaxType;

class ImageParams {
    private final int rows;
    private final int cols;
    private final int samples;
    private final int pixelRepresentation;
    private final int bitsAllocated;
    private final int bitsStored;
    private final int frames;
    private final int frameLength;
    private final int length;
    private PhotometricInterpretation pmi;
    private int planarConfiguration;

    public ImageParams(Attributes attributes) {
        this.rows = attributes.getInt(2621456, 0);
        this.cols = attributes.getInt(2621457, 0);
        this.samples = attributes.getInt(0x280002, 0);
        this.pmi = PhotometricInterpretation.fromString(attributes.getString(2621444, "MONOCHROME2"));
        this.bitsAllocated = attributes.getInt(2621696, 8);
        this.bitsStored = attributes.getInt(2621697, this.bitsAllocated);
        this.planarConfiguration = attributes.getInt(2621446, 0);
        this.pixelRepresentation = attributes.getInt(2621699, 0);
        this.frames = attributes.getInt(0x280008, 1);
        this.frameLength = this.rows * this.cols * this.samples * (this.bitsAllocated >>> 3);
        this.length = this.frameLength * this.frames;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public int getSamples() {
        return this.samples;
    }

    public int getBitsAllocated() {
        return this.bitsAllocated;
    }

    public int getBitsStored() {
        return this.bitsStored;
    }

    public int getFrameLength() {
        return this.frameLength;
    }

    public int getLength() {
        return this.length;
    }

    public PhotometricInterpretation getPhotometricInterpretation() {
        return this.pmi;
    }

    public int getEncodedLength() {
        return this.length + 1 & 0xFFFFFFFE;
    }

    public boolean paddingNull() {
        return (this.length & 1) != 0;
    }

    public boolean isBanded() {
        return this.planarConfiguration != 0;
    }

    public boolean isSigned() {
        return this.pixelRepresentation != 0;
    }

    public int getFrames() {
        return this.frames;
    }

    public void decompress(Attributes attributes, TransferSyntaxType transferSyntaxType) {
        if (this.samples > 1) {
            this.pmi = this.pmi.decompress();
            this.planarConfiguration = transferSyntaxType.getPlanarConfiguration();
            attributes.setString(2621444, VR.CS, this.pmi.toString());
            attributes.setInt(2621446, VR.US, this.planarConfiguration);
        }
    }

    public void compress(Attributes attributes, TransferSyntaxType transferSyntaxType) {
        if (this.samples > 1) {
            this.pmi = transferSyntaxType.compress(this.pmi);
            this.planarConfiguration = transferSyntaxType.getPlanarConfiguration();
            attributes.setString(2621444, VR.CS, this.pmi.toString());
            attributes.setInt(2621446, VR.US, this.planarConfiguration);
        }
    }
}

