/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import org.dcm4che3.conf.core.api.ConfigurableClass;
import org.dcm4che3.conf.core.api.ConfigurableProperty;
import org.dcm4che3.conf.core.api.LDAP;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLS;
import org.dcm4che3.util.ResourceLocator;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LDAP(objectClasses={"dcmImageReaderFactory"})
@ConfigurableClass
public class ImageReaderFactory
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ImageReaderFactory.class);
    private static final long serialVersionUID = -2881173333124498212L;
    private static ImageReaderFactory defaultFactory;
    @LDAP(distinguishingField="dicomTransferSyntax", noContainerNode=true)
    @ConfigurableProperty(name="dicomImageReaderMap", label="Image Readers", description="Image readers by transfer syntaxes")
    private Map<String, ImageReaderParam> map = new TreeMap<String, ImageReaderParam>();

    private static String nullify(String string) {
        return string == null || string.isEmpty() || string.equals("*") ? null : string;
    }

    public Map<String, ImageReaderParam> getMap() {
        return this.map;
    }

    public void setMap(Map<String, ImageReaderParam> map) {
        this.map = map;
    }

    public static ImageReaderFactory getDefault() {
        if (defaultFactory == null) {
            defaultFactory = ImageReaderFactory.initDefault();
        }
        return defaultFactory;
    }

    public static void resetDefault() {
        defaultFactory = null;
    }

    public static void setDefault(ImageReaderFactory imageReaderFactory) {
        if (imageReaderFactory == null) {
            throw new NullPointerException();
        }
        defaultFactory = imageReaderFactory;
    }

    private static ImageReaderFactory initDefault() {
        ImageReaderFactory imageReaderFactory = new ImageReaderFactory();
        String string = System.getProperty(ImageReaderFactory.class.getName(), "org/dcm4che3/imageio/codec/ImageReaderFactory.properties");
        try {
            imageReaderFactory.load(string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to load Image Reader Factory configuration from: " + string, exception);
        }
        return imageReaderFactory;
    }

    public void load(String string) throws IOException {
        URL uRL;
        block5: {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                uRL = ResourceLocator.getResourceURL(string, this.getClass());
                if (uRL != null) break block5;
                throw new IOException("No such resource: " + string);
            }
        }
        InputStream inputStream = uRL.openStream();
        try {
            this.load(inputStream);
        }
        finally {
            SafeClose.close(inputStream);
        }
    }

    public void load(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String[] stringArray = StringUtils.split((String)entry.getValue(), ':');
            this.map.put((String)entry.getKey(), new ImageReaderParam(stringArray[0], stringArray[1], stringArray[2]));
        }
    }

    public ImageReaderParam get(String string) {
        return this.map.get(string);
    }

    public boolean contains(String string) {
        return this.map.containsKey(string);
    }

    public ImageReaderParam put(String string, ImageReaderParam imageReaderParam) {
        return this.map.put(string, imageReaderParam);
    }

    public ImageReaderParam remove(String string) {
        return this.map.remove(string);
    }

    public Set<Map.Entry<String, ImageReaderParam>> getEntries() {
        return Collections.unmodifiableMap(this.map).entrySet();
    }

    public void clear() {
        this.map.clear();
    }

    public static ImageReaderParam getImageReaderParam(String string) {
        return ImageReaderFactory.getDefault().get(string);
    }

    public static boolean canDecompress(String string) {
        return ImageReaderFactory.getDefault().contains(string);
    }

    public static ImageReader getImageReader(ImageReaderParam imageReaderParam) {
        if (Boolean.parseBoolean(System.getProperty("dcm4che.useImageIOServiceRegistry"))) {
            LOG.debug("getImageReader() - Load imageReader by using ImageIO. Get readers by format name: {}", (Object)imageReaderParam.formatName);
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(imageReaderParam.formatName);
            if (!iterator.hasNext()) {
                throw new RuntimeException("No Image Reader for format: " + imageReaderParam.formatName + " registered");
            }
            ImageReader imageReader = null;
            if (imageReaderParam.className == null) {
                LOG.debug("getImageReader() - no className set. Use first reader in list");
                imageReader = iterator.next();
            } else {
                ImageReader imageReader2;
                LOG.debug("getImageReader() - className set to \"{}\"", (Object)imageReaderParam.className);
                imageReader = imageReader2 = iterator.next();
                while (imageReader != null && !imageReader.getClass().getName().equals(imageReaderParam.className)) {
                    ImageReader imageReader3 = imageReader = iterator.hasNext() ? iterator.next() : null;
                }
                if (imageReader == null) {
                    LOG.warn("getImageReader() - Preferred reader \"{}\" not found. Use first in list.", (Object)imageReaderParam.className);
                    imageReader = imageReader2;
                }
            }
            LOG.debug("Return found reader: {}", (Object)imageReader);
            return imageReader;
        }
        Iterator<ImageReaderSpi> iterator = ServiceLoader.load(ImageReaderSpi.class).iterator();
        try {
            if (iterator != null && iterator.hasNext()) {
                do {
                    ImageReaderSpi imageReaderSpi;
                    if (!ImageReaderFactory.supportsFormat((imageReaderSpi = iterator.next()).getFormatNames(), imageReaderParam.formatName)) continue;
                    ImageReader imageReader = imageReaderSpi.createReaderInstance();
                    if (imageReaderParam.className != null && !imageReaderParam.className.equals(imageReader.getClass().getName())) continue;
                    return imageReader;
                } while (iterator.hasNext());
            }
            throw new RuntimeException("No Image Reader for format: " + imageReaderParam.formatName + " registered");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error instantiating Reader for format: " + imageReaderParam.formatName);
        }
    }

    private static boolean supportsFormat(String[] stringArray, String string) {
        boolean bl = false;
        if (string != null && stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null && stringArray[n].trim().equalsIgnoreCase(string.trim())) {
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    @LDAP(objectClasses={"dcmImageReader"})
    @ConfigurableClass
    public static class ImageReaderParam
    implements Serializable {
        private static final long serialVersionUID = 6593724836340684578L;
        @ConfigurableProperty(name="dcmIIOFormatName")
        public String formatName;
        @ConfigurableProperty(name="dcmJavaClassName")
        public String className;
        @ConfigurableProperty(name="dcmPatchJPEGLS")
        public PatchJPEGLS patchJPEGLS;

        public ImageReaderParam() {
        }

        public ImageReaderParam(String string, String string2, String string3) {
            this.formatName = string;
            this.className = ImageReaderFactory.nullify(string2);
            this.patchJPEGLS = string3 != null && !string3.isEmpty() ? PatchJPEGLS.valueOf(string3) : null;
        }

        public String getFormatName() {
            return this.formatName;
        }

        public void setFormatName(String string) {
            this.formatName = string;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String string) {
            this.className = string;
        }

        public PatchJPEGLS getPatchJPEGLS() {
            return this.patchJPEGLS;
        }

        public void setPatchJPEGLS(PatchJPEGLS patchJPEGLS) {
            this.patchJPEGLS = patchJPEGLS;
        }
    }
}

