/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import org.dcm4che3.conf.core.api.ConfigurableClass;
import org.dcm4che3.conf.core.api.ConfigurableProperty;
import org.dcm4che3.conf.core.api.LDAP;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLS;
import org.dcm4che3.util.Property;
import org.dcm4che3.util.ResourceLocator;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StringUtils;

@LDAP(objectClasses={"dcmImageWriterFactory"})
@ConfigurableClass
public class ImageWriterFactory
implements Serializable {
    private static final long serialVersionUID = 6328126996969794374L;
    private static ImageWriterFactory defaultFactory;
    @LDAP(distinguishingField="dicomTransferSyntax", noContainerNode=true)
    @ConfigurableProperty(name="dicomImageWriterMap", label="Image Writers", description="Image writers by transfer syntaxes")
    private Map<String, ImageWriterParam> map = new TreeMap<String, ImageWriterParam>();

    private static String nullify(String string) {
        return string == null || string.isEmpty() || string.equals("*") ? null : string;
    }

    public Map<String, ImageWriterParam> getMap() {
        return this.map;
    }

    public void setMap(Map<String, ImageWriterParam> map) {
        this.map = map;
    }

    public static ImageWriterFactory getDefault() {
        if (defaultFactory == null) {
            defaultFactory = ImageWriterFactory.initDefault();
        }
        return defaultFactory;
    }

    public static void resetDefault() {
        defaultFactory = null;
    }

    public static void setDefault(ImageWriterFactory imageWriterFactory) {
        if (imageWriterFactory == null) {
            throw new NullPointerException();
        }
        defaultFactory = imageWriterFactory;
    }

    private static ImageWriterFactory initDefault() {
        ImageWriterFactory imageWriterFactory = new ImageWriterFactory();
        String string = System.getProperty(ImageWriterFactory.class.getName(), "org/dcm4che3/imageio/codec/ImageWriterFactory.properties");
        try {
            imageWriterFactory.load(string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to load Image Writer Factory configuration from: " + string, exception);
        }
        return imageWriterFactory;
    }

    public void load(String string) throws IOException {
        URL uRL;
        block5: {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                uRL = ResourceLocator.getResourceURL(string, this.getClass());
                if (uRL != null) break block5;
                throw new IOException("No such resource: " + string);
            }
        }
        InputStream inputStream = uRL.openStream();
        try {
            this.load(inputStream);
        }
        finally {
            SafeClose.close(inputStream);
        }
    }

    public void load(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String[] stringArray = StringUtils.split((String)entry.getValue(), ':');
            this.map.put((String)entry.getKey(), new ImageWriterParam(stringArray[0], stringArray[1], stringArray[2], StringUtils.split(stringArray[3], ';')));
        }
    }

    public ImageWriterParam get(String string) {
        return this.map.get(string);
    }

    public ImageWriterParam put(String string, ImageWriterParam imageWriterParam) {
        return this.map.put(string, imageWriterParam);
    }

    public ImageWriterParam remove(String string) {
        return this.map.remove(string);
    }

    public Set<Map.Entry<String, ImageWriterParam>> getEntries() {
        return Collections.unmodifiableMap(this.map).entrySet();
    }

    public void clear() {
        this.map.clear();
    }

    public static ImageWriterParam getImageWriterParam(String string) {
        return ImageWriterFactory.getDefault().get(string);
    }

    public static ImageWriter getImageWriter(ImageWriterParam imageWriterParam) {
        Iterator<ImageWriterSpi> iterator = ServiceLoader.load(ImageWriterSpi.class).iterator();
        try {
            if (iterator != null && iterator.hasNext()) {
                do {
                    ImageWriterSpi imageWriterSpi;
                    if (!ImageWriterFactory.supportsFormat((imageWriterSpi = iterator.next()).getFormatNames(), imageWriterParam.formatName)) continue;
                    ImageWriter imageWriter = imageWriterSpi.createWriterInstance();
                    if (imageWriterParam.className != null && !imageWriterParam.className.equals(imageWriter.getClass().getName())) continue;
                    return imageWriter;
                } while (iterator.hasNext());
            }
            throw new RuntimeException("No Image Writer for format: " + imageWriterParam.formatName + " registered");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error instantiating Writer for format: " + imageWriterParam.formatName);
        }
    }

    private static boolean supportsFormat(String[] stringArray, String string) {
        boolean bl = false;
        if (string != null && stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null && stringArray[n].trim().equalsIgnoreCase(string.trim())) {
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    @LDAP(objectClasses={"dcmImageWriter"})
    @ConfigurableClass
    public static class ImageWriterParam
    implements Serializable {
        private static final long serialVersionUID = 3521737269113651910L;
        @ConfigurableProperty(name="dcmIIOFormatName")
        public String formatName;
        @ConfigurableProperty(name="dcmJavaClassName")
        public String className;
        @ConfigurableProperty(name="dcmPatchJPEGLS")
        public PatchJPEGLS patchJPEGLS;
        @ConfigurableProperty(name="dcmImageWriteParam")
        public Property[] imageWriteParams;
        @ConfigurableProperty(name="dcmWriteIIOMetadata")
        public Property[] iioMetadata;

        public ImageWriterParam() {
        }

        public ImageWriterParam(String string, String string2, PatchJPEGLS patchJPEGLS, Property[] propertyArray, Property[] propertyArray2) {
            this.formatName = string;
            this.className = ImageWriterFactory.nullify(string2);
            this.patchJPEGLS = patchJPEGLS;
            this.imageWriteParams = propertyArray;
            this.iioMetadata = propertyArray2;
        }

        public ImageWriterParam(String string, String string2, String string3, String[] stringArray, String[] stringArray2) {
            this(string, string2, string3 != null && !string3.isEmpty() ? PatchJPEGLS.valueOf(string3) : null, Property.valueOf(stringArray), Property.valueOf(stringArray2));
        }

        public ImageWriterParam(String string, String string2, String string3, String[] stringArray) {
            this(string, string2, string3 != null && !string3.isEmpty() ? PatchJPEGLS.valueOf(string3) : null, Property.valueOf(stringArray), null);
        }

        public Property[] getImageWriteParams() {
            return this.imageWriteParams;
        }

        public Property[] getIIOMetadata() {
            return this.iioMetadata;
        }

        public String getFormatName() {
            return this.formatName;
        }

        public void setFormatName(String string) {
            this.formatName = string;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String string) {
            this.className = string;
        }

        public PatchJPEGLS getPatchJPEGLS() {
            return this.patchJPEGLS;
        }

        public void setPatchJPEGLS(PatchJPEGLS patchJPEGLS) {
            this.patchJPEGLS = patchJPEGLS;
        }

        public void setImageWriteParams(Property[] propertyArray) {
            this.imageWriteParams = propertyArray;
        }

        public Property[] getIioMetadata() {
            return this.iioMetadata;
        }

        public void setIioMetadata(Property[] propertyArray) {
            this.iioMetadata = propertyArray;
        }
    }
}

