/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.IIOImage;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.imageio.codec.BufferedImageUtils;
import org.dcm4che3.imageio.codec.CompressionVerificationException;
import org.dcm4che3.imageio.codec.ImageParams;
import org.dcm4che3.imageio.codec.ImageReaderFactory;
import org.dcm4che3.imageio.codec.ImageWriterFactory;
import org.dcm4che3.imageio.codec.StreamDecompressor;
import org.dcm4che3.imageio.codec.TransferSyntaxType;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLS;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLSImageOutputStream;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCompressor
extends StreamDecompressor {
    private static final Logger LOG = LoggerFactory.getLogger(StreamCompressor.class);
    private TransferSyntaxType compressTsType;
    private ImageWriter compressor;
    private PatchJPEGLS compressPatchJPEGLS;
    private ImageWriteParam compressParam;
    private int maxPixelValueError = -1;
    private int avgPixelValueBlockSize = 1;
    private ImageReader verifier;
    private ImageReadParam verifyParam;
    private ImageParams imageParams;
    private BufferedImage bi2;
    private int frameIndex;

    public StreamCompressor(DicomInputStream dicomInputStream, String string, DicomOutputStream dicomOutputStream) {
        super(dicomInputStream, string, dicomOutputStream);
    }

    public boolean compress(String string, Property ... propertyArray) throws IOException {
        Serializable serializable;
        if (string == null) {
            throw new NullPointerException("compressTsuid");
        }
        this.compressTsType = TransferSyntaxType.forUID(string);
        if (this.compressTsType == null) {
            throw new IllegalArgumentException("Unknown Transfer Syntax: " + string);
        }
        ImageWriterFactory.ImageWriterParam imageWriterParam = ImageWriterFactory.getImageWriterParam(string);
        if (imageWriterParam == null) {
            throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + string);
        }
        this.compressor = ImageWriterFactory.getImageWriter(imageWriterParam);
        LOG.debug("Compressor: {}", (Object)this.compressor.getClass().getName());
        this.compressPatchJPEGLS = imageWriterParam.patchJPEGLS;
        this.compressParam = this.compressor.getDefaultWriteParam();
        int n = 0;
        Property[] propertyArray2 = this.cat(imageWriterParam.getImageWriteParams(), propertyArray);
        int n2 = propertyArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            serializable = propertyArray2[n3];
            String string2 = ((Property)serializable).getName();
            if (string2.equals("maxPixelValueError")) {
                this.maxPixelValueError = ((Number)((Property)serializable).getValue()).intValue();
            } else if (string2.equals("avgPixelValueBlockSize")) {
                this.avgPixelValueBlockSize = ((Number)((Property)serializable).getValue()).intValue();
            } else {
                if (n++ == 0) {
                    this.compressParam.setCompressionMode(2);
                }
                ((Property)serializable).setAt(this.compressParam);
            }
            ++n3;
        }
        if (this.maxPixelValueError >= 0) {
            serializable = ImageReaderFactory.getImageReaderParam(string);
            if (serializable == null) {
                throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + string);
            }
            this.verifier = ImageReaderFactory.getImageReader((ImageReaderFactory.ImageReaderParam)serializable);
            this.verifyParam = this.verifier.getDefaultReadParam();
            LOG.debug("Verifier: {}", (Object)this.verifier.getClass().getName());
        }
        this.decompress();
        return this.pixeldataProcessed;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.compressor != null) {
            this.compressor.dispose();
        }
        if (this.verifier != null) {
            this.verifier.dispose();
        }
    }

    private Property[] cat(Property[] propertyArray, Property[] propertyArray2) {
        if (propertyArray.length == 0) {
            return propertyArray2;
        }
        if (propertyArray2.length == 0) {
            return propertyArray;
        }
        Property[] propertyArray3 = new Property[propertyArray.length + propertyArray2.length];
        System.arraycopy(propertyArray, 0, propertyArray3, 0, propertyArray.length);
        System.arraycopy(propertyArray2, 0, propertyArray3, propertyArray.length, propertyArray2.length);
        return propertyArray3;
    }

    @Override
    protected void onPixelData(DicomInputStream dicomInputStream, Attributes attributes) throws IOException {
        dicomInputStream.tag();
        dicomInputStream.vr();
        int n = dicomInputStream.length();
        BufferedImage bufferedImage = null;
        this.imageParams = new ImageParams(this.dataset);
        if (this.decompressor != null) {
            this.imageParams.decompress(attributes, this.tsType);
        }
        if (this.decompressor == null || this.tsType == TransferSyntaxType.RLE) {
            bufferedImage = BufferedImageUtils.createBufferedImage(this.imageParams, this.compressTsType);
        }
        this.imageParams.compress(attributes, this.compressTsType);
        this.coerceAttributes.coerce(attributes).writeTo(this.out);
        attributes.clear();
        this.out.writeHeader(2145386512, VR.OB, -1);
        this.out.writeHeader(-73728, null, 0);
        if (n == -1) {
            if (!this.tsType.isPixeldataEncapsulated()) {
                throw new IOException("Unexpected encapsulated Pixel Data");
            }
            this.decompressFrames(dicomInputStream, this.imageParams, bufferedImage);
        } else {
            if (this.tsType.isPixeldataEncapsulated()) {
                throw new IOException("Pixel Data not encapsulated");
            }
            int n2 = n - this.imageParams.getLength();
            if (n2 < 0) {
                throw new IllegalArgumentException("Pixel data too short: " + n + " instead " + this.imageParams.getLength() + " bytes");
            }
            byte[] byArray = null;
            DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
            if (dataBuffer.getDataType() != 0) {
                byArray = new byte[this.imageParams.getFrameLength()];
            }
            int n3 = 0;
            while (n3 < this.imageParams.getFrames()) {
                this.readFrame(dicomInputStream, dataBuffer, byArray);
                this.writeFrame(bufferedImage);
                ++n3;
            }
            dicomInputStream.skipFully(n2);
        }
        this.out.writeHeader(-73507, null, 0);
        this.pixeldataProcessed = true;
    }

    private void readFrame(DicomInputStream dicomInputStream, DataBuffer dataBuffer, byte[] byArray) throws IOException {
        switch (dataBuffer.getDataType()) {
            case 0: {
                byte[][] byArray2;
                byte[][] byArray3 = byArray2 = ((DataBufferByte)dataBuffer).getBankData();
                int n = byArray2.length;
                int n2 = 0;
                while (n2 < n) {
                    byte[] byArray4 = byArray3[n2];
                    dicomInputStream.readFully(byArray4);
                    ++n2;
                }
                if (!dicomInputStream.bigEndian() || dicomInputStream.vr() != VR.OW) break;
                ByteUtils.swapShorts(byArray2);
                break;
            }
            case 1: {
                dicomInputStream.readFully(byArray);
                ByteUtils.bytesToShorts(byArray, 0, ((DataBufferUShort)dataBuffer).getData(), 0, byArray.length >> 1, dicomInputStream.bigEndian());
                break;
            }
            case 2: {
                dicomInputStream.readFully(byArray);
                ByteUtils.bytesToShorts(byArray, 0, ((DataBufferShort)dataBuffer).getData(), 0, byArray.length >> 1, dicomInputStream.bigEndian());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Datatype: " + dataBuffer.getDataType());
            }
        }
    }

    @Override
    protected void writeFrame(BufferedImage bufferedImage) throws IOException {
        if (this.imageParams.getBitsStored() < this.imageParams.getBitsAllocated()) {
            BufferedImageUtils.nullifyUnusedBits(this.imageParams.getBitsStored(), bufferedImage.getRaster().getDataBuffer());
        }
        MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(this.out){

            @Override
            public void flush() throws IOException {
                LOG.debug("Ignore invoke of MemoryCacheImageOutputStream.flush()");
            }
        };
        this.compressor.setOutput(this.compressPatchJPEGLS != null ? new PatchJPEGLSImageOutputStream(memoryCacheImageOutputStream, this.compressPatchJPEGLS) : memoryCacheImageOutputStream);
        long l = System.currentTimeMillis();
        this.compressor.write(null, new IIOImage(bufferedImage, null, null), this.compressParam);
        long l2 = System.currentTimeMillis();
        int n = (int)memoryCacheImageOutputStream.getStreamPosition();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Compressed frame #{} {}:1 in {} ms", new Object[]{this.frameIndex + 1, Float.valueOf((float)BufferedImageUtils.sizeOf(bufferedImage) / (float)n), l2 - l});
        }
        this.verify(memoryCacheImageOutputStream, bufferedImage);
        this.out.writeHeader(-73728, null, n + 1 & 0xFFFFFFFE);
        l = System.currentTimeMillis();
        memoryCacheImageOutputStream.close();
        if ((n & 1) != 0) {
            this.out.write(0);
        }
        l2 = System.currentTimeMillis();
        LOG.debug("Flushed frame #{} from memory in {} ms", (Object)(this.frameIndex + 1), (Object)(l - l2));
        ++this.frameIndex;
    }

    private void verify(ImageInputStream imageInputStream, BufferedImage bufferedImage) throws IOException {
        if (this.verifier == null) {
            return;
        }
        imageInputStream.seek(0L);
        this.verifier.setInput(imageInputStream);
        this.verifyParam.setDestination(this.bi2);
        long l = System.currentTimeMillis();
        this.bi2 = this.verifier.read(0, this.verifyParam);
        int n = BufferedImageUtils.maxDiff(bufferedImage.getRaster(), this.bi2.getRaster(), this.avgPixelValueBlockSize);
        long l2 = System.currentTimeMillis();
        LOG.debug("Verified compressed frame #{} in {} ms - max pixel value error: {}", new Object[]{this.frameIndex + 1, l2 - l, n});
        if (n > this.maxPixelValueError) {
            throw new CompressionVerificationException(n);
        }
    }
}

