/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.imageio.codec.BufferedImageUtils;
import org.dcm4che3.imageio.codec.CoerceAttributes;
import org.dcm4che3.imageio.codec.ImageParams;
import org.dcm4che3.imageio.codec.ImageReaderFactory;
import org.dcm4che3.imageio.codec.TransferSyntaxType;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLS;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLSImageInputStream;
import org.dcm4che3.imageio.stream.SegmentedImageInputStream;
import org.dcm4che3.io.DicomInputHandler;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamDecompressor
implements CoerceAttributes {
    private static final Logger LOG = LoggerFactory.getLogger(StreamDecompressor.class);
    protected final DicomInputStream in;
    protected final DicomOutputStream out;
    protected final String tsuid;
    protected final TransferSyntaxType tsType;
    protected final Attributes dataset;
    protected ImageReader decompressor;
    protected PatchJPEGLS patchJPEGLS;
    protected boolean pixeldataProcessed;
    protected CoerceAttributes coerceAttributes = this;
    private final DicomInputHandler handler = new DicomInputHandler(){

        @Override
        public void readValue(DicomInputStream dicomInputStream, Attributes attributes) throws IOException {
            if (dicomInputStream.tag() == 2145386512 && dicomInputStream.level() == 0) {
                StreamDecompressor.this.onPixelData(dicomInputStream, attributes);
            } else {
                dicomInputStream.readValue(dicomInputStream, attributes);
            }
        }

        @Override
        public void readValue(DicomInputStream dicomInputStream, Sequence sequence) throws IOException {
            dicomInputStream.readValue(dicomInputStream, sequence);
        }

        @Override
        public void readValue(DicomInputStream dicomInputStream, Fragments fragments) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void startDataset(DicomInputStream dicomInputStream) throws IOException {
        }

        @Override
        public void endDataset(DicomInputStream dicomInputStream) throws IOException {
        }
    };

    public StreamDecompressor(DicomInputStream dicomInputStream, String string, DicomOutputStream dicomOutputStream) {
        this.in = dicomInputStream;
        this.out = dicomOutputStream;
        this.tsuid = string;
        this.tsType = TransferSyntaxType.forUID(string);
        if (this.tsType == null) {
            throw new IllegalArgumentException("Unknown Transfer Syntax: " + string);
        }
        if (this.tsType.isPixeldataEncapsulated()) {
            ImageReaderFactory.ImageReaderParam imageReaderParam = ImageReaderFactory.getImageReaderParam(string);
            if (imageReaderParam == null) {
                throw new IllegalArgumentException("Unsupported Transfer Syntax: " + string);
            }
            this.decompressor = ImageReaderFactory.getImageReader(imageReaderParam);
            LOG.debug("Decompressor: {}", (Object)this.decompressor.getClass().getName());
            this.patchJPEGLS = imageReaderParam.getPatchJPEGLS();
        }
        this.dataset = new Attributes(dicomInputStream.bigEndian(), 64);
    }

    public CoerceAttributes getCoerceAttributes() {
        return this.coerceAttributes;
    }

    public void setCoerceAttributes(CoerceAttributes coerceAttributes) {
        if (coerceAttributes == null) {
            throw new NullPointerException();
        }
        this.coerceAttributes = coerceAttributes;
    }

    @Override
    public Attributes coerce(Attributes attributes) {
        return attributes;
    }

    public boolean decompress() throws IOException {
        this.in.setDicomInputHandler(this.handler);
        this.in.readAttributes(this.dataset, -1, -1);
        (this.pixeldataProcessed ? this.dataset : this.coerceAttributes.coerce(this.dataset)).writeTo(this.out);
        return this.pixeldataProcessed && this.decompressor != null;
    }

    public void dispose() {
        if (this.decompressor != null) {
            this.decompressor.dispose();
        }
    }

    protected void onPixelData(DicomInputStream dicomInputStream, Attributes attributes) throws IOException {
        int n = dicomInputStream.tag();
        VR vR = dicomInputStream.vr();
        int n2 = dicomInputStream.length();
        if (n2 == -1) {
            if (!this.tsType.isPixeldataEncapsulated()) {
                throw new IOException("Unexpected encapsulated Pixel Data");
            }
            BufferedImage bufferedImage = null;
            ImageParams imageParams = new ImageParams(this.dataset);
            imageParams.decompress(attributes, this.tsType);
            if (this.tsType == TransferSyntaxType.RLE) {
                bufferedImage = BufferedImageUtils.createBufferedImage(imageParams, null);
            }
            this.coerceAttributes.coerce(attributes).writeTo(this.out);
            attributes.clear();
            this.out.writeHeader(2145386512, VR.OW, imageParams.getEncodedLength());
            this.decompressFrames(dicomInputStream, imageParams, bufferedImage);
            if (imageParams.paddingNull()) {
                this.out.write(0);
            }
        } else {
            if (this.tsType.isPixeldataEncapsulated()) {
                throw new IOException("Pixel Data not encapsulated");
            }
            this.coerceAttributes.coerce(attributes).writeTo(this.out);
            attributes.clear();
            this.out.writeHeader(n, vR, n2);
            StreamUtils.copy((InputStream)dicomInputStream, (OutputStream)this.out, n2);
        }
        this.pixeldataProcessed = true;
    }

    protected void decompressFrames(DicomInputStream dicomInputStream, ImageParams imageParams, BufferedImage bufferedImage) throws IOException {
        dicomInputStream.readHeader();
        dicomInputStream.skipFully(dicomInputStream.length());
        long l = dicomInputStream.getPosition();
        MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(dicomInputStream);
        byte[] byArray = new byte[8];
        boolean bl = imageParams.getFrames() == 1;
        int n = 0;
        while (n < imageParams.getFrames()) {
            memoryCacheImageInputStream.readFully(byArray);
            SegmentedImageInputStream segmentedImageInputStream = new SegmentedImageInputStream(memoryCacheImageInputStream, memoryCacheImageInputStream.getStreamPosition(), ByteUtils.bytesToIntLE(byArray, 4), bl);
            this.decompressor.setInput(this.patchJPEGLS != null ? new PatchJPEGLSImageInputStream(segmentedImageInputStream, this.patchJPEGLS) : segmentedImageInputStream);
            ImageReadParam imageReadParam = this.decompressor.getDefaultReadParam();
            imageReadParam.setDestination(bufferedImage);
            long l2 = System.currentTimeMillis();
            bufferedImage = this.decompressor.read(0, imageReadParam);
            long l3 = segmentedImageInputStream.getLastSegmentEnd();
            memoryCacheImageInputStream.seek(l3);
            memoryCacheImageInputStream.flushBefore(l3);
            long l4 = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Decompressed frame #{} 1:{} in {} ms", new Object[]{n + 1, Float.valueOf((float)BufferedImageUtils.sizeOf(bufferedImage) / (float)segmentedImageInputStream.getStreamPosition()), l4 - l2});
            }
            this.writeFrame(bufferedImage);
            ++n;
        }
        memoryCacheImageInputStream.readFully(byArray);
        dicomInputStream.setPosition(l + memoryCacheImageInputStream.getStreamPosition());
    }

    protected void writeFrame(BufferedImage bufferedImage) throws IOException {
        BufferedImageUtils.writeTo(bufferedImage, this.out);
    }
}

