/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.plugins.dcm;

import java.awt.Transparency;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.image.LookupTable;
import org.dcm4che3.image.LookupTableFactory;
import org.dcm4che3.image.Overlays;
import org.dcm4che3.image.PhotometricInterpretation;
import org.dcm4che3.image.StoredValue;
import org.dcm4che3.imageio.codec.ImageReaderFactory;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLS;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLSImageInputStream;
import org.dcm4che3.imageio.plugins.dcm.DicomImageReadParam;
import org.dcm4che3.imageio.plugins.dcm.DicomMetaData;
import org.dcm4che3.imageio.stream.ImageInputStreamAdapter;
import org.dcm4che3.imageio.stream.SegmentedImageInputStream;
import org.dcm4che3.io.BulkDataDescriptor;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.util.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DicomImageReader
extends ImageReader {
    private static final Logger LOG = LoggerFactory.getLogger(DicomImageReader.class);
    private ImageInputStream iis;
    private Attributes ds;
    private DicomMetaData metadata;
    private int frames;
    private int width;
    private int height;
    private BulkData pixeldata;
    private final VR.Holder pixeldataVR = new VR.Holder();
    private Fragments pixeldataFragments;
    private File pixeldataFile;
    private ImageReader decompressor;
    private boolean rle;
    private PatchJPEGLS patchJpegLS;
    private int samples;
    private boolean banded;
    private int bitsStored;
    private int bitsAllocated;
    private int dataType;
    private int frameLength;
    private PhotometricInterpretation pmi;

    public DicomImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        this.resetInternalState();
        if (object instanceof DicomMetaData) {
            this.setMetadata((DicomMetaData)object);
            if (this.pixeldata != null) {
                this.pixeldataFile = this.pixeldata.getFile();
            } else if (this.pixeldataFragments != null && this.pixeldataFragments.size() > 1) {
                this.pixeldataFile = ((BulkData)this.pixeldataFragments.get(1)).getFile();
            }
        } else {
            this.iis = (ImageInputStream)object;
        }
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        this.readMetadata();
        return this.frames;
    }

    @Override
    public int getWidth(int n) throws IOException {
        this.readMetadata();
        this.checkIndex(n);
        return this.width;
    }

    @Override
    public int getHeight(int n) throws IOException {
        this.readMetadata();
        this.checkIndex(n);
        return this.height;
    }

    @Override
    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        this.readMetadata();
        this.checkIndex(n);
        if (this.decompressor == null) {
            return this.createImageType(this.bitsStored, this.dataType, this.banded);
        }
        if (this.rle) {
            return this.createImageType(this.bitsStored, this.dataType, true);
        }
        this.openiis();
        try {
            this.decompressor.setInput(this.iisOfFrame(0));
            ImageTypeSpecifier imageTypeSpecifier = this.decompressor.getRawImageType(0);
            return imageTypeSpecifier;
        }
        finally {
            this.closeiis();
        }
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier;
        this.readMetadata();
        this.checkIndex(n);
        if (this.pmi.isMonochrome()) {
            imageTypeSpecifier = this.createImageType(8, 0, false);
        } else if (this.decompressor == null) {
            imageTypeSpecifier = this.createImageType(this.bitsStored, this.dataType, this.banded);
        } else if (this.rle) {
            imageTypeSpecifier = this.createImageType(this.bitsStored, this.dataType, true);
        } else {
            this.openiis();
            try {
                this.decompressor.setInput(this.iisOfFrame(0));
                Iterator<ImageTypeSpecifier> iterator = this.decompressor.getImageTypes(0);
                return iterator;
            }
            finally {
                this.closeiis();
            }
        }
        return Collections.singletonList(imageTypeSpecifier).iterator();
    }

    private void openiis() throws FileNotFoundException, IOException {
        if (this.pixeldataFile != null && this.iis == null) {
            this.iis = new FileImageInputStream(this.pixeldataFile);
        }
    }

    private void closeiis() throws IOException {
        if (this.pixeldataFile != null && this.iis != null) {
            this.iis.close();
            this.iis = null;
        }
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new DicomImageReadParam();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        this.readMetadata();
        return this.metadata;
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        return null;
    }

    @Override
    public boolean canReadRaster() {
        return true;
    }

    @Override
    public Raster readRaster(int n, ImageReadParam imageReadParam) throws IOException {
        this.readMetadata();
        this.checkIndex(n);
        this.openiis();
        try {
            if (this.decompressor != null) {
                WritableRaster writableRaster;
                this.decompressor.setInput(this.iisOfFrame(n));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Start decompressing frame #" + (n + 1));
                }
                Raster raster = writableRaster = this.pmi.decompress() == this.pmi && this.decompressor.canReadRaster() ? this.decompressor.readRaster(0, this.decompressParam(imageReadParam)) : this.decompressor.read(0, this.decompressParam(imageReadParam)).getRaster();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Finished decompressing frame #" + (n + 1));
                }
                WritableRaster writableRaster2 = writableRaster;
                return writableRaster2;
            }
            this.iis.setByteOrder(this.ds.bigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            this.iis.seek(this.pixeldata.offset() + (long)(n * this.frameLength));
            WritableRaster writableRaster = Raster.createWritableRaster(this.createSampleModel(this.dataType, this.banded), null);
            DataBuffer dataBuffer = writableRaster.getDataBuffer();
            if (dataBuffer instanceof DataBufferByte) {
                byte[][] byArray;
                byte[][] byArray2 = byArray = ((DataBufferByte)dataBuffer).getBankData();
                int n2 = byArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    byte[] byArray3 = byArray2[n3];
                    this.iis.readFully(byArray3);
                    ++n3;
                }
                if (this.pixeldata.bigEndian && this.pixeldataVR.vr == VR.OW) {
                    ByteUtils.swapShorts(byArray);
                }
            } else {
                short[] sArray = ((DataBufferUShort)dataBuffer).getData();
                this.iis.readFully(sArray, 0, sArray.length);
            }
            WritableRaster writableRaster3 = writableRaster;
            return writableRaster3;
        }
        finally {
            this.closeiis();
        }
    }

    private ImageReadParam decompressParam(ImageReadParam imageReadParam) {
        ImageReadParam imageReadParam2 = this.decompressor.getDefaultReadParam();
        ImageTypeSpecifier imageTypeSpecifier = null;
        BufferedImage bufferedImage = null;
        if (imageReadParam != null) {
            imageTypeSpecifier = imageReadParam.getDestinationType();
            bufferedImage = imageReadParam.getDestination();
        }
        if (this.rle && imageTypeSpecifier == null && bufferedImage == null) {
            imageTypeSpecifier = this.createImageType(this.bitsStored, this.dataType, true);
        }
        imageReadParam2.setDestinationType(imageTypeSpecifier);
        imageReadParam2.setDestination(bufferedImage);
        return imageReadParam2;
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        WritableRaster writableRaster;
        Transparency transparency;
        this.readMetadata();
        this.checkIndex(n);
        if (this.decompressor != null) {
            this.openiis();
            try {
                this.decompressor.setInput(this.iisOfFrame(n));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Start decompressing frame #" + (n + 1));
                }
                transparency = this.decompressor.read(0, this.decompressParam(imageReadParam));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Finished decompressing frame #" + (n + 1));
                }
                if (this.samples > 1) {
                    Transparency transparency2 = transparency;
                    return transparency2;
                }
                writableRaster = ((BufferedImage)transparency).getRaster();
            }
            finally {
                this.closeiis();
            }
        } else {
            writableRaster = (WritableRaster)this.readRaster(n, imageReadParam);
        }
        if (this.pmi.isMonochrome()) {
            int[] nArray = this.getActiveOverlayGroupOffsets(imageReadParam);
            byte[][] byArrayArray = new byte[nArray.length][];
            int n2 = 0;
            while (n2 < nArray.length) {
                byArrayArray[n2] = this.extractOverlay(nArray[n2], writableRaster);
                ++n2;
            }
            transparency = this.createColorModel(8, 0);
            SampleModel sampleModel = this.createSampleModel(0, false);
            writableRaster = this.applyLUTs(writableRaster, n, imageReadParam, sampleModel, 8);
            int n3 = 0;
            while (n3 < nArray.length) {
                this.applyOverlay(nArray[n3], writableRaster, n, imageReadParam, 8, byArrayArray[n3]);
                ++n3;
            }
        } else {
            transparency = this.createColorModel(this.bitsStored, this.dataType);
        }
        return new BufferedImage((ColorModel)transparency, writableRaster, false, null);
    }

    private byte[] extractOverlay(int n, WritableRaster writableRaster) {
        Attributes attributes = this.metadata.getAttributes();
        if (attributes.getInt(0x60000100 | n, 1) == 1) {
            return null;
        }
        int n2 = attributes.getInt(0x60000010 | n, 0);
        int n3 = attributes.getInt(0x60000011 | n, 0);
        int n4 = attributes.getInt(0x60000102 | n, 0);
        int n5 = 1 << n4;
        int n6 = n2 * n3;
        byte[] byArray = new byte[(n6 + 7 >>> 3) + 1 & 0xFFFFFFFE];
        Overlays.extractFromPixeldata(writableRaster, n5, byArray, 0, n6);
        return byArray;
    }

    private ImageInputStreamImpl iisOfFrame(int n) throws IOException {
        SegmentedImageInputStream segmentedImageInputStream = SegmentedImageInputStream.ofFrame(this.iis, this.pixeldataFragments, n, this.frames);
        return this.patchJpegLS != null ? new PatchJPEGLSImageInputStream(segmentedImageInputStream, this.patchJpegLS) : segmentedImageInputStream;
    }

    private void applyOverlay(int n, WritableRaster writableRaster, int n2, ImageReadParam imageReadParam, int n3, byte[] byArray) {
        Attributes attributes = this.metadata.getAttributes();
        int n4 = 65535;
        if (imageReadParam instanceof DicomImageReadParam) {
            DicomImageReadParam dicomImageReadParam = (DicomImageReadParam)imageReadParam;
            Attributes attributes2 = dicomImageReadParam.getPresentationState();
            if (attributes2 != null) {
                if (attributes2.containsValue(0x60003000 | n)) {
                    attributes = attributes2;
                }
                n4 = Overlays.getRecommendedDisplayGrayscaleValue(attributes2, n);
            } else {
                n4 = dicomImageReadParam.getOverlayGrayscaleValue();
            }
        }
        Overlays.applyOverlay(byArray != null ? 0 : n2, writableRaster, attributes, n, n4 >>> 16 - n3, byArray);
    }

    private int[] getActiveOverlayGroupOffsets(ImageReadParam imageReadParam) {
        if (imageReadParam instanceof DicomImageReadParam) {
            DicomImageReadParam dicomImageReadParam = (DicomImageReadParam)imageReadParam;
            Attributes attributes = dicomImageReadParam.getPresentationState();
            if (attributes != null) {
                return Overlays.getActiveOverlayGroupOffsets(attributes);
            }
            return Overlays.getActiveOverlayGroupOffsets(this.metadata.getAttributes(), dicomImageReadParam.getOverlayActivationMask());
        }
        return Overlays.getActiveOverlayGroupOffsets(this.metadata.getAttributes(), 65535);
    }

    private WritableRaster applyLUTs(WritableRaster writableRaster, int n, ImageReadParam imageReadParam, SampleModel sampleModel, int n2) {
        Object object;
        WritableRaster writableRaster2 = sampleModel.getDataType() == writableRaster.getSampleModel().getDataType() ? writableRaster : Raster.createWritableRaster(sampleModel, null);
        Attributes attributes = this.metadata.getAttributes();
        StoredValue storedValue = StoredValue.valueOf(attributes);
        LookupTableFactory lookupTableFactory = new LookupTableFactory(storedValue);
        DicomImageReadParam dicomImageReadParam = imageReadParam instanceof DicomImageReadParam ? (DicomImageReadParam)imageReadParam : new DicomImageReadParam();
        Attributes attributes2 = dicomImageReadParam.getPresentationState();
        if (attributes2 != null) {
            lookupTableFactory.setModalityLUT(attributes2);
            lookupTableFactory.setVOI(this.selectVOILUT(attributes2, attributes.getString(524312), n + 1), 0, 0, false);
            lookupTableFactory.setPresentationLUT(attributes2);
        } else {
            object = attributes.getNestedDataset(1375769129);
            Attributes attributes3 = attributes.getNestedDataset(1375769136, n);
            lookupTableFactory.setModalityLUT(this.selectFctGroup(attributes, (Attributes)object, attributes3, 2658629));
            if (dicomImageReadParam.getWindowWidth() != 0.0f) {
                lookupTableFactory.setWindowCenter(dicomImageReadParam.getWindowCenter());
                lookupTableFactory.setWindowWidth(dicomImageReadParam.getWindowWidth());
            } else {
                lookupTableFactory.setVOI(this.selectFctGroup(attributes, (Attributes)object, attributes3, 2658610), dicomImageReadParam.getWindowIndex(), dicomImageReadParam.getVOILUTIndex(), dicomImageReadParam.isPreferWindow());
            }
            if (dicomImageReadParam.isAutoWindowing()) {
                lookupTableFactory.autoWindowing(attributes, writableRaster);
            }
            lookupTableFactory.setPresentationLUT(attributes);
        }
        object = lookupTableFactory.createLUT(n2);
        ((LookupTable)object).lookup(writableRaster, writableRaster2);
        return writableRaster2;
    }

    private Attributes selectFctGroup(Attributes attributes, Attributes attributes2, Attributes attributes3, int n) {
        if (attributes3 == null) {
            return attributes;
        }
        Attributes attributes4 = attributes3.getNestedDataset(n);
        if (attributes4 == null && attributes2 != null) {
            attributes4 = attributes2.getNestedDataset(n);
        }
        return attributes4 != null ? attributes4 : attributes;
    }

    private Attributes selectVOILUT(Attributes attributes, String string, int n) {
        Sequence sequence = attributes.getSequence(2634000);
        if (sequence != null) {
            for (Attributes attributes2 : sequence) {
                Sequence sequence2 = attributes2.getSequence(528704);
                if (sequence2 == null || sequence2.isEmpty()) {
                    return attributes2;
                }
                for (Attributes attributes3 : sequence2) {
                    if (!string.equals(attributes3.getString(528725))) continue;
                    int[] nArray = attributes3.getInts(528736);
                    if (nArray == null) {
                        return attributes2;
                    }
                    int[] nArray2 = nArray;
                    int n2 = nArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        int n4 = nArray2[n3];
                        if (n4 == n) {
                            return attributes2;
                        }
                        ++n3;
                    }
                }
            }
        }
        return null;
    }

    private void readMetadata() throws IOException {
        if (this.metadata != null) {
            return;
        }
        if (this.iis == null) {
            throw new IllegalStateException("Input not set");
        }
        DicomInputStream dicomInputStream = new DicomInputStream(new ImageInputStreamAdapter(this.iis));
        dicomInputStream.setIncludeBulkData(DicomInputStream.IncludeBulkData.URI);
        dicomInputStream.setBulkDataDescriptor(BulkDataDescriptor.PIXELDATA);
        dicomInputStream.setURI("java:iis");
        Attributes attributes = dicomInputStream.readFileMetaInformation();
        Attributes attributes2 = dicomInputStream.readDataset(-1, -1);
        this.setMetadata(new DicomMetaData(attributes, attributes2));
    }

    private void setMetadata(DicomMetaData dicomMetaData) {
        this.metadata = dicomMetaData;
        this.ds = dicomMetaData.getAttributes();
        Object object = this.ds.getValue(2145386512, this.pixeldataVR);
        if (object != null) {
            this.frames = this.ds.getInt(0x280008, 1);
            this.width = this.ds.getInt(2621457, 0);
            this.height = this.ds.getInt(2621456, 0);
            this.samples = this.ds.getInt(0x280002, 1);
            this.banded = this.samples > 1 && this.ds.getInt(2621446, 0) != 0;
            this.bitsAllocated = this.ds.getInt(2621696, 8);
            this.bitsStored = this.ds.getInt(2621697, this.bitsAllocated);
            this.dataType = this.bitsAllocated <= 8 ? 0 : 1;
            this.pmi = PhotometricInterpretation.fromString(this.ds.getString(2621444, "MONOCHROME2"));
            if (object instanceof BulkData) {
                this.frameLength = this.pmi.frameLength(this.width, this.height, this.samples, this.bitsAllocated);
                this.pixeldata = (BulkData)object;
            } else {
                Attributes attributes = dicomMetaData.getFileMetaInformation();
                if (attributes == null) {
                    throw new IllegalArgumentException("Missing File Meta Information for Data Set with compressed Pixel Data");
                }
                String string = attributes.getString(131088);
                ImageReaderFactory.ImageReaderParam imageReaderParam = ImageReaderFactory.getImageReaderParam(string);
                if (imageReaderParam == null) {
                    throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + string);
                }
                this.rle = string.equals("1.2.840.10008.1.2.5");
                this.decompressor = ImageReaderFactory.getImageReader(imageReaderParam);
                this.patchJpegLS = imageReaderParam.patchJPEGLS;
                this.pixeldataFragments = (Fragments)object;
            }
        }
    }

    private SampleModel createSampleModel(int n, boolean bl) {
        return this.pmi.createSampleModel(n, this.width, this.height, this.samples, bl);
    }

    private ImageTypeSpecifier createImageType(int n, int n2, boolean bl) {
        return new ImageTypeSpecifier(this.createColorModel(n, n2), this.createSampleModel(n2, bl));
    }

    private ColorModel createColorModel(int n, int n2) {
        return this.pmi.createColorModel(n, n2, this.metadata.getAttributes());
    }

    private void resetInternalState() {
        this.metadata = null;
        this.ds = null;
        this.pixeldataFile = null;
        this.frames = 0;
        this.width = 0;
        this.height = 0;
        this.pixeldata = null;
        this.pixeldataFragments = null;
        if (this.decompressor != null) {
            this.decompressor.dispose();
            this.decompressor = null;
        }
        this.patchJpegLS = null;
        this.pmi = null;
    }

    private void checkIndex(int n) {
        if (this.frames == 0) {
            throw new IllegalStateException("Missing Pixel Data");
        }
        if (n < 0 || n >= this.frames) {
            throw new IndexOutOfBoundsException("imageIndex: " + n);
        }
    }

    @Override
    public void dispose() {
        this.resetInternalState();
    }
}

