/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.plugins.dcm;

import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che3.data.Implementation;
import org.dcm4che3.imageio.plugins.dcm.DicomImageReader;
import org.dcm4che3.imageio.plugins.dcm.DicomMetaData;

public class DicomImageReaderSpi
extends ImageReaderSpi {
    private static final String vendorName = "org.dcm4che";
    private static final String version = Implementation.getVersionName();
    private static final String[] formatNames = new String[]{"dicom", "DICOM"};
    private static final String[] suffixes = new String[]{"dcm", "dic", "dicm", "dicom"};
    private static final String[] MIMETypes = new String[]{"application/dicom"};
    private static final Class<?>[] inputTypes = new Class[]{ImageInputStream.class, DicomMetaData.class};

    public DicomImageReaderSpi() {
        super(vendorName, version, formatNames, suffixes, MIMETypes, DicomImageReader.class.getName(), inputTypes, null, false, null, null, null, null, false, null, null, null, null);
    }

    @Override
    public String getDescription(Locale locale) {
        return "DICOM Image Reader";
    }

    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        try {
            int n = imageInputStream.read() | imageInputStream.read() << 8 | imageInputStream.read() << 16 | imageInputStream.read() << 24;
            boolean bl = n >= 524288 && n <= 524310 || imageInputStream.skipBytes(124) == 124 && imageInputStream.read() == 68 && imageInputStream.read() == 73 && imageInputStream.read() == 67 && imageInputStream.read() == 77;
            return bl;
        }
        finally {
            imageInputStream.reset();
        }
    }

    @Override
    public ImageReader createReaderInstance(Object object) throws IOException {
        return new DicomImageReader(this);
    }
}

