/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.stream;

import java.io.IOException;
import java.util.Arrays;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.util.ByteUtils;

public class SegmentedImageInputStream
extends ImageInputStreamImpl {
    private final ImageInputStream stream;
    private final boolean autoExtend;
    private long[] segmentPositionsList;
    private int[] segmentLengths;
    private int curSegment;
    private long curSegmentEnd;
    private byte[] header = new byte[8];

    public SegmentedImageInputStream(ImageInputStream imageInputStream, long[] lArray, int[] nArray) throws IOException {
        this.stream = imageInputStream;
        this.segmentPositionsList = (long[])lArray.clone();
        this.segmentLengths = (int[])nArray.clone();
        this.autoExtend = false;
        this.seek(0L);
    }

    public SegmentedImageInputStream(ImageInputStream imageInputStream, long l, int n, boolean bl) throws IOException {
        this.stream = imageInputStream;
        this.segmentPositionsList = new long[]{l};
        this.segmentLengths = new int[]{n};
        this.autoExtend = bl;
        this.seek(0L);
    }

    public static SegmentedImageInputStream ofFrame(ImageInputStream imageInputStream, Fragments fragments, int n, int n2) throws IOException {
        if (n2 > 1) {
            if (fragments.size() != n2 + 1) {
                throw new UnsupportedOperationException("Number of Fragments [" + fragments.size() + "] != Number of Frames [" + n2 + "] + 1");
            }
            BulkData bulkData = (BulkData)fragments.get(n + 1);
            return new SegmentedImageInputStream(imageInputStream, bulkData.offset(), bulkData.length(), false);
        }
        int n3 = fragments.size() - 1;
        long[] lArray = new long[n3];
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            BulkData bulkData = (BulkData)fragments.get(n4 + 1);
            lArray[n4] = bulkData.offset();
            nArray[n4] = bulkData.length();
            ++n4;
        }
        return new SegmentedImageInputStream(imageInputStream, lArray, nArray);
    }

    public long getLastSegmentEnd() {
        int n = this.segmentPositionsList.length - 1;
        return this.segmentPositionsList[n] + (long)this.segmentLengths[n];
    }

    private int offsetOf(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += this.segmentLengths[n3];
            ++n3;
        }
        return n2;
    }

    @Override
    public void seek(long l) throws IOException {
        super.seek(l);
        int n = 0;
        int n2 = 0;
        while (n < this.segmentLengths.length) {
            int n3 = n2 + this.segmentLengths[n];
            if (l < (long)n3) {
                this.stream.seek(this.segmentPositionsList[n] + l - (long)n2);
                this.curSegment = n;
                this.curSegmentEnd = n3;
                return;
            }
            n2 = n3;
            ++n;
        }
        this.curSegment = -1;
    }

    @Override
    public int read() throws IOException {
        if (!this.prepareRead()) {
            return -1;
        }
        this.bitOffset = 0;
        int n = this.stream.read();
        if (n != -1) {
            ++this.streamPos;
        }
        return n;
    }

    private boolean prepareRead() throws IOException {
        if (this.curSegment < 0) {
            return false;
        }
        if (this.streamPos < this.curSegmentEnd) {
            return true;
        }
        if (this.curSegment + 1 >= this.segmentPositionsList.length) {
            if (!this.autoExtend) {
                return false;
            }
            this.stream.mark();
            this.stream.readFully(this.header);
            this.stream.reset();
            if (ByteUtils.bytesToTagLE(this.header, 0) != -73728) {
                return false;
            }
            this.addSegment(this.getLastSegmentEnd() + 8L, ByteUtils.bytesToIntLE(this.header, 4));
        }
        this.seek(this.offsetOf(this.curSegment + 1));
        return true;
    }

    private void addSegment(long l, int n) {
        int n2 = this.segmentPositionsList.length;
        this.segmentPositionsList = Arrays.copyOf(this.segmentPositionsList, n2 + 1);
        this.segmentLengths = Arrays.copyOf(this.segmentLengths, n2 + 1);
        this.segmentPositionsList[n2] = l;
        this.segmentLengths[n2] = n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.prepareRead()) {
            return -1;
        }
        this.bitOffset = 0;
        int n3 = this.stream.read(byArray, n, Math.min(n2, (int)(this.curSegmentEnd - this.streamPos)));
        if (n3 != -1) {
            this.streamPos += (long)n3;
        }
        return n3;
    }
}

