/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.io;

import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ItemPointer;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.TagUtils;

public abstract class BulkDataDescriptor {
    public static final BulkDataDescriptor DEFAULT = new BulkDataDescriptor(){

        @Override
        public boolean isBulkData(String string, int n, VR vR, int n2, ItemPointer ... itemPointerArray) {
            switch (TagUtils.normalizeRepeatingGroup(n)) {
                case 2654176: 
                case 4325393: 
                case 1342185484: 
                case 0x50003000: 
                case 1442840608: 
                case 0x60003000: 
                case 2145386512: {
                    return itemPointerArray.length == 0;
                }
                case 1409290256: {
                    return itemPointerArray.length == 1 && itemPointerArray[0].sequenceTag == 1409286400;
                }
            }
            return false;
        }
    };
    public static final BulkDataDescriptor PIXELDATA = new BulkDataDescriptor(){

        @Override
        public boolean isBulkData(String string, int n, VR vR, int n2, ItemPointer ... itemPointerArray) {
            return n == 2145386512;
        }
    };

    public static BulkDataDescriptor valueOf(final Attributes attributes) {
        return new BulkDataDescriptor(){

            @Override
            public boolean isBulkData(String string, int n, VR vR, int n2, ItemPointer ... itemPointerArray) {
                Attributes attributes2 = attributes;
                ItemPointer[] itemPointerArray2 = itemPointerArray;
                int n3 = itemPointerArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ItemPointer itemPointer = itemPointerArray2[n4];
                    attributes2 = attributes2.getNestedDataset(itemPointer.privateCreator, itemPointer.sequenceTag, itemPointer.itemIndex);
                    ++n4;
                }
                return attributes2 != null && attributes2.contains(string, n);
            }
        };
    }

    public abstract boolean isBulkData(String var1, int var2, VR var3, int var4, ItemPointer ... var5);
}

