/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.io;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.ItemPointer;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.BulkDataDescriptor;
import org.dcm4che3.io.DicomInputHandler;
import org.dcm4che3.io.DicomStreamException;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StreamUtils;
import org.dcm4che3.util.TagUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DicomInputStream
extends FilterInputStream
implements DicomInputHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DicomInputStream.class);
    private static final String UNEXPECTED_NON_ZERO_ITEM_LENGTH = "Unexpected item value of {} #{} @ {}";
    private static final String UNEXPECTED_ATTRIBUTE = "Unexpected attribute {} #{} @ {}";
    private static final String MISSING_TRANSFER_SYNTAX = "Missing Transfer Syntax (0002,0010) - assume Explicit VR Little Endian";
    private static final String MISSING_FMI_LENGTH = "Missing or wrong File Meta Information Group Length (0002,0000)";
    private static final String NOT_A_DICOM_STREAM = "Not a DICOM Stream";
    private static final String IMPLICIT_VR_BIG_ENDIAN = "Implicit VR Big Endian encoded DICOM Stream";
    private static final String DEFLATED_WITH_ZLIB_HEADER = "Deflated DICOM Stream with ZLIB Header";
    private static final int ZLIB_HEADER = 30876;
    private static final int DEF_ALLOCATE_LIMIT = 0x4000000;
    private int allocateLimit = 0x4000000;
    private String uri;
    private String tsuid;
    private byte[] preamble;
    private Attributes fileMetaInformation;
    private boolean hasfmi;
    private boolean bigEndian;
    private boolean explicitVR;
    private IncludeBulkData includeBulkData = IncludeBulkData.YES;
    private IncludeBulkData includeFragmentBulkData;
    private long pos;
    private long fmiEndPos = -1L;
    private long tagPos;
    private long markPos;
    private int tag;
    private VR vr;
    private int length;
    private DicomInputHandler handler = this;
    private BulkDataDescriptor bulkDataDescriptor = BulkDataDescriptor.DEFAULT;
    private final byte[] buffer = new byte[12];
    private ItemPointer[] itemPointers = new ItemPointer[0];
    private boolean decodeUNWithIVRLE = true;
    private boolean addBulkDataReferences;
    private boolean catBlkFiles = true;
    private String blkFilePrefix = "blk";
    private String blkFileSuffix;
    private File blkDirectory;
    private ArrayList<File> blkFiles;
    private String blkURI;
    private FileOutputStream blkOut;
    private long blkOutPos;

    public DicomInputStream(InputStream inputStream, String string) throws IOException {
        super(inputStream);
        this.switchTransferSyntax(string);
    }

    public DicomInputStream(InputStream inputStream) throws IOException {
        super(inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream));
        this.guessTransferSyntax();
    }

    public DicomInputStream(File file) throws IOException {
        this(new FileInputStream(file));
        this.uri = file.toURI().toString();
    }

    public final String getTransferSyntax() {
        return this.tsuid;
    }

    public final int getAllocateLimit() {
        return this.allocateLimit;
    }

    public final void setAllocateLimit(int n) {
        this.allocateLimit = n;
    }

    public final String getURI() {
        return this.uri;
    }

    public final void setURI(String string) {
        this.uri = string;
    }

    public final IncludeBulkData getIncludeBulkData() {
        return this.includeBulkData;
    }

    public final void setIncludeBulkData(IncludeBulkData includeBulkData) {
        if (includeBulkData == null) {
            throw new NullPointerException();
        }
        this.includeBulkData = includeBulkData;
    }

    public final IncludeBulkData getIncludeFragmentBulkData() {
        return this.includeFragmentBulkData;
    }

    public final BulkDataDescriptor getBulkDataDescriptor() {
        return this.bulkDataDescriptor;
    }

    public final void setBulkDataDescriptor(BulkDataDescriptor bulkDataDescriptor) {
        this.bulkDataDescriptor = bulkDataDescriptor;
    }

    public final String getBulkDataFilePrefix() {
        return this.blkFilePrefix;
    }

    public final void setBulkDataFilePrefix(String string) {
        this.blkFilePrefix = string;
    }

    public final String getBulkDataFileSuffix() {
        return this.blkFileSuffix;
    }

    public final void setBulkDataFileSuffix(String string) {
        this.blkFileSuffix = string;
    }

    public final File getBulkDataDirectory() {
        return this.blkDirectory;
    }

    public final void setBulkDataDirectory(File file) {
        this.blkDirectory = file;
    }

    public final boolean isConcatenateBulkDataFiles() {
        return this.catBlkFiles;
    }

    public final void setConcatenateBulkDataFiles(boolean bl) {
        this.catBlkFiles = bl;
    }

    public final List<File> getBulkDataFiles() {
        if (this.blkFiles != null) {
            return this.blkFiles;
        }
        return Collections.emptyList();
    }

    public final void setDicomInputHandler(DicomInputHandler dicomInputHandler) {
        if (dicomInputHandler == null) {
            throw new NullPointerException("handler");
        }
        this.handler = dicomInputHandler;
    }

    public boolean isDecodeUNWithIVRLE() {
        return this.decodeUNWithIVRLE;
    }

    public void setDecodeUNWithIVRLE(boolean bl) {
        this.decodeUNWithIVRLE = bl;
    }

    public boolean isAddBulkDataReferences() {
        return this.addBulkDataReferences;
    }

    public void setAddBulkDataReferences(boolean bl) {
        this.addBulkDataReferences = bl;
    }

    public final void setFileMetaInformationGroupLength(byte[] byArray) {
        this.fmiEndPos = this.pos + (long)ByteUtils.bytesToInt(byArray, 0, this.bigEndian);
    }

    public final byte[] getPreamble() {
        return this.preamble;
    }

    public Attributes getFileMetaInformation() throws IOException {
        this.readFileMetaInformation();
        return this.fileMetaInformation;
    }

    public final int level() {
        return this.itemPointers.length;
    }

    public final int tag() {
        return this.tag;
    }

    public final VR vr() {
        return this.vr;
    }

    public final int length() {
        return this.length;
    }

    public final long getPosition() {
        return this.pos;
    }

    public void setPosition(long l) {
        this.pos = l;
    }

    public long getTagPosition() {
        return this.tagPos;
    }

    public final boolean bigEndian() {
        return this.bigEndian;
    }

    public final boolean explicitVR() {
        return this.explicitVR;
    }

    @Override
    public void close() throws IOException {
        SafeClose.close(this.blkOut);
        super.close();
    }

    @Override
    public synchronized void mark(int n) {
        super.mark(n);
        this.markPos = this.pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.pos = this.markPos;
    }

    @Override
    public final int read() throws IOException {
        int n = super.read();
        if (n >= 0) {
            ++this.pos;
        }
        return n;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.pos += (long)n3;
        }
        return n3;
    }

    @Override
    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public final long skip(long l) throws IOException {
        long l2 = super.skip(l);
        this.pos += l2;
        return l2;
    }

    public void skipFully(long l) throws IOException {
        StreamUtils.skipFully(this, l);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        StreamUtils.readFully(this, byArray, n, n2);
    }

    public int readHeader() throws IOException {
        byte[] byArray = this.buffer;
        this.tagPos = this.pos;
        this.readFully(byArray, 0, 8);
        this.tag = ByteUtils.bytesToTag(byArray, 0, this.bigEndian);
        switch (this.tag) {
            case -73728: 
            case -73715: 
            case -73507: {
                this.vr = null;
                break;
            }
            default: {
                if (this.explicitVR) {
                    this.vr = VR.valueOf(ByteUtils.bytesToVR(byArray, 4));
                    if (this.vr.headerLength() == 8) {
                        this.length = ByteUtils.bytesToUShort(byArray, 6, this.bigEndian);
                        return this.tag;
                    }
                    this.readFully(byArray, 4, 4);
                    break;
                }
                this.vr = VR.UN;
            }
        }
        this.length = ByteUtils.bytesToInt(byArray, 4, this.bigEndian);
        return this.tag;
    }

    public Attributes readCommand() throws IOException {
        if (this.bigEndian || this.explicitVR) {
            throw new IllegalStateException("bigEndian=" + this.bigEndian + ", explicitVR=" + this.explicitVR);
        }
        Attributes attributes = new Attributes(9);
        this.readAttributes(attributes, -1, -1);
        return attributes;
    }

    public Attributes readDataset(int n, int n2) throws IOException {
        this.handler.startDataset(this);
        this.readFileMetaInformation();
        Attributes attributes = new Attributes(this.bigEndian, 64);
        this.readAttributes(attributes, n, n2);
        attributes.trimToSize();
        this.handler.endDataset(this);
        return attributes;
    }

    public Attributes readFileMetaInformation() throws IOException {
        if (!this.hasfmi) {
            return null;
        }
        if (this.fileMetaInformation != null) {
            return this.fileMetaInformation;
        }
        Attributes attributes = new Attributes(this.bigEndian, 9);
        while (this.pos != this.fmiEndPos) {
            this.mark(12);
            this.readHeader();
            if (TagUtils.groupNumber(this.tag) != 2) {
                LOG.warn(MISSING_FMI_LENGTH);
                this.reset();
                break;
            }
            if (this.vr != null) {
                if (this.vr == VR.UN) {
                    this.vr = ElementDictionary.getStandardElementDictionary().vrOf(this.tag);
                }
                this.handler.readValue(this, attributes);
                continue;
            }
            this.skipAttribute(UNEXPECTED_ATTRIBUTE);
        }
        this.fileMetaInformation = attributes;
        String string = attributes.getString(131088, null);
        if (string == null) {
            LOG.warn(MISSING_TRANSFER_SYNTAX);
            string = "1.2.840.10008.1.2.1";
        }
        this.switchTransferSyntax(string);
        return attributes;
    }

    public void readAttributes(Attributes attributes, int n, int n2) throws IOException {
        ItemPointer[] itemPointerArray = this.itemPointers;
        this.itemPointers = attributes.itemPointers();
        boolean bl = n == -1;
        boolean bl2 = n2 != -1;
        long l = this.pos + ((long)n & 0xFFFFFFFFL);
        while (bl || this.pos < l) {
            try {
                this.readHeader();
            }
            catch (EOFException eOFException) {
                if (bl && this.pos == this.tagPos) break;
                throw eOFException;
            }
            if (bl2 && this.tag == n2) break;
            if (this.vr != null) {
                boolean bl3 = this.bigEndian;
                boolean bl4 = this.explicitVR;
                try {
                    if (this.vr == VR.UN) {
                        if (this.decodeUNWithIVRLE) {
                            this.bigEndian = false;
                            this.explicitVR = false;
                        }
                        this.vr = ElementDictionary.vrOf(this.tag, attributes.getPrivateCreator(this.tag));
                        if (this.vr == VR.UN && this.length == -1) {
                            this.vr = VR.SQ;
                        }
                    }
                    this.handler.readValue(this, attributes);
                    continue;
                }
                finally {
                    this.bigEndian = bl3;
                    this.explicitVR = bl4;
                }
            }
            this.skipAttribute(UNEXPECTED_ATTRIBUTE);
        }
        this.itemPointers = itemPointerArray;
    }

    @Override
    public void readValue(DicomInputStream dicomInputStream, Attributes attributes) throws IOException {
        this.checkIsThis(dicomInputStream);
        if (this.includeBulkData == IncludeBulkData.NO && this.length != -1 && this.isBulkData(attributes)) {
            this.skipFully(this.length);
        } else if (this.length == 0) {
            attributes.setNull(this.tag, this.vr);
        } else if (this.vr == VR.SQ) {
            this.readSequence(this.length, attributes, this.tag);
        } else if (this.length == -1) {
            this.readFragments(attributes, this.tag, this.vr);
        } else if (this.length == 64507 && this.in instanceof ObjectInputStream) {
            attributes.setValue(this.tag, this.vr, BulkData.deserializeFrom((ObjectInputStream)this.in));
        } else if (this.includeBulkData == IncludeBulkData.URI && this.isBulkData(attributes)) {
            BulkData bulkData = this.createBulkData();
            attributes.setValue(this.tag, this.vr, bulkData);
            if (this.addBulkDataReferences) {
                attributes.getRoot().addBulkDataReference(attributes.privateCreatorOf(this.tag), this.tag, this.vr, bulkData, attributes.itemPointers());
            }
        } else {
            byte[] byArray = this.readValue();
            if (!TagUtils.isGroupLength(this.tag)) {
                if (this.bigEndian != attributes.bigEndian()) {
                    this.vr.toggleEndian(byArray, false);
                }
                attributes.setBytes(this.tag, this.vr, byArray);
            } else if (this.tag == 131072) {
                this.setFileMetaInformationGroupLength(byArray);
            }
        }
    }

    public BulkData createBulkData() throws IOException {
        BulkData bulkData;
        if (this.uri != null && !(this.in instanceof InflaterInputStream)) {
            bulkData = new BulkData(this.uri, this.pos, this.length, this.bigEndian);
            this.skipFully(this.length);
        } else {
            if (this.blkOut == null) {
                File file = File.createTempFile(this.blkFilePrefix, this.blkFileSuffix, this.blkDirectory);
                if (this.blkFiles == null) {
                    this.blkFiles = new ArrayList();
                }
                this.blkFiles.add(file);
                this.blkURI = file.toURI().toString();
                this.blkOut = new FileOutputStream(file);
                this.blkOutPos = 0L;
            }
            try {
                StreamUtils.copy((InputStream)this, (OutputStream)this.blkOut, this.length);
            }
            finally {
                if (!this.catBlkFiles) {
                    SafeClose.close(this.blkOut);
                    this.blkOut = null;
                }
            }
            bulkData = new BulkData(this.blkURI, this.blkOutPos, this.length, this.bigEndian);
            this.blkOutPos += (long)this.length;
        }
        return bulkData;
    }

    public boolean isBulkData(Attributes attributes) {
        return this.bulkDataDescriptor.isBulkData(attributes.getPrivateCreator(this.tag), this.tag, this.vr, this.length, this.itemPointers);
    }

    @Override
    public void readValue(DicomInputStream dicomInputStream, Sequence sequence) throws IOException {
        this.checkIsThis(dicomInputStream);
        if (this.length == 0) {
            sequence.add(new Attributes(sequence.getParent().bigEndian(), 0));
            return;
        }
        Attributes attributes = new Attributes(sequence.getParent().bigEndian());
        sequence.add(attributes);
        this.readAttributes(attributes, this.length, -73715);
        attributes.trimToSize();
    }

    @Override
    public void readValue(DicomInputStream dicomInputStream, Fragments fragments) throws IOException {
        this.checkIsThis(dicomInputStream);
        if (this.includeFragmentBulkData == IncludeBulkData.NO) {
            this.skipFully(this.length);
        } else if (this.length == 0) {
            fragments.add(ByteUtils.EMPTY_BYTES);
        } else if (this.length == 64507 && this.in instanceof ObjectInputStream) {
            fragments.add(BulkData.deserializeFrom((ObjectInputStream)this.in));
        } else if (this.includeFragmentBulkData == IncludeBulkData.URI) {
            fragments.add(this.createBulkData());
        } else {
            byte[] byArray = this.readValue();
            if (this.bigEndian != fragments.bigEndian()) {
                fragments.vr().toggleEndian(byArray, false);
            }
            fragments.add(byArray);
        }
    }

    @Override
    public void startDataset(DicomInputStream dicomInputStream) {
    }

    @Override
    public void endDataset(DicomInputStream dicomInputStream) {
    }

    private void checkIsThis(DicomInputStream dicomInputStream) {
        if (dicomInputStream != this) {
            throw new IllegalArgumentException("dis != this");
        }
    }

    private void skipAttribute(String string) throws IOException {
        LOG.warn(string, new Object[]{TagUtils.toString(this.tag), this.length, this.tagPos});
        this.skip(this.length);
    }

    private void readSequence(int n, Attributes attributes, int n2) throws IOException {
        if (n == 0) {
            attributes.setNull(n2, VR.SQ);
            return;
        }
        Sequence sequence = attributes.newSequence(n2, 10);
        attributes.getPrivateCreator(n2);
        boolean bl = n == -1;
        long l = this.pos + ((long)n & 0xFFFFFFFFL);
        while (bl || this.pos < l) {
            this.readHeader();
            if (this.tag == -73728) {
                this.handler.readValue(this, sequence);
                continue;
            }
            if (this.tag == -73507) {
                if (this.length == 0) break;
                this.skipAttribute(UNEXPECTED_NON_ZERO_ITEM_LENGTH);
                break;
            }
            this.skipAttribute(UNEXPECTED_ATTRIBUTE);
        }
        if (sequence.isEmpty()) {
            attributes.setNull(n2, VR.SQ);
        } else {
            sequence.trimToSize();
        }
    }

    public Attributes readItem() throws IOException {
        this.readHeader();
        if (this.tag != -73728) {
            throw new IOException("Unexpected attribute " + TagUtils.toString(this.tag) + " #" + this.length + " @ " + this.pos);
        }
        Attributes attributes = new Attributes(this.bigEndian);
        attributes.setItemPosition(this.tagPos);
        this.readAttributes(attributes, this.length, -73715);
        attributes.trimToSize();
        return attributes;
    }

    private void readFragments(Attributes attributes, int n, VR vR) throws IOException {
        this.includeFragmentBulkData = this.includeBulkData == IncludeBulkData.YES || this.isBulkData(attributes) ? this.includeBulkData : IncludeBulkData.YES;
        String string = attributes.getPrivateCreator(n);
        Fragments fragments = new Fragments(string, n, vR, attributes.bigEndian(), 10);
        while (true) {
            this.readHeader();
            if (this.tag == -73728) {
                this.handler.readValue(this, fragments);
                continue;
            }
            if (this.tag == -73507) {
                if (this.length == 0) break;
                this.skipAttribute(UNEXPECTED_NON_ZERO_ITEM_LENGTH);
                break;
            }
            this.skipAttribute(UNEXPECTED_ATTRIBUTE);
        }
        if (fragments.isEmpty()) {
            attributes.setNull(n, vR);
        } else {
            fragments.trimToSize();
            attributes.setValue(n, vR, fragments);
        }
    }

    public byte[] readValue() throws IOException {
        int n = this.length;
        try {
            if (n < 0) {
                throw new EOFException();
            }
            int n2 = this.allocateLimit >= 0 ? Math.min(n, this.allocateLimit) : n;
            byte[] byArray = new byte[n2];
            this.readFully(byArray, 0, n2);
            while (n2 < n) {
                int n3 = Math.min(n, n2 << 1);
                byArray = Arrays.copyOf(byArray, n3);
                this.readFully(byArray, n2, n3 - n2);
                n2 = n3;
            }
            return byArray;
        }
        catch (IOException iOException) {
            LOG.warn("IOException during read of {} #{} @ {}", new Object[]{TagUtils.toString(this.tag), this.length, this.tagPos, iOException});
            throw iOException;
        }
    }

    private void switchTransferSyntax(String string) throws IOException {
        this.tsuid = string;
        this.bigEndian = string.equals("1.2.840.10008.1.2.2");
        boolean bl = this.explicitVR = !string.equals("1.2.840.10008.1.2");
        if (string.equals("1.2.840.10008.1.2.1.99") || string.equals("1.2.840.10008.1.2.4.95")) {
            if (this.hasZLIBHeader()) {
                LOG.warn(DEFLATED_WITH_ZLIB_HEADER);
                this.in = new InflaterInputStream(this.in);
            } else {
                this.in = new InflaterInputStream(this.in, new Inflater(true));
            }
        }
    }

    private boolean hasZLIBHeader() throws IOException {
        if (!this.markSupported()) {
            return false;
        }
        byte[] byArray = this.buffer;
        this.mark(2);
        this.read(byArray, 0, 2);
        this.reset();
        return ByteUtils.bytesToUShortBE(byArray, 0) == 30876;
    }

    private void guessTransferSyntax() throws IOException {
        byte[] byArray = new byte[128];
        byte[] byArray2 = this.buffer;
        this.mark(132);
        int n = this.read(byArray);
        if (n == 128) {
            this.read(byArray2, 0, 4);
            if (byArray2[0] == 68 && byArray2[1] == 73 && byArray2[2] == 67 && byArray2[3] == 77) {
                this.preamble = (byte[])byArray.clone();
                if (!this.markSupported()) {
                    this.hasfmi = true;
                    this.tsuid = "1.2.840.10008.1.2.1";
                    this.bigEndian = false;
                    this.explicitVR = true;
                    return;
                }
                this.mark(128);
                this.read(byArray);
            }
        }
        if (n < 8 || !this.guessTransferSyntax(byArray, n, false) && !this.guessTransferSyntax(byArray, n, true)) {
            throw new DicomStreamException(NOT_A_DICOM_STREAM);
        }
        this.reset();
        this.hasfmi = TagUtils.isFileMetaInformation(ByteUtils.bytesToTag(byArray, 0, this.bigEndian));
    }

    private boolean guessTransferSyntax(byte[] byArray, int n, boolean bl) throws DicomStreamException {
        int n2 = ByteUtils.bytesToTag(byArray, 0, bl);
        VR vR = ElementDictionary.vrOf(n2, null);
        if (vR == VR.UN) {
            return false;
        }
        if (ByteUtils.bytesToVR(byArray, 4) == vR.code()) {
            this.tsuid = bl ? "1.2.840.10008.1.2.2" : "1.2.840.10008.1.2.1";
            this.bigEndian = bl;
            this.explicitVR = true;
            return true;
        }
        int n3 = ByteUtils.bytesToInt(byArray, 4, bl);
        if (n3 < 0 || 8 + n3 > n) {
            return false;
        }
        if (bl) {
            throw new DicomStreamException(IMPLICIT_VR_BIG_ENDIAN);
        }
        this.tsuid = "1.2.840.10008.1.2";
        this.bigEndian = false;
        this.explicitVR = false;
        return true;
    }

    public static enum IncludeBulkData {
        NO,
        YES,
        URI;

    }
}

