/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.io;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.ContentHandlerAdapter;
import org.dcm4che3.io.SAXWriter;
import org.xml.sax.SAXException;

public abstract class SAXTransformer {
    private static SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();

    public static SAXWriter getSAXWriter(Templates templates, Attributes attributes) throws TransformerConfigurationException {
        return SAXTransformer.getSAXWriter(templates, attributes, null);
    }

    public static SAXWriter getSAXWriter(Templates templates, Attributes attributes, SetupTransformer setupTransformer) throws TransformerConfigurationException {
        return SAXTransformer.getSAXWriter(templates, (Result)new SAXResult(new ContentHandlerAdapter(attributes)), setupTransformer);
    }

    public static SAXWriter getSAXWriter(Templates templates, Result result) throws TransformerConfigurationException {
        return SAXTransformer.getSAXWriter(templates, result, null);
    }

    public static SAXWriter getSAXWriter(Templates templates, Result result, SetupTransformer setupTransformer) throws TransformerConfigurationException {
        return SAXTransformer.getSAXWriter(factory.newTransformerHandler(templates), result, setupTransformer);
    }

    public static SAXWriter getSAXWriter(Result result) throws TransformerConfigurationException {
        return SAXTransformer.getSAXWriter(result, null);
    }

    public static SAXWriter getSAXWriter(Result result, SetupTransformer setupTransformer) throws TransformerConfigurationException {
        return SAXTransformer.getSAXWriter(factory.newTransformerHandler(), result, setupTransformer);
    }

    private static SAXWriter getSAXWriter(TransformerHandler transformerHandler, Result result, SetupTransformer setupTransformer) {
        transformerHandler.setResult(result);
        if (setupTransformer != null) {
            setupTransformer.setup(transformerHandler.getTransformer());
        }
        return new SAXWriter(transformerHandler);
    }

    public static Attributes transform(Attributes attributes, Templates templates, boolean bl, boolean bl2) throws SAXException, TransformerConfigurationException {
        return SAXTransformer.transform(attributes, templates, bl, bl2, null);
    }

    public static Attributes transform(Attributes attributes, Templates templates, boolean bl, boolean bl2, SetupTransformer setupTransformer) throws SAXException, TransformerConfigurationException {
        Attributes attributes2 = new Attributes();
        SAXWriter sAXWriter = SAXTransformer.getSAXWriter(templates, attributes2, setupTransformer);
        sAXWriter.setIncludeNamespaceDeclaration(bl);
        sAXWriter.setIncludeKeyword(bl2);
        sAXWriter.write(attributes);
        return attributes2;
    }

    public static Templates newTemplates(Source source) throws TransformerConfigurationException {
        return factory.newTemplates(source);
    }

    public static interface SetupTransformer {
        public void setup(Transformer var1);
    }
}

