/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.io;

import java.io.IOException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.PersonName;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.SpecificCharacterSet;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.Value;
import org.dcm4che3.io.DicomInputHandler;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.util.Base64;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.TagUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SAXWriter
implements DicomInputHandler {
    private static final String NAMESPACE = "http://dicom.nema.org/PS3.19/models/NativeDICOM";
    private static final int BASE64_CHUNK_LENGTH = 768;
    private static final int BUFFER_LENGTH = 1024;
    private boolean includeKeyword = true;
    private String namespace = "";
    private final ContentHandler ch;
    private final AttributesImpl atts = new AttributesImpl();
    private final char[] buffer = new char[1024];

    public SAXWriter(ContentHandler contentHandler) {
        this.ch = contentHandler;
    }

    public final boolean isIncludeKeyword() {
        return this.includeKeyword;
    }

    public final void setIncludeKeyword(boolean bl) {
        this.includeKeyword = bl;
    }

    public final boolean isIncludeNamespaceDeclaration() {
        return this.namespace == NAMESPACE;
    }

    public final void setIncludeNamespaceDeclaration(boolean bl) {
        this.namespace = bl ? NAMESPACE : "";
    }

    public void write(Attributes attributes) throws SAXException {
        this.startDocument();
        this.writeItem(attributes);
        this.endDocument();
    }

    private void writeItem(final Attributes attributes) throws SAXException {
        final SpecificCharacterSet specificCharacterSet = attributes.getSpecificCharacterSet();
        try {
            attributes.accept(new Attributes.Visitor(){

                @Override
                public boolean visit(Attributes attributes2, int n, VR vR, Object object) throws Exception {
                    SAXWriter.this.writeAttribute(n, vR, object, specificCharacterSet, attributes);
                    return true;
                }
            }, false);
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void startDataset(DicomInputStream dicomInputStream) throws IOException {
        try {
            this.startDocument();
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException);
        }
    }

    @Override
    public void endDataset(DicomInputStream dicomInputStream) throws IOException {
        try {
            this.endDocument();
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException);
        }
    }

    private void startDocument() throws SAXException {
        this.ch.startDocument();
        this.startElement("NativeDicomModel", "xml:space", "preserve");
    }

    private void endDocument() throws SAXException {
        this.endElement("NativeDicomModel");
        this.ch.endDocument();
    }

    private void startElement(String string, String string2, int n) throws SAXException {
        this.startElement(string, string2, Integer.toString(n));
    }

    private void startElement(String string, String string2, String string3) throws SAXException {
        this.addAttribute(string2, string3);
        this.startElement(string);
    }

    private void startElement(String string) throws SAXException {
        this.ch.startElement(this.namespace, string, string, this.atts);
        this.atts.clear();
    }

    private void endElement(String string) throws SAXException {
        this.ch.endElement(this.namespace, string, string);
    }

    private void addAttribute(String string, String string2) {
        this.atts.addAttribute(this.namespace, string, string, "NMTOKEN", string2);
    }

    private void writeAttribute(int n, VR vR, Object object, SpecificCharacterSet specificCharacterSet, Attributes attributes) throws SAXException {
        if (TagUtils.isGroupLength(n) || TagUtils.isPrivateCreator(n)) {
            return;
        }
        String string = attributes.getPrivateCreator(n);
        this.addAttributes(n, vR, string);
        this.startElement("DicomAttribute");
        if (object instanceof Value) {
            this.writeAttribute((Value)object, attributes.bigEndian());
        } else if (!vR.isInlineBinary()) {
            this.writeValues(vR, object, attributes.bigEndian(), attributes.getSpecificCharacterSet(vR));
        } else if (object instanceof byte[]) {
            this.writeInlineBinary(attributes.bigEndian() ? vR.toggleEndian((byte[])object, true) : (byte[])object);
        } else {
            throw new IllegalArgumentException("vr: " + (Object)((Object)vR) + ", value class: " + object.getClass());
        }
        this.endElement("DicomAttribute");
    }

    private void writeAttribute(Value value, boolean bl) throws SAXException {
        if (value.isEmpty()) {
            return;
        }
        if (value instanceof Sequence) {
            Sequence sequence = (Sequence)value;
            int n = 0;
            for (Attributes attributes : sequence) {
                this.startElement("Item", "number", ++n);
                this.writeItem(attributes);
                this.endElement("Item");
            }
        } else if (value instanceof Fragments) {
            Fragments fragments = (Fragments)value;
            if (fragments.size() > 1 && fragments.get(1) instanceof BulkData) {
                this.writeBulkData(BulkData.fromFragments(fragments));
            } else {
                int n = 0;
                for (Object e : fragments) {
                    ++n;
                    if (e instanceof Value && ((Value)e).isEmpty()) continue;
                    this.startElement("DataFragment", "number", n);
                    byte[] byArray = (byte[])e;
                    if (bl) {
                        fragments.vr().toggleEndian(byArray, true);
                    }
                    this.writeInlineBinary(byArray);
                    this.endElement("DataFragment");
                }
            }
        } else if (value instanceof BulkData) {
            this.writeBulkData((BulkData)value);
        }
    }

    @Override
    public void readValue(DicomInputStream dicomInputStream, Attributes attributes) throws IOException {
        int n = dicomInputStream.tag();
        VR vR = dicomInputStream.vr();
        int n2 = dicomInputStream.length();
        if (TagUtils.isGroupLength(n) || TagUtils.isPrivateCreator(n)) {
            dicomInputStream.readValue(dicomInputStream, attributes);
        } else if (dicomInputStream.getIncludeBulkData() == DicomInputStream.IncludeBulkData.NO && dicomInputStream.isBulkData(attributes)) {
            if (n2 == -1) {
                dicomInputStream.readValue(dicomInputStream, attributes);
            } else {
                dicomInputStream.skipFully(n2);
            }
        } else {
            try {
                String string = attributes.getPrivateCreator(n);
                this.addAttributes(n, vR, string);
                this.startElement("DicomAttribute");
                if (vR == VR.SQ || n2 == -1) {
                    dicomInputStream.readValue(dicomInputStream, attributes);
                    if (vR != VR.SQ && dicomInputStream.getIncludeFragmentBulkData() == DicomInputStream.IncludeBulkData.URI) {
                        this.writeBulkData(BulkData.fromFragments((Fragments)attributes.remove(string, n)));
                    }
                } else if (n2 > 0) {
                    if (dicomInputStream.getIncludeBulkData() == DicomInputStream.IncludeBulkData.URI && dicomInputStream.isBulkData(attributes)) {
                        this.writeBulkData(dicomInputStream.createBulkData());
                    } else {
                        byte[] byArray = dicomInputStream.readValue();
                        if (n == 131088 || n == 524293) {
                            attributes.setBytes(n, vR, byArray);
                        }
                        if (vR.isInlineBinary()) {
                            this.writeInlineBinary(dicomInputStream.bigEndian() ? vR.toggleEndian(byArray, false) : byArray);
                        } else {
                            this.writeValues(vR, byArray, dicomInputStream.bigEndian(), attributes.getSpecificCharacterSet(vR));
                        }
                    }
                }
                this.endElement("DicomAttribute");
            }
            catch (SAXException sAXException) {
                throw new IOException(sAXException);
            }
        }
    }

    private void addAttributes(int n, VR vR, String string) {
        String string2;
        if (string != null) {
            n &= 0xFFFF00FF;
        }
        if (this.includeKeyword && (string2 = ElementDictionary.keywordOf(n, string)) != null && !string2.isEmpty()) {
            this.addAttribute("keyword", string2);
        }
        this.addAttribute("tag", TagUtils.toHexString(n));
        if (string != null) {
            this.addAttribute("privateCreator", string);
        }
        this.addAttribute("vr", vR.name());
    }

    @Override
    public void readValue(DicomInputStream dicomInputStream, Sequence sequence) throws IOException {
        try {
            this.startElement("Item", "number", sequence.size() + 1);
            dicomInputStream.readValue(dicomInputStream, sequence);
            this.endElement("Item");
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException);
        }
    }

    @Override
    public void readValue(DicomInputStream dicomInputStream, Fragments fragments) throws IOException {
        int n = dicomInputStream.length();
        Object object = ByteUtils.EMPTY_BYTES;
        if (n > 0) {
            switch (dicomInputStream.getIncludeFragmentBulkData()) {
                case NO: {
                    dicomInputStream.skipFully(n);
                    return;
                }
                case URI: {
                    object = dicomInputStream.createBulkData();
                    break;
                }
                case YES: {
                    byte[] byArray = dicomInputStream.readValue();
                    if (dicomInputStream.bigEndian()) {
                        fragments.vr().toggleEndian(byArray, false);
                    }
                    try {
                        this.startElement("DataFragment", "number", fragments.size());
                        this.writeInlineBinary(byArray);
                        this.endElement("DataFragment");
                        break;
                    }
                    catch (SAXException sAXException) {
                        throw new IOException(sAXException);
                    }
                }
            }
        }
        fragments.add(object);
    }

    private void writeValues(VR vR, Object object, boolean bl, SpecificCharacterSet specificCharacterSet) throws SAXException {
        if (vR.isStringType()) {
            object = vR.toStrings(object, bl, specificCharacterSet);
        }
        int n = vR.vmOf(object);
        int n2 = 0;
        while (n2 < n) {
            String string = vR.toString(object, bl, n2, null);
            this.addAttribute("number", Integer.toString(n2 + 1));
            if (vR == VR.PN) {
                PersonName personName = new PersonName(string, true);
                this.startElement("PersonName");
                this.writePNGroup("Alphabetic", personName, PersonName.Group.Alphabetic);
                this.writePNGroup("Ideographic", personName, PersonName.Group.Ideographic);
                this.writePNGroup("Phonetic", personName, PersonName.Group.Phonetic);
                this.endElement("PersonName");
            } else {
                this.writeElement("Value", string);
            }
            ++n2;
        }
    }

    private void writeInlineBinary(byte[] byArray) throws SAXException {
        this.startElement("InlineBinary");
        char[] cArray = this.buffer;
        int n = 0;
        while (n < byArray.length) {
            int n2 = Math.min(byArray.length - n, 768);
            Base64.encode(byArray, n, n2, cArray, 0);
            this.ch.characters(cArray, 0, n2 * 4 / 3 + 3 & 0xFFFFFFFC);
            n += n2;
        }
        this.endElement("InlineBinary");
    }

    private void writeBulkData(BulkData bulkData) throws SAXException {
        if (bulkData.uuid != null) {
            this.addAttribute("uuid", bulkData.uuid);
        }
        if (bulkData.uri != null) {
            this.addAttribute("uri", bulkData.uri);
        }
        this.startElement("BulkData");
        this.endElement("BulkData");
    }

    private void writeElement(String string, String string2) throws SAXException {
        if (string2 != null) {
            this.startElement(string);
            char[] cArray = this.buffer;
            int n = 0;
            int n2 = string2.length();
            while (n < n2) {
                int n3 = Math.min(n2 - n, cArray.length);
                string2.getChars(n, n += n3, cArray, 0);
                this.ch.characters(cArray, 0, n3);
            }
            this.endElement(string);
        }
    }

    private void writePNGroup(String string, PersonName personName, PersonName.Group group) throws SAXException {
        if (personName.contains(group)) {
            this.startElement(string);
            this.writeElement("FamilyName", personName.get(group, PersonName.Component.FamilyName));
            this.writeElement("GivenName", personName.get(group, PersonName.Component.GivenName));
            this.writeElement("MiddleName", personName.get(group, PersonName.Component.MiddleName));
            this.writeElement("NamePrefix", personName.get(group, PersonName.Component.NamePrefix));
            this.writeElement("NameSuffix", personName.get(group, PersonName.Component.NameSuffix));
            this.endElement(string);
        }
    }
}

