/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.PersonName;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.Base64;
import org.dcm4che3.util.TagUtils;

public class JSONReader {
    private final JsonParser parser;
    private boolean addBulkDataReferences;
    private Attributes fmi;
    private JsonLocation location;
    private JsonParser.Event event;
    private final ByteArrayOutputStream bout = new ByteArrayOutputStream(64);
    private final ArrayList<String> stringValues = new ArrayList();
    private final ArrayList<Number> numberValues = new ArrayList();
    private final EnumMap<PersonName.Group, String> personNameGroups = new EnumMap(PersonName.Group.class);

    public JSONReader(JsonParser jsonParser) {
        this.parser = jsonParser;
    }

    public boolean isAddBulkDataReferences() {
        return this.addBulkDataReferences;
    }

    public void setAddBulkDataReferences(boolean bl) {
        this.addBulkDataReferences = bl;
    }

    public Attributes getFileMetaInformation() {
        return this.fmi;
    }

    private JsonParser.Event next() {
        this.location = this.parser.getLocation();
        this.event = this.parser.next();
        return this.event;
    }

    private String getString() {
        this.location = this.parser.getLocation();
        return this.parser.getString();
    }

    public Attributes readDataset(Attributes attributes) {
        if (this.next() != JsonParser.Event.START_OBJECT) {
            throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + ", expected Data Set object", this.location);
        }
        if (attributes == null) {
            attributes = new Attributes();
        }
        this.fmi = null;
        this.doReadDataset(attributes);
        return attributes;
    }

    public void readDatasets(Callback callback) {
        if (this.next() != JsonParser.Event.START_ARRAY) {
            throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + ", expected array of Data Set objects", this.location);
        }
        block4: while (true) {
            switch (this.next()) {
                case END_ARRAY: {
                    return;
                }
                case START_OBJECT: {
                    this.fmi = null;
                    Attributes attributes = new Attributes();
                    this.doReadDataset(attributes);
                    callback.onDataset(this.fmi, attributes);
                    continue block4;
                }
            }
            break;
        }
        throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + ", expected Data Set object", this.location);
    }

    private void doReadDataset(Attributes attributes) {
        block4: while (true) {
            switch (this.next()) {
                case KEY_NAME: {
                    this.readAttribute(attributes);
                    continue block4;
                }
                case END_OBJECT: {
                    attributes.trimToSize();
                    return;
                }
            }
            break;
        }
        throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + ", expected Tag value", this.location);
    }

    private void readAttribute(Attributes attributes) {
        String string = this.getString();
        int n = (int)Long.parseLong(string, 16);
        if (TagUtils.isFileMetaInformation(n)) {
            if (this.fmi == null) {
                this.fmi = new Attributes();
            }
            attributes = this.fmi;
        }
        if (this.next() != JsonParser.Event.START_OBJECT) {
            throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + " expected attribute object", this.location);
        }
        if (this.next() != JsonParser.Event.KEY_NAME) {
            throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + "\", expected \"vr\"", this.location);
        }
        string = this.getString();
        if (!"vr".equals(string)) {
            throw new JsonParsingException("Unexpected \"" + string + "\", expected: \"vr\"", this.location);
        }
        if (this.next() != JsonParser.Event.VALUE_STRING) {
            throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + " expected vr value", this.location);
        }
        VR vR = VR.valueOf(this.parser.getString());
        switch (this.next()) {
            case END_OBJECT: {
                attributes.setNull(n, vR);
                break;
            }
            case KEY_NAME: {
                string = this.getString();
                if ("Value".equals(string)) {
                    switch (vR) {
                        case AE: 
                        case AS: 
                        case AT: 
                        case CS: 
                        case DA: 
                        case DT: 
                        case LO: 
                        case LT: 
                        case SH: 
                        case ST: 
                        case TM: 
                        case UC: 
                        case UI: 
                        case UR: 
                        case UT: {
                            this.readStringValues(attributes, n, vR);
                            break;
                        }
                        case DS: 
                        case FD: 
                        case FL: 
                        case IS: 
                        case SL: 
                        case SS: 
                        case UL: 
                        case US: {
                            this.readNumberValues(attributes, n, vR);
                            break;
                        }
                        case PN: {
                            this.readPersonNames(attributes, n);
                            break;
                        }
                        case SQ: {
                            this.readSequence(attributes, n);
                            break;
                        }
                        case OB: 
                        case OD: 
                        case OF: 
                        case OW: 
                        case UN: {
                            throw new JsonParsingException("Unexpected \"Value\"\", expected \"InlineBinary\" or \"BulkDataURI\" or  \"DataFragment\"", this.location);
                        }
                    }
                } else if ("InlineBinary".equals(string)) {
                    attributes.setBytes(n, vR, this.readInlineBinary());
                } else if ("BulkDataURI".equals(string)) {
                    BulkData bulkData = this.readBulkData(attributes.bigEndian());
                    attributes.setValue(n, vR, bulkData.hasFragments() ? bulkData.toFragments(attributes.privateCreatorOf(n), n, vR) : bulkData);
                    if (this.addBulkDataReferences) {
                        attributes.getRoot().addBulkDataReference(attributes.privateCreatorOf(n), n, vR, bulkData, attributes.itemPointers());
                    }
                } else if ("DataFragment".equals(string)) {
                    this.readDataFragment(attributes, n, vR);
                } else {
                    throw new JsonParsingException("Unexpected \"" + string + "\", expected \"Value\" or \"InlineBinary\"" + " or \"BulkDataURI\" or  \"DataFragment\"", this.location);
                }
                if (this.next() == JsonParser.Event.END_OBJECT) break;
                throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + " expected end of attribute object", this.location);
            }
            default: {
                throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + "\", expected \"Value\" or \"InlineBinary\"" + " or \"BulkDataURI\"", this.location);
            }
        }
    }

    private void readStringValues(Attributes attributes, int n, VR vR) {
        if (this.next() != JsonParser.Event.START_ARRAY) {
            throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + ", expected array of values", this.location);
        }
        block5: while (true) {
            switch (this.next()) {
                case END_ARRAY: {
                    attributes.setString(n, vR, this.stringValues.toArray(new String[this.stringValues.size()]));
                    this.stringValues.clear();
                    return;
                }
                case VALUE_NULL: {
                    this.stringValues.add(null);
                    continue block5;
                }
                case VALUE_STRING: {
                    this.stringValues.add(this.parser.getString());
                    continue block5;
                }
            }
            break;
        }
        throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + ", expected string value", this.location);
    }

    private void readNumberValues(Attributes attributes, int n, VR vR) {
        if (this.next() != JsonParser.Event.START_ARRAY) {
            throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + ", expected array of values", this.location);
        }
        block8: while (true) {
            switch (this.next()) {
                case END_ARRAY: {
                    switch (vR) {
                        case DS: 
                        case FD: 
                        case FL: {
                            attributes.setDouble(n, vR, this.toDoubles(this.numberValues));
                            break;
                        }
                        case IS: 
                        case SL: 
                        case SS: 
                        case UL: 
                        case US: {
                            attributes.setInt(n, vR, this.toInts(this.numberValues));
                        }
                    }
                    this.numberValues.clear();
                    return;
                }
                case VALUE_NUMBER: {
                    this.numberValues.add(this.parser.getBigDecimal());
                    continue block8;
                }
            }
            break;
        }
        throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + ", expected number value", this.location);
    }

    private double[] toDoubles(ArrayList<Number> arrayList) {
        double[] dArray = new double[arrayList.size()];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = arrayList.get(n).doubleValue();
            ++n;
        }
        return dArray;
    }

    private int[] toInts(ArrayList<Number> arrayList) {
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = arrayList.get(n).intValue();
            ++n;
        }
        return nArray;
    }

    private void readPersonNames(Attributes attributes, int n) {
        if (this.next() != JsonParser.Event.START_ARRAY) {
            throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + ", expected array of person name objects", this.location);
        }
        block5: while (true) {
            switch (this.next()) {
                case END_ARRAY: {
                    attributes.setString(n, VR.PN, this.stringValues.toArray(new String[this.stringValues.size()]));
                    this.stringValues.clear();
                    return;
                }
                case VALUE_NULL: {
                    this.stringValues.add(null);
                    continue block5;
                }
                case START_OBJECT: {
                    this.stringValues.add(this.readPersonName());
                    continue block5;
                }
            }
            break;
        }
        throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + ", expected person name object", this.location);
    }

    private String readPersonName() {
        block6: while (true) {
            switch (this.next()) {
                case END_OBJECT: {
                    String string = this.toString(this.personNameGroups);
                    this.personNameGroups.clear();
                    return string;
                }
                case KEY_NAME: {
                    PersonName.Group group;
                    try {
                        group = PersonName.Group.valueOf(this.getString());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new JsonParsingException("Unexpected \"" + illegalArgumentException.getMessage() + "\", expected \"Alphabetic\" or \"Ideographic\"" + " or \"Phonetic\"", this.location);
                    }
                    if (this.next() != JsonParser.Event.VALUE_STRING) {
                        throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + "\", expected person name value", this.location);
                    }
                    this.personNameGroups.put(group, this.parser.getString());
                    continue block6;
                }
            }
            break;
        }
        throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + ", expected \"Alphabetic\" or \"Ideographic\"" + " or \"Phonetic\"", this.location);
    }

    private String toString(EnumMap<PersonName.Group, String> enumMap) {
        String string = enumMap.get((Object)PersonName.Group.Alphabetic);
        if (string != null && enumMap.size() == 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append('=');
        string = enumMap.get((Object)PersonName.Group.Ideographic);
        if (string != null) {
            stringBuilder.append(string);
        }
        if ((string = enumMap.get((Object)PersonName.Group.Phonetic)) != null) {
            stringBuilder.append('=').append(string);
        }
        return stringBuilder.toString();
    }

    private void readSequence(Attributes attributes, int n) {
        final Sequence sequence = attributes.newSequence(n, 10);
        Attributes attributes2 = this.fmi;
        this.readDatasets(new Callback(){

            @Override
            public void onDataset(Attributes attributes, Attributes attributes2) {
                sequence.add(attributes2);
            }
        });
        this.fmi = attributes2;
        sequence.trimToSize();
    }

    private byte[] readInlineBinary() {
        if (this.next() != JsonParser.Event.VALUE_STRING) {
            throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + ", expected bulk data URI", this.location);
        }
        char[] cArray = this.parser.getString().toCharArray();
        this.bout.reset();
        try {
            Base64.decode(cArray, 0, cArray.length, this.bout);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return this.bout.toByteArray();
    }

    private BulkData readBulkData(boolean bl) {
        if (this.next() != JsonParser.Event.VALUE_STRING) {
            throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + ", expected bulk data URI", this.location);
        }
        String string = this.parser.getString();
        return new BulkData(null, string, bl);
    }

    private void readDataFragment(Attributes attributes, int n, VR vR) {
        if (this.next() != JsonParser.Event.START_ARRAY) {
            throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + ", expected array of data fragment objects", this.location);
        }
        Fragments fragments = attributes.newFragments(n, vR, 10);
        block5: while (true) {
            switch (this.next()) {
                case END_ARRAY: {
                    fragments.trimToSize();
                    return;
                }
                case VALUE_NULL: {
                    fragments.add((Object)null);
                    continue block5;
                }
                case START_OBJECT: {
                    fragments.add(this.readDataFragment(attributes.bigEndian()));
                    continue block5;
                }
            }
            break;
        }
        throw new JsonParsingException("Unexpected " + (Object)((Object)this.event) + ", expected data fragment object", this.location);
    }

    private Object readDataFragment(boolean bl) {
        Object object;
        JsonParser.Event event = this.next();
        switch (event) {
            case KEY_NAME: {
                break;
            }
            case END_OBJECT: {
                return null;
            }
            default: {
                throw new JsonParsingException("Unexpected " + (Object)((Object)event) + ", expected \"InlineBinary\"" + " or \"BulkDataURI\"", this.location);
            }
        }
        if (event != JsonParser.Event.KEY_NAME) {
            throw new JsonParsingException("Unexpected " + (Object)((Object)event) + ", expected \"InlineBinary\"" + " or \"BulkDataURI\"", this.location);
        }
        String string = this.getString();
        if ("BulkDataURI".equals(string)) {
            object = this.readBulkData(bl);
        } else if ("InlineBinary".equals(string)) {
            object = this.readInlineBinary();
        } else {
            throw new JsonParsingException("Unexpected \"" + string + "\", expected \"InlineBinary\"" + " or \"BulkDataURI\"", this.location);
        }
        if (this.next() != JsonParser.Event.END_OBJECT) {
            throw new JsonParsingException("Unexpected " + (Object)((Object)event) + " expected end of data fragment object", this.location);
        }
        return object;
    }

    public static interface Callback {
        public void onDataset(Attributes var1, Attributes var2);
    }
}

