/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.json;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.json.stream.JsonGenerator;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.PersonName;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.SpecificCharacterSet;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.Value;
import org.dcm4che3.io.DicomInputHandler;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.util.Base64;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;

public class JSONWriter
implements DicomInputHandler {
    private final JsonGenerator gen;
    private final Deque<Boolean> hasItems = new ArrayDeque<Boolean>();

    public JSONWriter(JsonGenerator jsonGenerator) {
        this.gen = jsonGenerator;
    }

    public void write(Attributes attributes) {
        final SpecificCharacterSet specificCharacterSet = attributes.getSpecificCharacterSet();
        this.gen.writeStartObject();
        try {
            attributes.accept(new Attributes.Visitor(){

                @Override
                public boolean visit(Attributes attributes, int n, VR vR, Object object) throws Exception {
                    JSONWriter.this.writeAttribute(n, vR, object, specificCharacterSet, attributes);
                    return true;
                }
            }, false);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.gen.writeEnd();
    }

    private void writeAttribute(int n, VR vR, Object object, SpecificCharacterSet specificCharacterSet, Attributes attributes) {
        if (TagUtils.isGroupLength(n)) {
            return;
        }
        this.gen.writeStartObject(TagUtils.toHexString(n));
        this.gen.write("vr", vR.name());
        if (object instanceof Value) {
            this.writeValue((Value)object, attributes.bigEndian());
        } else {
            this.writeValue(vR, object, attributes.bigEndian(), attributes.getSpecificCharacterSet(vR), true);
        }
        this.gen.writeEnd();
    }

    private void writeValue(Value value, boolean bl) {
        if (value.isEmpty()) {
            return;
        }
        if (value instanceof Sequence) {
            this.gen.writeStartArray("Value");
            for (Attributes attributes : (Sequence)value) {
                this.write(attributes);
            }
            this.gen.writeEnd();
        } else if (value instanceof Fragments) {
            Fragments fragments = (Fragments)value;
            if (fragments.size() > 1 && fragments.get(1) instanceof BulkData) {
                this.writeBulkData(BulkData.fromFragments(fragments));
            } else {
                this.gen.writeStartArray("DataFragment");
                for (Object e : fragments) {
                    this.gen.writeStartObject();
                    if (!(e instanceof Value) || !((Value)e).isEmpty()) {
                        this.writeInlineBinary(fragments.vr(), (byte[])e, bl, true);
                    }
                    this.gen.writeEnd();
                }
                this.gen.writeEnd();
            }
        } else if (value instanceof BulkData) {
            this.writeBulkData((BulkData)value);
        }
    }

    @Override
    public void readValue(DicomInputStream dicomInputStream, Attributes attributes) throws IOException {
        int n = dicomInputStream.tag();
        VR vR = dicomInputStream.vr();
        int n2 = dicomInputStream.length();
        if (TagUtils.isGroupLength(n)) {
            dicomInputStream.readValue(dicomInputStream, attributes);
        } else if (dicomInputStream.getIncludeBulkData() == DicomInputStream.IncludeBulkData.NO && dicomInputStream.isBulkData(attributes)) {
            if (n2 == -1) {
                dicomInputStream.readValue(dicomInputStream, attributes);
            } else {
                dicomInputStream.skipFully(n2);
            }
        } else {
            this.gen.writeStartObject(TagUtils.toHexString(n));
            this.gen.write("vr", vR.name());
            if (vR == VR.SQ || n2 == -1) {
                this.hasItems.addLast(false);
                dicomInputStream.readValue(dicomInputStream, attributes);
                if (this.hasItems.removeLast().booleanValue()) {
                    this.gen.writeEnd();
                }
                if (vR != VR.SQ && dicomInputStream.getIncludeFragmentBulkData() == DicomInputStream.IncludeBulkData.URI) {
                    this.writeBulkData(BulkData.fromFragments((Fragments)attributes.remove(attributes.privateCreatorOf(n), n)));
                }
            } else if (n2 > 0) {
                if (dicomInputStream.getIncludeBulkData() == DicomInputStream.IncludeBulkData.URI && dicomInputStream.isBulkData(attributes)) {
                    this.writeBulkData(dicomInputStream.createBulkData());
                } else {
                    byte[] byArray = dicomInputStream.readValue();
                    if (n == 131088 || n == 524293) {
                        attributes.setBytes(n, vR, byArray);
                    }
                    this.writeValue(vR, byArray, dicomInputStream.bigEndian(), attributes.getSpecificCharacterSet(vR), false);
                }
            }
            this.gen.writeEnd();
        }
    }

    private void writeValue(VR vR, Object object, boolean bl, SpecificCharacterSet specificCharacterSet, boolean bl2) {
        switch (vR) {
            case AE: 
            case AS: 
            case AT: 
            case CS: 
            case DA: 
            case DS: 
            case DT: 
            case IS: 
            case LO: 
            case LT: 
            case PN: 
            case SH: 
            case ST: 
            case TM: 
            case UC: 
            case UI: 
            case UR: 
            case UT: {
                this.writeStringValues(vR, object, bl, specificCharacterSet);
                break;
            }
            case FD: 
            case FL: {
                this.writeDoubleValues(vR, object, bl);
                break;
            }
            case SL: 
            case SS: 
            case UL: 
            case US: {
                this.writeIntValues(vR, object, bl);
                break;
            }
            case OB: 
            case OD: 
            case OF: 
            case OW: 
            case UN: {
                this.writeInlineBinary(vR, (byte[])object, bl, bl2);
            }
        }
    }

    private void writeStringValues(VR vR, Object object, boolean bl, SpecificCharacterSet specificCharacterSet) {
        String[] stringArray;
        String[] stringArray2;
        this.gen.writeStartArray("Value");
        Object object2 = vR.toStrings(object, bl, specificCharacterSet);
        if (object2 instanceof String[]) {
            stringArray2 = (String[])object2;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = (String)object2;
        }
        String[] stringArray4 = stringArray = stringArray2;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray4[n2];
            if (string == null || string.isEmpty()) {
                this.gen.writeNull();
            } else {
                switch (vR) {
                    case DS: {
                        this.gen.write(StringUtils.parseDS(string));
                        break;
                    }
                    case IS: {
                        this.gen.write(StringUtils.parseIS(string));
                        break;
                    }
                    case PN: {
                        this.writePersonName(string);
                        break;
                    }
                    default: {
                        this.gen.write(string);
                    }
                }
            }
            ++n2;
        }
        this.gen.writeEnd();
    }

    private void writeDoubleValues(VR vR, Object object, boolean bl) {
        this.gen.writeStartArray("Value");
        int n = vR.vmOf(object);
        int n2 = 0;
        while (n2 < n) {
            this.gen.write(vR.toDouble(object, bl, n2, 0.0));
            ++n2;
        }
        this.gen.writeEnd();
    }

    private void writeIntValues(VR vR, Object object, boolean bl) {
        this.gen.writeStartArray("Value");
        int n = vR.vmOf(object);
        int n2 = 0;
        while (n2 < n) {
            this.gen.write(vR.toInt(object, bl, n2, 0));
            ++n2;
        }
        this.gen.writeEnd();
    }

    private void writePersonName(String string) {
        PersonName personName = new PersonName(string, true);
        this.gen.writeStartObject();
        this.writePNGroup("Alphabetic", personName, PersonName.Group.Alphabetic);
        this.writePNGroup("Ideographic", personName, PersonName.Group.Ideographic);
        this.writePNGroup("Phonetic", personName, PersonName.Group.Phonetic);
        this.gen.writeEnd();
    }

    private void writePNGroup(String string, PersonName personName, PersonName.Group group) {
        if (personName.contains(group)) {
            this.gen.write(string, personName.toString(group, true));
        }
    }

    private void writeInlineBinary(VR vR, byte[] byArray, boolean bl, boolean bl2) {
        if (bl) {
            byArray = vR.toggleEndian(byArray, bl2);
        }
        this.gen.write("InlineBinary", this.encodeBase64(byArray));
    }

    private String encodeBase64(byte[] byArray) {
        int n = byArray.length * 4 / 3 + 3 & 0xFFFFFFFC;
        char[] cArray = new char[n];
        Base64.encode(byArray, 0, byArray.length, cArray, 0);
        return new String(cArray);
    }

    private void writeBulkData(BulkData bulkData) {
        this.gen.write("BulkDataURI", bulkData.uri);
    }

    @Override
    public void readValue(DicomInputStream dicomInputStream, Sequence sequence) throws IOException {
        if (!this.hasItems.getLast().booleanValue()) {
            this.gen.writeStartArray("Value");
            this.hasItems.removeLast();
            this.hasItems.addLast(true);
        }
        this.gen.writeStartObject();
        dicomInputStream.readValue(dicomInputStream, sequence);
        this.gen.writeEnd();
    }

    @Override
    public void readValue(DicomInputStream dicomInputStream, Fragments fragments) throws IOException {
        int n = dicomInputStream.length();
        switch (dicomInputStream.getIncludeFragmentBulkData()) {
            case NO: {
                dicomInputStream.skipFully(n);
                break;
            }
            case URI: {
                fragments.add(n > 0 ? dicomInputStream.createBulkData() : null);
                break;
            }
            case YES: {
                if (!this.hasItems.getLast().booleanValue()) {
                    this.gen.writeStartArray("DataFragment");
                    this.hasItems.removeLast();
                    this.hasItems.add(true);
                }
                this.gen.writeStartObject();
                if (n > 0) {
                    this.writeInlineBinary(fragments.vr(), dicomInputStream.readValue(), dicomInputStream.bigEndian(), false);
                }
                this.gen.writeEnd();
            }
        }
    }

    @Override
    public void startDataset(DicomInputStream dicomInputStream) throws IOException {
        this.gen.writeStartObject();
    }

    @Override
    public void endDataset(DicomInputStream dicomInputStream) throws IOException {
        this.gen.writeEnd();
    }
}

