/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.CancelRQHandler;
import org.dcm4che3.net.Commands;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.DataWriter;
import org.dcm4che3.net.DataWriterAdapter;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.DimseRSPHandler;
import org.dcm4che3.net.FutureDimseRSP;
import org.dcm4che3.net.NoPresentationContextException;
import org.dcm4che3.net.NoRoleSelectionException;
import org.dcm4che3.net.PDUDecoder;
import org.dcm4che3.net.PDUEncoder;
import org.dcm4che3.net.PDVInputStream;
import org.dcm4che3.net.State;
import org.dcm4che3.net.Status;
import org.dcm4che3.net.Timeout;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.AAbort;
import org.dcm4che3.net.pdu.AAssociateAC;
import org.dcm4che3.net.pdu.AAssociateRJ;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.CommonExtendedNegotiation;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.pdu.RoleSelection;
import org.dcm4che3.util.IntHashMap;
import org.dcm4che3.util.SafeClose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Association {
    public static final Logger LOG = LoggerFactory.getLogger(Association.class);
    private static final AtomicInteger prevSerialNo = new AtomicInteger();
    private final AtomicInteger messageID = new AtomicInteger();
    private final int serialNo;
    private final boolean requestor;
    private String name;
    private ApplicationEntity ae;
    private final Device device;
    private final Connection conn;
    private final Socket sock;
    private final InputStream in;
    private final OutputStream out;
    private final PDUEncoder encoder;
    private PDUDecoder decoder;
    private State state;
    private AAssociateRQ rq;
    private AAssociateAC ac;
    private IOException ex;
    private HashMap<String, Object> properties;
    private int maxOpsInvoked;
    private int maxPDULength;
    private int performing;
    private Timeout timeout;
    private final IntHashMap<DimseRSPHandler> rspHandlerForMsgId = new IntHashMap();
    private final IntHashMap<CancelRQHandler> cancelHandlerForMsgId = new IntHashMap();
    private final HashMap<String, HashMap<String, PresentationContext>> pcMap = new HashMap();

    Association(ApplicationEntity applicationEntity, Connection connection, Socket socket) throws IOException {
        this.serialNo = prevSerialNo.incrementAndGet();
        this.ae = applicationEntity;
        this.requestor = applicationEntity != null;
        this.name = socket.getLocalSocketAddress() + this.delim() + socket.getRemoteSocketAddress() + '(' + this.serialNo + ')';
        this.conn = connection;
        this.device = connection.getDevice();
        this.sock = socket;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        this.encoder = new PDUEncoder(this, this.out);
        if (this.requestor) {
            this.enterState(State.Sta4);
        } else {
            this.enterState(State.Sta2);
            this.startRequestTimeout();
        }
        this.activate();
    }

    public Device getDevice() {
        return this.device;
    }

    public int nextMessageID() {
        return this.messageID.incrementAndGet() & 0xFFFF;
    }

    private String delim() {
        return this.requestor ? "->" : "<-";
    }

    public String toString() {
        return this.name;
    }

    public final Socket getSocket() {
        return this.sock;
    }

    public final Connection getConnection() {
        return this.conn;
    }

    public final AAssociateRQ getAAssociateRQ() {
        return this.rq;
    }

    public final AAssociateAC getAAssociateAC() {
        return this.ac;
    }

    public final IOException getException() {
        return this.ex;
    }

    public final ApplicationEntity getApplicationEntity() {
        return this.ae;
    }

    public Object getProperty(String string) {
        return this.properties != null ? this.properties.get(string) : null;
    }

    public <T> T getProperty(Class<T> clazz) {
        return (T)this.getProperty(clazz.getName());
    }

    public void setProperty(Object object) {
        this.setProperty(object.getClass().getName(), object);
    }

    public boolean containsProperty(String string) {
        return this.properties != null && this.properties.containsKey(string);
    }

    public Object setProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        return this.properties.put(string, object);
    }

    public Object clearProperty(String string) {
        return this.properties != null ? this.properties.remove(string) : null;
    }

    public final boolean isRequestor() {
        return this.requestor;
    }

    public boolean isReadyForDataTransfer() {
        return this.state == State.Sta6;
    }

    private void checkIsSCP(String string) throws NoRoleSelectionException {
        if (!this.isSCPFor(string)) {
            throw new NoRoleSelectionException(string, TransferCapability.Role.SCP);
        }
    }

    public boolean isSCPFor(String string) {
        RoleSelection roleSelection = this.ac.getRoleSelectionFor(string);
        if (roleSelection == null) {
            return !this.requestor;
        }
        return this.requestor ? roleSelection.isSCP() : roleSelection.isSCU();
    }

    private void checkIsSCU(String string) throws NoRoleSelectionException {
        if (!this.isSCUFor(string)) {
            throw new NoRoleSelectionException(string, TransferCapability.Role.SCU);
        }
    }

    public boolean isSCUFor(String string) {
        RoleSelection roleSelection = this.ac.getRoleSelectionFor(string);
        if (roleSelection == null) {
            return this.requestor;
        }
        return this.requestor ? roleSelection.isSCU() : roleSelection.isSCP();
    }

    public String getCallingAET() {
        return this.rq != null ? this.rq.getCallingAET() : null;
    }

    public String getCalledAET() {
        return this.rq != null ? this.rq.getCalledAET() : null;
    }

    public String getRemoteAET() {
        return this.requestor ? this.getCalledAET() : this.getCallingAET();
    }

    public String getLocalAET() {
        return this.requestor ? this.getCallingAET() : this.getCalledAET();
    }

    public String getRemoteImplVersionName() {
        return (this.requestor ? this.ac : this.rq).getImplVersionName();
    }

    public String getRemoteImplClassUID() {
        return (this.requestor ? this.ac : this.rq).getImplClassUID();
    }

    public String getLocalImplVersionName() {
        return (this.requestor ? this.rq : this.ac).getImplVersionName();
    }

    public String getLocalImplClassUID() {
        return (this.requestor ? this.rq : this.ac).getImplClassUID();
    }

    final int getMaxPDULengthSend() {
        return this.maxPDULength;
    }

    boolean isPackPDV() {
        return this.conn.isPackPDV();
    }

    public void release() throws IOException {
        this.state.writeAReleaseRQ(this);
    }

    public void abort() {
        this.abort(new AAbort());
    }

    void abort(AAbort aAbort) {
        try {
            this.state.write(this, aAbort);
        }
        catch (IOException iOException) {}
    }

    private synchronized void closeSocket() {
        this.state.closeSocket(this);
    }

    void doCloseSocket() {
        LOG.info("{}: close {}", (Object)this.name, (Object)this.sock);
        SafeClose.close(this.sock);
        this.enterState(State.Sta1);
    }

    private synchronized void closeSocketDelayed() {
        this.state.closeSocketDelayed(this);
    }

    void doCloseSocketDelayed() {
        this.enterState(State.Sta13);
        int n = this.conn.getSocketCloseDelay();
        if (n > 0) {
            this.device.schedule(new Runnable(){

                @Override
                public void run() {
                    Association.this.closeSocket();
                }
            }, n, TimeUnit.MILLISECONDS);
        } else {
            this.closeSocket();
        }
    }

    synchronized void onIOException(IOException iOException) {
        if (this.ex != null) {
            return;
        }
        this.ex = iOException;
        LOG.info("{}: i/o exception: {} in State: {}", new Object[]{this.name, iOException, this.state});
        this.closeSocket();
    }

    void write(AAbort aAbort) throws IOException {
        LOG.info("{} << {}", (Object)this.name, (Object)aAbort);
        this.encoder.write(aAbort);
        this.ex = aAbort;
        this.closeSocketDelayed();
    }

    void writeAReleaseRQ() throws IOException {
        LOG.info("{} << A-RELEASE-RQ", (Object)this.name);
        this.enterState(State.Sta7);
        this.stopTimeout();
        this.encoder.writeAReleaseRQ();
        this.startReleaseTimeout();
    }

    private void startRequestTimeout() {
        this.startTimeout("{}: start A-ASSOCIATE-RQ timeout of {}ms", "{}: A-ASSOCIATE-RQ timeout expired", "{}: stop A-ASSOCIATE-RQ timeout", this.conn.getRequestTimeout(), State.Sta2);
    }

    private void startAcceptTimeout() {
        this.startTimeout("{}: start A-ASSOCIATE-AC timeout of {}ms", "{}: A-ASSOCIATE-AC timeout expired", "{}: stop A-ASSOCIATE-AC timeout", this.conn.getAcceptTimeout(), State.Sta5);
    }

    private void startReleaseTimeout() {
        this.startTimeout("{}: start A-RELEASE-RP timeout of {}ms", "{}: A-RELEASE-RP timeout expired", "{}: stop A-RELEASE-RP timeout", this.conn.getReleaseTimeout(), State.Sta7);
    }

    private void startIdleTimeout() {
        this.startTimeout("{}: start idle timeout of {}ms", "{}: idle timeout expired", "{}: stop idle timeout", this.conn.getIdleTimeout(), State.Sta6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTimeout(String string, String string2, String string3, int n, State state) {
        if (n > 0 && this.performing == 0 && this.rspHandlerForMsgId.isEmpty()) {
            Association association = this;
            synchronized (association) {
                if (this.state == state) {
                    this.stopTimeout();
                    this.timeout = Timeout.start(this, string, string2, string3, n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTimeout(int n, int n2) {
        if (n2 > 0) {
            IntHashMap<DimseRSPHandler> intHashMap = this.rspHandlerForMsgId;
            synchronized (intHashMap) {
                DimseRSPHandler dimseRSPHandler = this.rspHandlerForMsgId.get(n);
                if (dimseRSPHandler != null) {
                    dimseRSPHandler.setTimeout(Timeout.start(this, "{}: start " + n + ":DIMSE-RSP timeout of {}ms", "{}: " + n + ":DIMSE-RSP timeout expired", "{}: stop " + n + ":DIMSE-RSP timeout", n2));
                }
            }
        }
    }

    private synchronized void stopTimeout() {
        if (this.timeout != null) {
            this.timeout.stop();
            this.timeout = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForOutstandingRSP() throws InterruptedException {
        IntHashMap<DimseRSPHandler> intHashMap = this.rspHandlerForMsgId;
        synchronized (intHashMap) {
            while (!this.rspHandlerForMsgId.isEmpty()) {
                this.rspHandlerForMsgId.wait();
            }
        }
    }

    void write(AAssociateRQ aAssociateRQ) throws IOException {
        this.name = String.valueOf(aAssociateRQ.getCallingAET()) + this.delim() + aAssociateRQ.getCalledAET() + '(' + this.serialNo + ')';
        this.rq = aAssociateRQ;
        LOG.info("{} << A-ASSOCIATE-RQ", (Object)this.name);
        LOG.debug("{}", (Object)aAssociateRQ);
        this.enterState(State.Sta5);
        this.encoder.write(aAssociateRQ);
        this.startAcceptTimeout();
    }

    private void write(AAssociateAC aAssociateAC) throws IOException {
        LOG.info("{} << A-ASSOCIATE-AC", (Object)this.name);
        LOG.debug("{}", (Object)aAssociateAC);
        this.enterState(State.Sta6);
        this.encoder.write(aAssociateAC);
        this.startIdleTimeout();
    }

    private void write(AAssociateRJ aAssociateRJ) throws IOException {
        LOG.info("{} << {}", (Object)this.name, (Object)aAssociateRJ);
        this.encoder.write(aAssociateRJ);
        this.closeSocketDelayed();
    }

    private void checkException() throws IOException {
        if (this.ex != null) {
            throw this.ex;
        }
    }

    private synchronized void enterState(State state) {
        LOG.debug("{}: enter state: {}", (Object)this.name, (Object)state);
        this.state = state;
        this.notifyAll();
    }

    public final State getState() {
        return this.state;
    }

    synchronized void waitForLeaving(State state) throws InterruptedException, IOException {
        while (this.state == state) {
            this.wait();
        }
        this.checkException();
    }

    synchronized void waitForEntering(State state) throws InterruptedException, IOException {
        while (this.state != state) {
            this.wait();
        }
        this.checkException();
    }

    public void waitForSocketClose() throws InterruptedException, IOException {
        this.waitForEntering(State.Sta1);
    }

    private void activate() {
        this.device.execute(new Runnable(){

            /*
             * Unable to fully structure code
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Association.access$2(Association.this, new PDUDecoder(Association.this, Association.access$1(Association.this)));
                Association.access$3(Association.this).incrementNumberOfOpenAssociations();
                try {
                    try {
                        if (true) ** GOTO lbl8
                        do {
                            Association.access$6(Association.this).nextPDU();
lbl8:
                            // 2 sources

                            if (Association.access$5(Association.this) == State.Sta1) return;
                        } while (Association.access$5(Association.this) != State.Sta13);
                        return;
                    }
                    catch (AAbort var1_1) {
                        Association.this.abort(var1_1);
                        Association.access$4(Association.this);
                        Association.access$3(Association.this).decrementNumberOfOpenAssociations();
                        return;
                    }
                    catch (IOException var1_2) {
                        Association.this.onIOException(var1_2);
                        Association.access$4(Association.this);
                        Association.access$3(Association.this).decrementNumberOfOpenAssociations();
                        return;
                    }
                }
                finally {
                    Association.access$4(Association.this);
                    Association.access$3(Association.this).decrementNumberOfOpenAssociations();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClose() {
        this.stopTimeout();
        IntHashMap<DimseRSPHandler> intHashMap = this.rspHandlerForMsgId;
        synchronized (intHashMap) {
            IntHashMap.Visitor<DimseRSPHandler> visitor = new IntHashMap.Visitor<DimseRSPHandler>(){

                @Override
                public boolean visit(int n, DimseRSPHandler dimseRSPHandler) {
                    dimseRSPHandler.onClose(Association.this);
                    return true;
                }
            };
            this.rspHandlerForMsgId.accept(visitor);
            this.rspHandlerForMsgId.clear();
            this.rspHandlerForMsgId.notifyAll();
        }
        if (this.ae != null) {
            this.ae.getDevice().getAssociationHandler().onClose(this);
        }
    }

    void onAAssociateRQ(AAssociateRQ aAssociateRQ) throws IOException {
        this.name = String.valueOf(aAssociateRQ.getCalledAET()) + this.delim() + aAssociateRQ.getCallingAET() + '(' + this.serialNo + ')';
        LOG.info("{} >> A-ASSOCIATE-RQ", (Object)this.name);
        LOG.debug("{}", (Object)aAssociateRQ);
        this.stopTimeout();
        this.state.onAAssociateRQ(this, aAssociateRQ);
    }

    void handle(AAssociateRQ aAssociateRQ) throws IOException {
        this.rq = aAssociateRQ;
        this.enterState(State.Sta3);
        try {
            this.ae = this.device.getApplicationEntity(aAssociateRQ.getCalledAET());
            this.ac = this.device.getAssociationHandler().negotiate(this, aAssociateRQ);
            this.initPCMap();
            this.maxOpsInvoked = this.ac.getMaxOpsPerformed();
            this.maxPDULength = Association.minZeroAsMax(aAssociateRQ.getMaxPDULength(), this.conn.getSendPDULength());
            this.write(this.ac);
        }
        catch (AAssociateRJ aAssociateRJ) {
            this.write(aAssociateRJ);
        }
    }

    void onAAssociateAC(AAssociateAC aAssociateAC) throws IOException {
        LOG.info("{} >> A-ASSOCIATE-AC", (Object)this.name);
        LOG.debug("{}", (Object)aAssociateAC);
        this.stopTimeout();
        this.state.onAAssociateAC(this, aAssociateAC);
    }

    void handle(AAssociateAC aAssociateAC) throws IOException {
        this.ac = aAssociateAC;
        this.initPCMap();
        this.maxOpsInvoked = aAssociateAC.getMaxOpsInvoked();
        this.maxPDULength = Association.minZeroAsMax(aAssociateAC.getMaxPDULength(), this.conn.getSendPDULength());
        this.enterState(State.Sta6);
        this.startIdleTimeout();
    }

    void onAAssociateRJ(AAssociateRJ aAssociateRJ) throws IOException {
        LOG.info("{} >> {}", (Object)this.name, (Object)aAssociateRJ);
        this.state.onAAssociateRJ(this, aAssociateRJ);
    }

    void handle(AAssociateRJ aAssociateRJ) {
        this.ex = aAssociateRJ;
        this.closeSocket();
    }

    void onAReleaseRQ() throws IOException {
        LOG.info("{} >> A-RELEASE-RQ", (Object)this.name);
        this.stopTimeout();
        this.state.onAReleaseRQ(this);
    }

    void handleAReleaseRQ() throws IOException {
        this.enterState(State.Sta8);
        this.waitForPerformingOps();
        LOG.info("{} << A-RELEASE-RP", (Object)this.name);
        this.encoder.writeAReleaseRP();
        this.closeSocketDelayed();
    }

    private synchronized void waitForPerformingOps() {
        while (this.performing > 0 && this.state == State.Sta8) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    void handleAReleaseRQCollision() throws IOException {
        if (this.isRequestor()) {
            this.enterState(State.Sta9);
            LOG.info("{} << A-RELEASE-RP", (Object)this.name);
            this.encoder.writeAReleaseRP();
            this.enterState(State.Sta11);
        } else {
            this.enterState(State.Sta10);
        }
    }

    void onAReleaseRP() throws IOException {
        LOG.info("{} >> A-RELEASE-RP", (Object)this.name);
        this.stopTimeout();
        this.state.onAReleaseRP(this);
    }

    void handleAReleaseRP() throws IOException {
        this.closeSocket();
    }

    void handleAReleaseRPCollision() throws IOException {
        this.enterState(State.Sta12);
        LOG.info("{} << A-RELEASE-RP", (Object)this.name);
        this.encoder.writeAReleaseRP();
        this.closeSocketDelayed();
    }

    void onAAbort(AAbort aAbort) {
        LOG.info("{} >> {}", (Object)this.name, (Object)aAbort);
        this.stopTimeout();
        this.ex = aAbort;
        this.closeSocket();
    }

    void unexpectedPDU(String string) throws AAbort {
        LOG.warn("{} >> unexpected {} in state: {}", new Object[]{this.name, string, this.state});
        throw new AAbort(2, 2);
    }

    void onPDataTF() throws IOException {
        this.state.onPDataTF(this);
    }

    void handlePDataTF() throws IOException {
        this.decoder.decodeDIMSE();
    }

    void writePDataTF() throws IOException {
        this.checkException();
        this.state.writePDataTF(this);
    }

    void doWritePDataTF() throws IOException {
        this.encoder.writePDataTF();
    }

    void onDimseRQ(PresentationContext presentationContext, Dimse dimse, Attributes attributes, PDVInputStream pDVInputStream) throws IOException {
        this.stopTimeout();
        this.incPerforming();
        this.ae.onDimseRQ(this, presentationContext, dimse, attributes, pDVInputStream);
    }

    private synchronized void incPerforming() {
        ++this.performing;
    }

    private synchronized void decPerforming() {
        --this.performing;
        this.notifyAll();
    }

    void onDimseRSP(Dimse dimse, Attributes attributes, Attributes attributes2) throws AAbort {
        int n = attributes.getInt(288, -1);
        int n2 = attributes.getInt(2304, 0);
        boolean bl = Status.isPending(n2);
        DimseRSPHandler dimseRSPHandler = this.getDimseRSPHandler(n);
        if (dimseRSPHandler == null) {
            Dimse.LOG.info("{}: unexpected message ID in DIMSE RSP:", (Object)this.name);
            Dimse.LOG.info("\n{}", (Object)attributes);
            throw new AAbort();
        }
        dimseRSPHandler.onDimseRSP(this, attributes, attributes2);
        if (bl) {
            this.startTimeout(n, dimse.isRetrieveRQ() ? this.conn.getRetrieveTimeout() : this.conn.getResponseTimeout());
        } else {
            this.removeDimseRSPHandler(n);
            if (this.rspHandlerForMsgId.isEmpty() && this.performing == 0) {
                this.startIdleOrReleaseTimeout();
            }
        }
    }

    private synchronized void startIdleOrReleaseTimeout() {
        if (this.state == State.Sta6) {
            this.startIdleTimeout();
        } else if (this.state == State.Sta7) {
            this.startReleaseTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDimseRSPHandler(DimseRSPHandler dimseRSPHandler) throws InterruptedException {
        IntHashMap<DimseRSPHandler> intHashMap = this.rspHandlerForMsgId;
        synchronized (intHashMap) {
            while (this.maxOpsInvoked > 0 && this.rspHandlerForMsgId.size() >= this.maxOpsInvoked) {
                this.rspHandlerForMsgId.wait();
            }
            this.rspHandlerForMsgId.put(dimseRSPHandler.getMessageID(), dimseRSPHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DimseRSPHandler getDimseRSPHandler(int n) {
        IntHashMap<DimseRSPHandler> intHashMap = this.rspHandlerForMsgId;
        synchronized (intHashMap) {
            return this.rspHandlerForMsgId.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DimseRSPHandler removeDimseRSPHandler(int n) {
        IntHashMap<DimseRSPHandler> intHashMap = this.rspHandlerForMsgId;
        synchronized (intHashMap) {
            DimseRSPHandler dimseRSPHandler = this.rspHandlerForMsgId.remove(n);
            this.rspHandlerForMsgId.notifyAll();
            return dimseRSPHandler;
        }
    }

    void cancel(PresentationContext presentationContext, int n) throws IOException {
        Attributes attributes = Commands.mkCCancelRQ(n);
        this.encoder.writeDIMSE(presentationContext, attributes, null);
    }

    public boolean tryWriteDimseRSP(PresentationContext presentationContext, Attributes attributes) {
        return this.tryWriteDimseRSP(presentationContext, attributes, null);
    }

    public boolean tryWriteDimseRSP(PresentationContext presentationContext, Attributes attributes, Attributes attributes2) {
        try {
            this.writeDimseRSP(presentationContext, attributes, attributes2);
            return true;
        }
        catch (IOException iOException) {
            LOG.warn("{} << {} failed: {}", new Object[]{this, Dimse.valueOf(attributes.getInt(256, 0)), iOException.getMessage()});
            return false;
        }
    }

    public void writeDimseRSP(PresentationContext presentationContext, Attributes attributes) throws IOException {
        this.writeDimseRSP(presentationContext, attributes, null);
    }

    public void writeDimseRSP(PresentationContext presentationContext, Attributes attributes, Attributes attributes2) throws IOException {
        DataWriterAdapter dataWriterAdapter = null;
        int n = 257;
        if (attributes2 != null) {
            dataWriterAdapter = new DataWriterAdapter(attributes2);
            n = Commands.getWithDatasetType();
        }
        attributes.setInt(2048, VR.US, n);
        this.encoder.writeDIMSE(presentationContext, attributes, dataWriterAdapter);
        if (!Status.isPending(attributes.getInt(2304, 0))) {
            this.decPerforming();
            this.startIdleTimeout();
        }
    }

    void onCancelRQ(Attributes attributes) throws IOException {
        int n = attributes.getInt(288, -1);
        CancelRQHandler cancelRQHandler = this.removeCancelRQHandler(n);
        if (cancelRQHandler != null) {
            cancelRQHandler.onCancelRQ(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCancelRQHandler(int n, CancelRQHandler cancelRQHandler) {
        IntHashMap<CancelRQHandler> intHashMap = this.cancelHandlerForMsgId;
        synchronized (intHashMap) {
            this.cancelHandlerForMsgId.put(n, cancelRQHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CancelRQHandler removeCancelRQHandler(int n) {
        IntHashMap<CancelRQHandler> intHashMap = this.cancelHandlerForMsgId;
        synchronized (intHashMap) {
            return this.cancelHandlerForMsgId.remove(n);
        }
    }

    private void initPCMap() {
        for (PresentationContext presentationContext : this.ac.getPresentationContexts()) {
            if (!presentationContext.isAccepted()) continue;
            this.initTSMap(this.rq.getPresentationContext(presentationContext.getPCID()).getAbstractSyntax()).put(presentationContext.getTransferSyntax(), presentationContext);
        }
    }

    private HashMap<String, PresentationContext> initTSMap(String string) {
        HashMap<String, PresentationContext> hashMap = this.pcMap.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.pcMap.put(string, hashMap);
        }
        return hashMap;
    }

    private PresentationContext pcFor(String string, String string2) throws NoPresentationContextException {
        HashMap<String, PresentationContext> hashMap = this.pcMap.get(string);
        if (hashMap == null) {
            throw new NoPresentationContextException(string);
        }
        if (string2 == null) {
            return hashMap.values().iterator().next();
        }
        PresentationContext presentationContext = hashMap.get(string2);
        if (presentationContext == null) {
            throw new NoPresentationContextException(string, string2);
        }
        return presentationContext;
    }

    public Set<String> getTransferSyntaxesFor(String string) {
        HashMap<String, PresentationContext> hashMap = this.pcMap.get(string);
        if (hashMap == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(hashMap.keySet());
    }

    PresentationContext getPresentationContext(int n) {
        return this.ac.getPresentationContext(n);
    }

    public CommonExtendedNegotiation getCommonExtendedNegotiationFor(String string) {
        return this.ac.getCommonExtendedNegotiationFor(string);
    }

    public void cstore(String string, String string2, int n, DataWriter dataWriter, String string3, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        this.cstore(string, string, string2, n, dataWriter, string3, dimseRSPHandler);
    }

    public void cstore(String string, String string2, String string3, int n, DataWriter dataWriter, String string4, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        PresentationContext presentationContext = this.pcFor(string, string4);
        this.checkIsSCU(string2);
        Attributes attributes = Commands.mkCStoreRQ(dimseRSPHandler.getMessageID(), string2, string3, n);
        this.invoke(presentationContext, attributes, dataWriter, dimseRSPHandler, this.conn.getResponseTimeout());
    }

    public DimseRSP cstore(String string, String string2, int n, DataWriter dataWriter, String string3) throws IOException, InterruptedException {
        return this.cstore(string, string, string2, n, dataWriter, string3);
    }

    public DimseRSP cstore(String string, String string2, String string3, int n, DataWriter dataWriter, String string4) throws IOException, InterruptedException {
        FutureDimseRSP futureDimseRSP = new FutureDimseRSP(this.nextMessageID());
        this.cstore(string, string2, string3, n, dataWriter, string4, futureDimseRSP);
        return futureDimseRSP;
    }

    public void cstore(String string, String string2, int n, String string3, int n2, DataWriter dataWriter, String string4, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        this.cstore(string, string, string2, n, string3, n2, dataWriter, string4, dimseRSPHandler);
    }

    public void cstore(String string, String string2, String string3, int n, String string4, int n2, DataWriter dataWriter, String string5, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        PresentationContext presentationContext = this.pcFor(string, string5);
        Attributes attributes = Commands.mkCStoreRQ(dimseRSPHandler.getMessageID(), string2, string3, n, string4, n2);
        this.invoke(presentationContext, attributes, dataWriter, dimseRSPHandler, this.conn.getResponseTimeout());
    }

    public DimseRSP cstore(String string, String string2, int n, String string3, int n2, DataWriter dataWriter, String string4) throws IOException, InterruptedException {
        return this.cstore(string, string, string2, n, string3, n2, dataWriter, string4);
    }

    public DimseRSP cstore(String string, String string2, String string3, int n, String string4, int n2, DataWriter dataWriter, String string5) throws IOException, InterruptedException {
        FutureDimseRSP futureDimseRSP = new FutureDimseRSP(this.nextMessageID());
        this.cstore(string, string2, string3, n, string4, n2, dataWriter, string5, futureDimseRSP);
        return futureDimseRSP;
    }

    public void cfind(String string, int n, Attributes attributes, String string2, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        this.cfind(string, string, n, attributes, string2, dimseRSPHandler);
    }

    public void cfind(String string, String string2, int n, Attributes attributes, String string3, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        PresentationContext presentationContext = this.pcFor(string, string3);
        this.checkIsSCU(string2);
        Attributes attributes2 = Commands.mkCFindRQ(dimseRSPHandler.getMessageID(), string2, n);
        this.invoke(presentationContext, attributes2, new DataWriterAdapter(attributes), dimseRSPHandler, this.conn.getResponseTimeout());
    }

    public DimseRSP cfind(String string, int n, Attributes attributes, String string2, int n2) throws IOException, InterruptedException {
        return this.cfind(string, string, n, attributes, string2, n2);
    }

    public DimseRSP cfind(String string, String string2, int n, Attributes attributes, String string3, int n2) throws IOException, InterruptedException {
        FutureDimseRSP futureDimseRSP = new FutureDimseRSP(this.nextMessageID());
        futureDimseRSP.setAutoCancel(n2);
        this.cfind(string, string2, n, attributes, string3, futureDimseRSP);
        return futureDimseRSP;
    }

    public void cget(String string, int n, Attributes attributes, String string2, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        this.cget(string, string, n, attributes, string2, dimseRSPHandler);
    }

    public void cget(String string, String string2, int n, Attributes attributes, String string3, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        PresentationContext presentationContext = this.pcFor(string, string3);
        this.checkIsSCU(string2);
        Attributes attributes2 = Commands.mkCGetRQ(dimseRSPHandler.getMessageID(), string2, n);
        this.invoke(presentationContext, attributes2, new DataWriterAdapter(attributes), dimseRSPHandler, this.conn.getRetrieveTimeout());
    }

    public DimseRSP cget(String string, int n, Attributes attributes, String string2) throws IOException, InterruptedException {
        return this.cget(string, string, n, attributes, string2);
    }

    public DimseRSP cget(String string, String string2, int n, Attributes attributes, String string3) throws IOException, InterruptedException {
        FutureDimseRSP futureDimseRSP = new FutureDimseRSP(this.nextMessageID());
        this.cget(string, string2, n, attributes, string3, futureDimseRSP);
        return futureDimseRSP;
    }

    public void cmove(String string, int n, Attributes attributes, String string2, String string3, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        this.cmove(string, string, n, attributes, string2, string3, dimseRSPHandler);
    }

    public void cmove(String string, String string2, int n, Attributes attributes, String string3, String string4, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        PresentationContext presentationContext = this.pcFor(string, string3);
        this.checkIsSCU(string2);
        Attributes attributes2 = Commands.mkCMoveRQ(dimseRSPHandler.getMessageID(), string2, n, string4);
        this.invoke(presentationContext, attributes2, new DataWriterAdapter(attributes), dimseRSPHandler, this.conn.getRetrieveTimeout());
    }

    public DimseRSP cmove(String string, int n, Attributes attributes, String string2, String string3) throws IOException, InterruptedException {
        return this.cmove(string, string, n, attributes, string2, string3);
    }

    public DimseRSP cmove(String string, String string2, int n, Attributes attributes, String string3, String string4) throws IOException, InterruptedException {
        FutureDimseRSP futureDimseRSP = new FutureDimseRSP(this.nextMessageID());
        this.cmove(string, string2, n, attributes, string3, string4, futureDimseRSP);
        return futureDimseRSP;
    }

    public DimseRSP cecho() throws IOException, InterruptedException {
        return this.cecho("1.2.840.10008.1.1");
    }

    public DimseRSP cecho(String string) throws IOException, InterruptedException {
        FutureDimseRSP futureDimseRSP = new FutureDimseRSP(this.nextMessageID());
        PresentationContext presentationContext = this.pcFor(string, null);
        this.checkIsSCU(string);
        Attributes attributes = Commands.mkCEchoRQ(futureDimseRSP.getMessageID(), string);
        this.invoke(presentationContext, attributes, null, futureDimseRSP, this.conn.getResponseTimeout());
        return futureDimseRSP;
    }

    public void neventReport(String string, String string2, int n, Attributes attributes, String string3, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        this.neventReport(string, string, string2, n, attributes, string3, dimseRSPHandler);
    }

    public void neventReport(String string, String string2, String string3, int n, Attributes attributes, String string4, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        PresentationContext presentationContext = this.pcFor(string, string4);
        this.checkIsSCP(string2);
        Attributes attributes2 = Commands.mkNEventReportRQ(dimseRSPHandler.getMessageID(), string2, string3, n, attributes);
        this.invoke(presentationContext, attributes2, DataWriterAdapter.forAttributes(attributes), dimseRSPHandler, this.conn.getResponseTimeout());
    }

    public DimseRSP neventReport(String string, String string2, int n, Attributes attributes, String string3) throws IOException, InterruptedException {
        return this.neventReport(string, string, string2, n, attributes, string3);
    }

    public DimseRSP neventReport(String string, String string2, String string3, int n, Attributes attributes, String string4) throws IOException, InterruptedException {
        FutureDimseRSP futureDimseRSP = new FutureDimseRSP(this.nextMessageID());
        this.neventReport(string, string2, string3, n, attributes, string4, futureDimseRSP);
        return futureDimseRSP;
    }

    public void nget(String string, String string2, int[] nArray, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        this.nget(string, string, string2, nArray, dimseRSPHandler);
    }

    public void nget(String string, String string2, String string3, int[] nArray, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        PresentationContext presentationContext = this.pcFor(string, null);
        this.checkIsSCU(string2);
        Attributes attributes = Commands.mkNGetRQ(dimseRSPHandler.getMessageID(), string2, string3, nArray);
        this.invoke(presentationContext, attributes, null, dimseRSPHandler, this.conn.getResponseTimeout());
    }

    public DimseRSP nget(String string, String string2, int[] nArray) throws IOException, InterruptedException {
        return this.nget(string, string, string2, nArray);
    }

    public DimseRSP nget(String string, String string2, String string3, int[] nArray) throws IOException, InterruptedException {
        FutureDimseRSP futureDimseRSP = new FutureDimseRSP(this.nextMessageID());
        this.nget(string, string2, string3, nArray, futureDimseRSP);
        return futureDimseRSP;
    }

    public void nset(String string, String string2, Attributes attributes, String string3, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        this.nset(string, string, string2, new DataWriterAdapter(attributes), string3, dimseRSPHandler);
    }

    public void nset(String string, String string2, String string3, Attributes attributes, String string4, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        this.nset(string, string2, string3, new DataWriterAdapter(attributes), string4, dimseRSPHandler);
    }

    public DimseRSP nset(String string, String string2, Attributes attributes, String string3) throws IOException, InterruptedException {
        return this.nset(string, string, string2, new DataWriterAdapter(attributes), string3);
    }

    public DimseRSP nset(String string, String string2, String string3, Attributes attributes, String string4) throws IOException, InterruptedException {
        return this.nset(string, string2, string3, new DataWriterAdapter(attributes), string4);
    }

    public void nset(String string, String string2, DataWriter dataWriter, String string3, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        this.nset(string, string, string2, dataWriter, string3, dimseRSPHandler);
    }

    public void nset(String string, String string2, String string3, DataWriter dataWriter, String string4, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        PresentationContext presentationContext = this.pcFor(string, string4);
        this.checkIsSCU(string2);
        Attributes attributes = Commands.mkNSetRQ(dimseRSPHandler.getMessageID(), string2, string3);
        this.invoke(presentationContext, attributes, dataWriter, dimseRSPHandler, this.conn.getResponseTimeout());
    }

    public DimseRSP nset(String string, String string2, DataWriter dataWriter, String string3) throws IOException, InterruptedException {
        return this.nset(string, string, string2, dataWriter, string3);
    }

    public DimseRSP nset(String string, String string2, String string3, DataWriter dataWriter, String string4) throws IOException, InterruptedException {
        FutureDimseRSP futureDimseRSP = new FutureDimseRSP(this.nextMessageID());
        this.nset(string, string2, string3, dataWriter, string4, (DimseRSPHandler)futureDimseRSP);
        return futureDimseRSP;
    }

    public void naction(String string, String string2, int n, Attributes attributes, String string3, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        this.naction(string, string, string2, n, attributes, string3, dimseRSPHandler);
    }

    public void naction(String string, String string2, String string3, int n, Attributes attributes, String string4, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        PresentationContext presentationContext = this.pcFor(string, string4);
        this.checkIsSCU(string2);
        Attributes attributes2 = Commands.mkNActionRQ(dimseRSPHandler.getMessageID(), string2, string3, n, attributes);
        this.invoke(presentationContext, attributes2, DataWriterAdapter.forAttributes(attributes), dimseRSPHandler, this.conn.getResponseTimeout());
    }

    public DimseRSP naction(String string, String string2, int n, Attributes attributes, String string3) throws IOException, InterruptedException {
        return this.naction(string, string, string2, n, attributes, string3);
    }

    public DimseRSP naction(String string, String string2, String string3, int n, Attributes attributes, String string4) throws IOException, InterruptedException {
        FutureDimseRSP futureDimseRSP = new FutureDimseRSP(this.nextMessageID());
        this.naction(string, string2, string3, n, attributes, string4, futureDimseRSP);
        return futureDimseRSP;
    }

    public void ncreate(String string, String string2, Attributes attributes, String string3, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        this.ncreate(string, string, string2, attributes, string3, dimseRSPHandler);
    }

    public void ncreate(String string, String string2, String string3, Attributes attributes, String string4, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        PresentationContext presentationContext = this.pcFor(string, string4);
        this.checkIsSCU(string2);
        Attributes attributes2 = Commands.mkNCreateRQ(dimseRSPHandler.getMessageID(), string2, string3);
        this.invoke(presentationContext, attributes2, DataWriterAdapter.forAttributes(attributes), dimseRSPHandler, this.conn.getResponseTimeout());
    }

    public DimseRSP ncreate(String string, String string2, Attributes attributes, String string3) throws IOException, InterruptedException {
        return this.ncreate(string, string, string2, attributes, string3);
    }

    public DimseRSP ncreate(String string, String string2, String string3, Attributes attributes, String string4) throws IOException, InterruptedException {
        FutureDimseRSP futureDimseRSP = new FutureDimseRSP(this.nextMessageID());
        this.ncreate(string, string2, string3, attributes, string4, futureDimseRSP);
        return futureDimseRSP;
    }

    public void ndelete(String string, String string2, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        this.ndelete(string, string, string2, dimseRSPHandler);
    }

    public void ndelete(String string, String string2, String string3, DimseRSPHandler dimseRSPHandler) throws IOException, InterruptedException {
        PresentationContext presentationContext = this.pcFor(string, null);
        this.checkIsSCU(string2);
        Attributes attributes = Commands.mkNDeleteRQ(dimseRSPHandler.getMessageID(), string2, string3);
        this.invoke(presentationContext, attributes, null, dimseRSPHandler, this.conn.getResponseTimeout());
    }

    public DimseRSP ndelete(String string, String string2) throws IOException, InterruptedException {
        return this.ndelete(string, string, string2);
    }

    public DimseRSP ndelete(String string, String string2, String string3) throws IOException, InterruptedException {
        FutureDimseRSP futureDimseRSP = new FutureDimseRSP(this.nextMessageID());
        this.ndelete(string, string2, string3, futureDimseRSP);
        return futureDimseRSP;
    }

    private void invoke(PresentationContext presentationContext, Attributes attributes, DataWriter dataWriter, DimseRSPHandler dimseRSPHandler, int n) throws IOException, InterruptedException {
        this.stopTimeout();
        this.checkException();
        dimseRSPHandler.setPC(presentationContext);
        this.addDimseRSPHandler(dimseRSPHandler);
        this.encoder.writeDIMSE(presentationContext, attributes, dataWriter);
        this.startTimeout(dimseRSPHandler.getMessageID(), n);
    }

    static int minZeroAsMax(int n, int n2) {
        return n == 0 ? n2 : (n2 == 0 ? n : Math.min(n, n2));
    }

    public Attributes createFileMetaInformation(String string, String string2, String string3) {
        Attributes attributes = new Attributes(7);
        byte[] byArray = new byte[2];
        byArray[1] = 1;
        attributes.setBytes(131073, VR.OB, byArray);
        attributes.setString(131074, VR.UI, string2);
        attributes.setString(131075, VR.UI, string);
        attributes.setString(131088, VR.UI, string3);
        attributes.setString(131090, VR.UI, this.getRemoteImplClassUID());
        String string4 = this.getRemoteImplVersionName();
        if (string4 != null) {
            attributes.setString(131091, VR.SH, string4);
        }
        attributes.setString(131094, VR.SH, this.getRemoteAET());
        return attributes;
    }

    static /* synthetic */ InputStream access$1(Association association) {
        return association.in;
    }

    static /* synthetic */ void access$2(Association association, PDUDecoder pDUDecoder) {
        association.decoder = pDUDecoder;
    }

    static /* synthetic */ Device access$3(Association association) {
        return association.device;
    }

    static /* synthetic */ void access$4(Association association) {
        association.onClose();
    }

    static /* synthetic */ State access$5(Association association) {
        return association.state;
    }

    static /* synthetic */ PDUDecoder access$6(Association association) {
        return association.decoder;
    }
}

