/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net;

import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.util.UIDUtils;

public class Commands {
    public static final int NO_DATASET = 257;
    private static int withDatasetType = 0;

    public static Attributes mkCStoreRQ(int n, String string, String string2, int n2) {
        Attributes attributes = Commands.mkRQ(n, 1, withDatasetType);
        attributes.setString(2, VR.UI, string);
        attributes.setString(4096, VR.UI, string2);
        attributes.setInt(1792, VR.US, n2);
        return attributes;
    }

    public static Attributes mkCStoreRQ(int n, String string, String string2, int n2, String string3, int n3) {
        Attributes attributes = Commands.mkCStoreRQ(n, string, string2, n2);
        attributes.setString(4144, VR.AE, string3);
        attributes.setInt(4145, VR.US, n3);
        return attributes;
    }

    public static Attributes mkCStoreRSP(Attributes attributes, int n) {
        return Commands.mkRSP(attributes, n, Dimse.C_STORE_RQ);
    }

    public static Attributes mkCFindRQ(int n, String string, int n2) {
        Attributes attributes = Commands.mkRQ(n, 32, withDatasetType);
        attributes.setString(2, VR.UI, string);
        attributes.setInt(1792, VR.US, n2);
        return attributes;
    }

    public static Attributes mkCFindRSP(Attributes attributes, int n) {
        return Commands.mkRSP(attributes, n, Dimse.C_FIND_RQ);
    }

    public static Attributes mkCGetRQ(int n, String string, int n2) {
        Attributes attributes = Commands.mkRQ(n, 16, withDatasetType);
        attributes.setString(2, VR.UI, string);
        attributes.setInt(1792, VR.US, n2);
        return attributes;
    }

    public static Attributes mkCGetRSP(Attributes attributes, int n) {
        return Commands.mkRSP(attributes, n, Dimse.C_GET_RQ);
    }

    public static Attributes mkCMoveRQ(int n, String string, int n2, String string2) {
        Attributes attributes = Commands.mkRQ(n, 33, withDatasetType);
        attributes.setString(2, VR.UI, string);
        attributes.setInt(1792, VR.US, n2);
        attributes.setString(1536, VR.AE, string2);
        return attributes;
    }

    public static Attributes mkCMoveRSP(Attributes attributes, int n) {
        return Commands.mkRSP(attributes, n, Dimse.C_MOVE_RQ);
    }

    public static Attributes mkCCancelRQ(int n) {
        Attributes attributes = new Attributes();
        attributes.setInt(256, VR.US, Dimse.C_CANCEL_RQ.commandField());
        attributes.setInt(2048, VR.US, 257);
        attributes.setInt(288, VR.US, n);
        return attributes;
    }

    public static Attributes mkCEchoRQ(int n, String string) {
        Attributes attributes = Commands.mkRQ(n, 48, 257);
        attributes.setString(2, VR.UI, string);
        return attributes;
    }

    public static Attributes mkEchoRSP(Attributes attributes, int n) {
        return Commands.mkRSP(attributes, n, Dimse.C_ECHO_RQ);
    }

    public static Attributes mkNEventReportRQ(int n, String string, String string2, int n2, Attributes attributes) {
        Attributes attributes2 = Commands.mkRQ(n, 256, attributes == null ? 257 : withDatasetType);
        attributes2.setString(2, VR.UI, string);
        attributes2.setString(4096, VR.UI, string2);
        attributes2.setInt(4098, VR.US, n2);
        return attributes2;
    }

    public static Attributes mkNEventReportRSP(Attributes attributes, int n) {
        return Commands.mkRSP(attributes, n, Dimse.N_EVENT_REPORT_RQ);
    }

    public static Attributes mkNGetRQ(int n, String string, String string2, int[] nArray) {
        Attributes attributes = Commands.mkRQ(n, 272, 257);
        attributes.setString(3, VR.UI, string);
        attributes.setString(4097, VR.UI, string2);
        if (nArray != null) {
            attributes.setInt(4101, VR.AT, nArray);
        }
        return attributes;
    }

    public static Attributes mkNGetRSP(Attributes attributes, int n) {
        return Commands.mkRSP(attributes, n, Dimse.N_GET_RQ);
    }

    public static Attributes mkNSetRQ(int n, String string, String string2) {
        Attributes attributes = Commands.mkRQ(n, 288, withDatasetType);
        attributes.setString(3, VR.UI, string);
        attributes.setString(4097, VR.UI, string2);
        return attributes;
    }

    public static Attributes mkNSetRSP(Attributes attributes, int n) {
        return Commands.mkRSP(attributes, n, Dimse.N_SET_RQ);
    }

    public static Attributes mkNActionRQ(int n, String string, String string2, int n2, Attributes attributes) {
        Attributes attributes2 = Commands.mkRQ(n, 304, attributes == null ? 257 : withDatasetType);
        attributes2.setString(3, VR.UI, string);
        attributes2.setString(4097, VR.UI, string2);
        attributes2.setInt(4104, VR.US, n2);
        return attributes2;
    }

    public static Attributes mkNActionRSP(Attributes attributes, int n) {
        return Commands.mkRSP(attributes, n, Dimse.N_ACTION_RQ);
    }

    public static Attributes mkNCreateRQ(int n, String string, String string2) {
        Attributes attributes = Commands.mkRQ(n, 320, withDatasetType);
        attributes.setString(2, VR.UI, string);
        if (string2 != null) {
            attributes.setString(4096, VR.UI, string2);
        }
        return attributes;
    }

    public static Attributes mkNCreateRSP(Attributes attributes, int n) {
        String string = attributes.getString(4096);
        if (string == null) {
            attributes.setString(4096, VR.UI, UIDUtils.createUID());
        }
        return Commands.mkRSP(attributes, n, Dimse.N_CREATE_RQ);
    }

    public static Attributes mkNDeleteRQ(int n, String string, String string2) {
        Attributes attributes = Commands.mkRQ(n, 336, 257);
        attributes.setString(3, VR.UI, string);
        attributes.setString(4097, VR.UI, string2);
        return attributes;
    }

    public static Attributes mkNDeleteRSP(Attributes attributes, int n) {
        return Commands.mkRSP(attributes, n, Dimse.N_DELETE_RQ);
    }

    private static Attributes mkRQ(int n, int n2, int n3) {
        Attributes attributes = new Attributes();
        attributes.setInt(272, VR.US, n);
        attributes.setInt(256, VR.US, n2);
        attributes.setInt(2048, VR.US, n3);
        return attributes;
    }

    public static Attributes mkRSP(Attributes attributes, int n, Dimse dimse) {
        Attributes attributes2 = new Attributes();
        attributes2.setInt(256, VR.US, dimse.commandFieldOfRSP());
        attributes2.setInt(2304, VR.US, n);
        attributes2.setInt(288, VR.US, attributes.getInt(272, 0));
        attributes2.setString(2, VR.UI, attributes.getString(dimse.tagOfSOPClassUID()));
        int n2 = dimse.tagOfSOPInstanceUID();
        if (n2 != 0) {
            attributes2.setString(4096, VR.UI, attributes.getString(n2));
        }
        return attributes2;
    }

    public static void initNumberOfSuboperations(Attributes attributes, int n) {
        attributes.setInt(4128, VR.US, n);
        attributes.setInt(4129, VR.US, 0);
        attributes.setInt(4130, VR.US, 0);
        attributes.setInt(4131, VR.US, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incNumberOfSuboperations(int n, Attributes attributes) {
        Attributes attributes2 = attributes;
        synchronized (attributes2) {
            attributes.setInt(n, VR.US, attributes.getInt(n, 0) + 1);
            attributes.setInt(4128, VR.US, attributes.getInt(4128, 1) - 1);
        }
    }

    public static int getWithDatasetType() {
        return withDatasetType;
    }

    public static void setWithDatasetType(int n) {
        if (n == 257 || (n & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("withDatasetType: " + Integer.toHexString(n) + "H");
        }
        withDatasetType = n;
    }

    public static boolean hasDataset(Attributes attributes) {
        return attributes.getInt(2048, 0) != 257;
    }
}

